/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.lucene.internal.directory.RegionDirectory;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.ChunkKey;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.File;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexRepository;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexRepositoryImpl;
import com.gemstone.gemfire.cache.lucene.internal.repository.RepositoryManager;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.LuceneSerializer;
import com.gemstone.gemfire.internal.cache.BucketNotFoundException;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.util.concurrent.CopyOnWriteHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;

public class PartitionedRepositoryManager
implements RepositoryManager {
    CopyOnWriteHashMap<Integer, IndexRepository> indexRepositories = new CopyOnWriteHashMap();
    private final PartitionedRegion userRegion;
    private final PartitionedRegion fileRegion;
    private final PartitionedRegion chunkRegion;
    private final LuceneSerializer serializer;
    private final Analyzer analyzer;

    public PartitionedRepositoryManager(PartitionedRegion userRegion, PartitionedRegion fileRegion, PartitionedRegion chunkRegion, LuceneSerializer serializer, Analyzer analyzer) {
        this.userRegion = userRegion;
        this.fileRegion = fileRegion;
        this.chunkRegion = chunkRegion;
        this.serializer = serializer;
        this.analyzer = analyzer;
    }

    @Override
    public IndexRepository getRepository(Region region, Object key, Object callbackArg) throws BucketNotFoundException {
        BucketRegion userBucket = this.userRegion.getBucketRegion(key, callbackArg);
        if (userBucket == null) {
            throw new BucketNotFoundException("User bucket was not found for region " + region + "key " + key + " callbackarg " + callbackArg);
        }
        return this.getRepository(userBucket.getId());
    }

    @Override
    public Collection<IndexRepository> getRepositories(RegionFunctionContext ctx) throws BucketNotFoundException {
        Region region = ctx.getDataSet();
        Set buckets = ((InternalRegionFunctionContext)ctx).getLocalBucketSet(region);
        ArrayList<IndexRepository> repos = new ArrayList<IndexRepository>(buckets.size());
        for (Integer bucketId : buckets) {
            BucketRegion userBucket = this.userRegion.getDataStore().getLocalBucketById(bucketId);
            if (userBucket == null) {
                throw new BucketNotFoundException("User bucket was not found for region " + region + "bucket id " + bucketId);
            }
            repos.add(this.getRepository(userBucket.getId()));
        }
        return repos;
    }

    private IndexRepository getRepository(Integer bucketId) throws BucketNotFoundException {
        IndexRepository repo = (IndexRepository)this.indexRepositories.get((Object)bucketId);
        if (repo != null && repo.isClosed()) {
            this.indexRepositories.remove((Object)bucketId, (Object)repo);
            repo = null;
        }
        if (repo == null) {
            try {
                BucketRegion fileBucket = this.getMatchingBucket(this.fileRegion, bucketId);
                BucketRegion chunkBucket = this.getMatchingBucket(this.chunkRegion, bucketId);
                RegionDirectory dir = new RegionDirectory((ConcurrentMap<String, File>)fileBucket, (ConcurrentMap<ChunkKey, byte[]>)chunkBucket);
                IndexWriterConfig config = new IndexWriterConfig(this.analyzer);
                IndexWriter writer = new IndexWriter((Directory)dir, config);
                repo = new IndexRepositoryImpl((Region<?, ?>)fileBucket, writer, this.serializer);
                IndexRepository oldRepo = (IndexRepository)this.indexRepositories.putIfAbsent((Object)bucketId, (Object)repo);
                if (oldRepo != null) {
                    repo = oldRepo;
                }
            }
            catch (IOException e) {
                throw new InternalGemFireError("Unable to create index repository", (Throwable)e);
            }
        }
        return repo;
    }

    private BucketRegion getMatchingBucket(PartitionedRegion region, Integer bucketId) throws BucketNotFoundException {
        region.getOrCreateNodeForBucketWrite(bucketId.intValue(), null);
        BucketRegion result = region.getDataStore().getLocalBucketById(bucketId);
        if (result == null) {
            throw new BucketNotFoundException("Bucket not found for region " + region + " bucekt id " + bucketId);
        }
        return result;
    }
}

