/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.internal.InternalLuceneIndex;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.ChunkKey;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.File;
import com.gemstone.gemfire.cache.lucene.internal.repository.RepositoryManager;
import com.gemstone.gemfire.cache.lucene.internal.xml.LuceneIndexCreation;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.extension.Extension;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public abstract class LuceneIndexImpl
implements InternalLuceneIndex {
    protected static final Logger logger = LogService.getLogger();
    String[] searchableFieldNames;
    protected RepositoryManager repositoryManager;
    protected Analyzer analyzer;
    Region<String, File> fileRegion;
    Region<ChunkKey, byte[]> chunkRegion;
    protected String indexName;
    protected String regionPath;
    protected boolean hasInitialized = false;

    @Override
    public String getName() {
        return this.indexName;
    }

    @Override
    public String getRegionPath() {
        return this.regionPath;
    }

    protected void setSearchableFields(String[] fields) {
        this.searchableFieldNames = fields;
    }

    @Override
    public String[] getFieldNames() {
        return this.searchableFieldNames;
    }

    @Override
    public Map<String, Analyzer> getFieldAnalyzerMap() {
        return null;
    }

    @Override
    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer == null ? new StandardAnalyzer() : analyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    protected abstract void initialize();

    protected void addExtension(PartitionedRegion dataRegion) {
        LuceneIndexCreation creation = new LuceneIndexCreation();
        creation.setName(this.getName());
        creation.addFieldNames(this.getFieldNames());
        creation.setRegion((Region)dataRegion);
        creation.setFieldFieldAnalyzerMap(this.getFieldAnalyzerMap());
        dataRegion.getExtensionPoint().addExtension((Extension)creation);
    }
}

