/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.rest.internal.web.controllers;

import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.rest.internal.web.controllers.AbstractBaseController;
import com.gemstone.gemfire.rest.internal.web.exception.GemfireRestException;
import com.gemstone.gemfire.rest.internal.web.util.ArrayUtils;
import com.gemstone.gemfire.rest.internal.web.util.JSONUtils;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller(value="functionController")
@Api(value="functions", description="Rest api for gemfire function execution")
@RequestMapping(value={"/v1/functions"})
public class FunctionAccessController
extends AbstractBaseController {
    private static final Logger logger = LogService.getLogger();
    protected static final String REST_API_VERSION = "/v1";

    @Override
    protected String getRestApiVersion() {
        return REST_API_VERSION;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="list all functions", notes="list all functions available in the GemFire cluster", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> list() {
        if (logger.isDebugEnabled()) {
            logger.debug("Listing all registered Functions in GemFire...");
        }
        Map registeredFunctions = FunctionService.getRegisteredFunctions();
        String listFunctionsAsJson = JSONUtils.formulateJsonForListFunctionsCall(registeredFunctions.keySet());
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri("functions"));
        return new ResponseEntity((Object)listFunctionsAsJson, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{functionId}"}, produces={"application/json"})
    @ApiOperation(value="execute function", notes="Execute function with arguments on regions, members, or group(s). By default function will be executed on all nodes if none of (onRegion, onMembers, onGroups) specified", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=500, message="if GemFire throws an error or exception"), @ApiResponse(code=400, message="if Function arguments specified as JSON document in the request body is invalid")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<String> execute(@PathVariable(value="functionId") String functionId, @RequestParam(value="onRegion", required=false) String region, @RequestParam(value="onMembers", required=false) String[] members, @RequestParam(value="onGroups", required=false) String[] groups, @RequestParam(value="filter", required=false) String[] filter, @RequestBody(required=false) String argsInBody) {
        ResultCollector results;
        Execution function = null;
        functionId = this.decode(functionId);
        if (StringUtils.hasText((String)region)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function ({}) with arguments ({}) on Region ({})...", new Object[]{functionId, ArrayUtils.toString(argsInBody), region});
            }
            region = this.decode(region);
            try {
                function = FunctionService.onRegion(this.getRegion(region));
            }
            catch (FunctionException fe) {
                throw new GemfireRestException(String.format("The Region identified by name (%1$s) could not found!", region), fe);
            }
        }
        if (ArrayUtils.isNotEmpty(members)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function ({}) with arguments ({}) on Member ({})...", new Object[]{functionId, ArrayUtils.toString(argsInBody), ArrayUtils.toString(members)});
            }
            try {
                function = FunctionService.onMembers(this.getMembers(members));
            }
            catch (FunctionException fe) {
                throw new GemfireRestException("Could not found the specified members in distributed system!", fe);
            }
        }
        if (ArrayUtils.isNotEmpty(groups)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function ({}) with arguments ({}) on Groups ({})...", new Object[]{functionId, ArrayUtils.toString(argsInBody), ArrayUtils.toString(groups)});
            }
            try {
                function = FunctionService.onMembers((String[])groups);
            }
            catch (FunctionException fe) {
                throw new GemfireRestException("no member(s) are found belonging to the provided group(s)!", fe);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing Function ({}) with arguments ({}) on all Members...", new Object[]{functionId, ArrayUtils.toString(argsInBody)});
        }
        try {
            function = FunctionService.onMembers(this.getAllMembersInDS());
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Distributed system does not contain any valid data node to run the specified  function!", fe);
        }
        if (!ArrayUtils.isEmpty(filter)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function ({}) with filter ({})", new Object[]{functionId, ArrayUtils.toString(filter)});
            }
            Set filter1 = ArrayUtils.asSet(filter);
            function = function.withFilter(filter1);
        }
        try {
            Object[] args;
            results = argsInBody != null ? ((args = this.jsonToObjectArray(argsInBody)).length == 1 ? function.withArgs(args[0]).execute(functionId) : function.withArgs((Object)args).execute(functionId)) : function.execute(functionId);
        }
        catch (ClassCastException cce) {
            throw new GemfireRestException("Key is of an inappropriate type for this region!", cce);
        }
        catch (NullPointerException npe) {
            throw new GemfireRestException("Specified key is null and this region does not permit null keys!", npe);
        }
        catch (LowMemoryException lme) {
            throw new GemfireRestException("Server has encountered low memory condition!", lme);
        }
        catch (IllegalArgumentException ie) {
            throw new GemfireRestException("Input parameter is null! ", ie);
        }
        catch (FunctionException fe) {
            throw new GemfireRestException("Server has encountered error while executing the function!", fe);
        }
        try {
            Object functionResult = results.getResult();
            if (functionResult instanceof List) {
                HttpHeaders headers = new HttpHeaders();
                headers.setLocation(this.toUri("functions", functionId));
                try {
                    String functionResultAsJson = JSONUtils.convertCollectionToJson((ArrayList)functionResult);
                    return new ResponseEntity((Object)functionResultAsJson, (MultiValueMap)headers, HttpStatus.OK);
                }
                catch (JSONException e) {
                    throw new GemfireRestException("Could not convert function results into Restful (JSON) format!", e);
                }
            }
            throw new GemfireRestException("Function has returned results that could not be converted into Restful (JSON) format!");
        }
        catch (FunctionException fe) {
            fe.printStackTrace();
            throw new GemfireRestException("Server has encountered an error while processing function execution!", fe);
        }
    }
}

