/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.shell.support;

import com.gemstone.gemfire.management.internal.web.shell.HttpOperationInvoker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.ObjectName;

public class HttpInvocationHandler
implements InvocationHandler {
    private final HttpOperationInvoker operationInvoker;
    private final ObjectName objectName;

    public HttpInvocationHandler(HttpOperationInvoker operationInvoker, ObjectName objectName) {
        assert (operationInvoker != null) : "The HTTP-based OperationInvoker cannot be null!";
        assert (objectName != null) : "The ObjectName of the resource on which the operation is invoked cannot be null!";
        this.operationInvoker = operationInvoker;
        this.objectName = objectName;
    }

    protected final ObjectName getObjectName() {
        return this.objectName;
    }

    protected final HttpOperationInvoker getOperationInvoker() {
        return this.operationInvoker;
    }

    protected boolean isAttributeAccessor(Method method) {
        String methodName = method.getName();
        return methodName.startsWith("get") || methodName.startsWith("is");
    }

    protected String getAttributeName(Method method) {
        String methodName = method.getName();
        int beginIndex = methodName.startsWith("get") ? 3 : 2;
        return methodName.substring(beginIndex);
    }

    protected String getResourceName() {
        return this.getObjectName().getCanonicalName();
    }

    protected String[] getSignature(Method method) {
        ArrayList<String> signature = new ArrayList<String>();
        for (Class<?> parameterType : method.getParameterTypes()) {
            signature.add(parameterType.getName());
        }
        return signature.toArray(new String[signature.size()]);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isAttributeAccessor(method)) {
            return this.getOperationInvoker().getAttribute(this.getResourceName(), this.getAttributeName(method));
        }
        return this.getOperationInvoker().invoke(this.getResourceName(), method.getName(), args, this.getSignature(method));
    }
}

