/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.http.support;

import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class SimpleHttpRequester {
    protected static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private final RestTemplate restTemplate;

    public SimpleHttpRequester() {
        this(30000);
    }

    public SimpleHttpRequester(int connectTimeout) {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(connectTimeout);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void delete(String url, Object ... urlVariables) {
        this.getRestTemplate().delete(url, urlVariables);
    }

    public <T> T get(String url, Class<T> responseType, Object ... urlVariables) {
        return (T)this.getRestTemplate().getForObject(url, responseType, urlVariables);
    }

    public HttpHeaders headers(String url, Object ... urlVariables) {
        return this.getRestTemplate().headForHeaders(url, urlVariables);
    }

    public Set<HttpMethod> options(String url, Object ... urlVariables) {
        return this.getRestTemplate().optionsForAllow(url, urlVariables);
    }

    public <T> T post(String url, Object requestBody, Class<T> responseType, Object ... urlVariables) {
        return (T)this.getRestTemplate().postForObject(url, requestBody, responseType, urlVariables);
    }

    public void put(String url, Object requestBody, Object ... urlVariables) {
        this.getRestTemplate().put(url, requestBody, urlVariables);
    }
}

