/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.controllers.support;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class EnvironmentVariablesHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final ThreadLocal<Map<String, String>> ENV = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return Collections.emptyMap();
        }
    };
    protected static final String ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX = "vf.gf.env.";

    public static Map<String, String> getEnvironment() {
        return ENV.get();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HashMap<String, String> requestParameterValues = new HashMap<String, String>();
        Enumeration requestParameters = request.getParameterNames();
        while (requestParameters.hasMoreElements()) {
            String requestParameter = (String)requestParameters.nextElement();
            if (!requestParameter.startsWith(ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX)) continue;
            requestParameterValues.put(requestParameter.substring(ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX.length()), request.getParameter(requestParameter));
        }
        ENV.set(requestParameterValues);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.afterConcurrentHandlingStarted(request, response, handler);
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ENV.remove();
    }
}

