/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.web.controllers;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import com.gemstone.gemfire.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;

@Controller(value="regionController")
@RequestMapping(value={"/v1"})
public class RegionCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/regions"})
    @ResponseBody
    public String listRegions(@RequestParam(value="group", required=false) String groupName, @RequestParam(value="member", required=false) String memberNameId) {
        CommandStringBuilder command = new CommandStringBuilder("list regions");
        if (RegionCommandsController.hasValue(groupName)) {
            command.addOption("group", groupName);
        }
        if (RegionCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/regions/{name}"})
    @ResponseBody
    public String describeRegion(@PathVariable(value="name") String regionNamePath) {
        CommandStringBuilder command = new CommandStringBuilder("describe region");
        command.addOption("name", RegionCommandsController.decode(regionNamePath));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/regions/{name}"})
    @ResponseBody
    public String alterRegion(WebRequest request, @PathVariable(value="name") String regionNamePath, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="entry-idle-time-expiration", required=false) Integer entryIdleTimeExpiration, @RequestParam(value="entry-idle-time-expiration-action", required=false) String entryIdleTimeExpirationAction, @RequestParam(value="entry-time-to-live-expiration", required=false) Integer entryTimeToLiveExpiration, @RequestParam(value="entry-time-to-live-expiration-action", required=false) String entryTimeToLiveExpirationAction, @RequestParam(value="region-idle-time-expiration", required=false) Integer regionIdleTimeExpiration, @RequestParam(value="region-idle-time-expiration-action", required=false) String regionIdleTimeExpirationAction, @RequestParam(value="region-time-to-live-expiration", required=false) Integer regionTimeToLiveExpiration, @RequestParam(value="region-time-to-live-expiration-action", required=false) String regionTimeToLiveExpirationAction, @RequestParam(value="cache-listener", required=false) String[] cacheListeners, @RequestParam(value="cache-loader", required=false) String cacheLoader, @RequestParam(value="cache-writer", required=false) String cacheWriter, @RequestParam(value="async-event-queue-id", required=false) String[] asyncEventQueueIds, @RequestParam(value="gateway-sender-id", required=false) String[] gatewaySenderIds, @RequestParam(value="enable-cloning", required=false) Boolean enableCloning, @RequestParam(value="eviction-max", required=false) Integer evictionMax) {
        CommandStringBuilder command = new CommandStringBuilder("alter region");
        command.addOption("name", RegionCommandsController.decode(regionNamePath));
        if (RegionCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        this.addCommandOption(request, command, "entry-idle-time-expiration", entryIdleTimeExpiration);
        this.addCommandOption(request, command, "entry-idle-time-expiration-action", entryIdleTimeExpirationAction);
        this.addCommandOption(request, command, "entry-time-to-live-expiration", entryTimeToLiveExpiration);
        this.addCommandOption(request, command, "entry-time-to-live-expiration-action", entryTimeToLiveExpirationAction);
        this.addCommandOption(request, command, "region-idle-time-expiration", regionIdleTimeExpiration);
        this.addCommandOption(request, command, "region-idle-time-expiration-action", regionIdleTimeExpirationAction);
        this.addCommandOption(request, command, "region-time-to-live-expiration", regionTimeToLiveExpiration);
        this.addCommandOption(request, command, "region-time-to-live-expiration-action", regionTimeToLiveExpirationAction);
        this.addCommandOption(request, command, "cache-listener", cacheListeners);
        this.addCommandOption(request, command, "cache-loader", cacheLoader);
        this.addCommandOption(request, command, "cache-writer", cacheWriter);
        this.addCommandOption(request, command, "async-event-queue-id", asyncEventQueueIds);
        this.addCommandOption(request, command, "gateway-sender-id", gatewaySenderIds);
        if (Boolean.TRUE.equals(enableCloning)) {
            command.addOption("enable-cloning", String.valueOf(enableCloning));
        }
        if (RegionCommandsController.hasValue(evictionMax)) {
            command.addOption("eviction-max", String.valueOf(evictionMax));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/regions"})
    @ResponseBody
    public String createRegion(@RequestParam(value="name") String regionNamePath, @RequestParam(value="type", required=false) String regionType, @RequestParam(value="template-region", required=false) String regionTemplate, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="skip-if-exists", defaultValue="true") Boolean skipIfExists, @RequestParam(value="key-constraint", required=false) String keyConstraint, @RequestParam(value="value-constraint", required=false) String valueConstraint, @RequestParam(value="enable-statistics", required=false) Boolean enableStatistics, @RequestParam(value="entry-idle-time-expiration", required=false) Integer entryIdleTimeExpiration, @RequestParam(value="entry-idle-time-expiration-action", required=false) String entryIdleTimeExpirationAction, @RequestParam(value="entry-time-to-live-expiration", required=false) Integer entryTimeToLiveExpiration, @RequestParam(value="entry-time-to-live-expiration-action", required=false) String entryTimeToLiveExpirationAction, @RequestParam(value="region-idle-time-expiration", required=false) Integer regionIdleTimeExpiration, @RequestParam(value="region-idle-time-expiration-action", required=false) String regionIdleTimeExpirationAction, @RequestParam(value="region-time-to-live-expiration", required=false) Integer regionTimeToLiveExpiration, @RequestParam(value="region-time-to-live-expiration-action", required=false) String regionTimeToLiveExpirationAction, @RequestParam(value="disk-store", required=false) String diskStore, @RequestParam(value="enable-synchronous-disk", required=false) Boolean enableSynchronousDisk, @RequestParam(value="enable-async-conflation", required=false) Boolean enableAsynchronousConflation, @RequestParam(value="enable-subscription-conflation", required=false) Boolean enableSubscriptionConflation, @RequestParam(value="cache-listener", required=false) String[] cacheListeners, @RequestParam(value="cache-loader", required=false) String cacheLoader, @RequestParam(value="cache-writer", required=false) String cacheWriter, @RequestParam(value="async-event-queue-id", required=false) String[] asyncEventQueueIds, @RequestParam(value="gateway-sender-id", required=false) String[] gatewaySenderIds, @RequestParam(value="enable-concurrency-checks", required=false) Boolean enableConcurrencyChecks, @RequestParam(value="enable-cloning", required=false) Boolean enableCloning, @RequestParam(value="concurrency-level", required=false) Integer concurrencyLevel, @RequestParam(value="colocated-with", required=false) String colocatedWith, @RequestParam(value="local-max-memory", required=false) Integer localMaxMemory, @RequestParam(value="recovery-delay", required=false) Long recoveryDelay, @RequestParam(value="redundant-copies", required=false) Integer redundantCopies, @RequestParam(value="startup-recovery-delay", required=false) Long startupRecoveryDelay, @RequestParam(value="total-max-memory", required=false) Long totalMaxMemory, @RequestParam(value="total-num-buckets", required=false) Integer totalNumBuckets, @RequestParam(value="compressor", required=false) String compressor) {
        CommandStringBuilder command = new CommandStringBuilder("create region");
        RegionCommandsController.assertArgument(RegionCommandsController.hasValue(regionNamePath), "Region name/path is required!", new Object[0]);
        RegionCommandsController.assertArgument(RegionCommandsController.hasValue(regionType) || RegionCommandsController.hasValue(regionTemplate), "Either Region type or template-region must be specified!", new Object[0]);
        command.addOption("name", regionNamePath);
        if (RegionCommandsController.hasValue(regionType)) {
            command.addOption("type", regionType);
        } else {
            command.addOption("template-region", regionTemplate);
        }
        if (RegionCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.concat((Object[])groups, (String)","));
        }
        command.addOption("skip-if-exists", String.valueOf(Boolean.TRUE.equals(skipIfExists)));
        if (RegionCommandsController.hasValue(keyConstraint)) {
            command.addOption("key-constraint", keyConstraint);
        }
        if (RegionCommandsController.hasValue(valueConstraint)) {
            command.addOption("value-constraint", valueConstraint);
        }
        if (Boolean.TRUE.equals(enableStatistics)) {
            command.addOption("enable-statistics", String.valueOf(enableStatistics));
        }
        if (RegionCommandsController.hasValue(entryIdleTimeExpiration)) {
            command.addOption("entry-idle-time-expiration", String.valueOf(entryIdleTimeExpiration));
        }
        if (RegionCommandsController.hasValue(entryIdleTimeExpirationAction)) {
            command.addOption("entry-idle-time-expiration-action", entryIdleTimeExpirationAction);
        }
        if (RegionCommandsController.hasValue(entryTimeToLiveExpiration)) {
            command.addOption("entry-time-to-live-expiration", String.valueOf(entryTimeToLiveExpiration));
        }
        if (RegionCommandsController.hasValue(entryTimeToLiveExpirationAction)) {
            command.addOption("entry-time-to-live-expiration-action", entryTimeToLiveExpirationAction);
        }
        if (RegionCommandsController.hasValue(regionIdleTimeExpiration)) {
            command.addOption("region-idle-time-expiration", String.valueOf(regionIdleTimeExpiration));
        }
        if (RegionCommandsController.hasValue(regionIdleTimeExpirationAction)) {
            command.addOption("region-idle-time-expiration-action", regionIdleTimeExpirationAction);
        }
        if (RegionCommandsController.hasValue(regionTimeToLiveExpiration)) {
            command.addOption("region-time-to-live-expiration", String.valueOf(regionTimeToLiveExpiration));
        }
        if (RegionCommandsController.hasValue(regionTimeToLiveExpirationAction)) {
            command.addOption("region-time-to-live-expiration-action", regionTimeToLiveExpirationAction);
        }
        if (RegionCommandsController.hasValue(diskStore)) {
            command.addOption("disk-store", diskStore);
        }
        if (Boolean.TRUE.equals(enableSynchronousDisk)) {
            command.addOption("enable-synchronous-disk", String.valueOf(enableSynchronousDisk));
        }
        if (Boolean.TRUE.equals(enableAsynchronousConflation)) {
            command.addOption("enable-async-conflation", String.valueOf(enableAsynchronousConflation));
        }
        if (Boolean.TRUE.equals(enableSubscriptionConflation)) {
            command.addOption("enable-subscription-conflation", String.valueOf(enableSubscriptionConflation));
        }
        if (RegionCommandsController.hasValue(cacheListeners)) {
            command.addOption("cache-listener", StringUtils.concat((Object[])cacheListeners, (String)","));
        }
        if (RegionCommandsController.hasValue(cacheLoader)) {
            command.addOption("cache-loader", cacheLoader);
        }
        if (RegionCommandsController.hasValue(cacheWriter)) {
            command.addOption("cache-writer", cacheWriter);
        }
        if (RegionCommandsController.hasValue(asyncEventQueueIds)) {
            command.addOption("async-event-queue-id", StringUtils.concat((Object[])asyncEventQueueIds, (String)","));
        }
        if (RegionCommandsController.hasValue(gatewaySenderIds)) {
            command.addOption("gateway-sender-id", StringUtils.concat((Object[])gatewaySenderIds, (String)","));
        }
        if (Boolean.TRUE.equals(enableConcurrencyChecks)) {
            command.addOption("enable-concurrency-checks", String.valueOf(enableConcurrencyChecks));
        }
        if (Boolean.TRUE.equals(enableCloning)) {
            command.addOption("enable-cloning", String.valueOf(enableCloning));
        }
        if (RegionCommandsController.hasValue(concurrencyLevel)) {
            command.addOption("concurrency-level", String.valueOf(concurrencyLevel));
        }
        if (RegionCommandsController.hasValue(colocatedWith)) {
            command.addOption("colocated-with", colocatedWith);
        }
        if (RegionCommandsController.hasValue(localMaxMemory)) {
            command.addOption("local-max-memory", String.valueOf(localMaxMemory));
        }
        if (RegionCommandsController.hasValue(recoveryDelay)) {
            command.addOption("recovery-delay", String.valueOf(recoveryDelay));
        }
        if (RegionCommandsController.hasValue(redundantCopies)) {
            command.addOption("redundant-copies", String.valueOf(redundantCopies));
        }
        if (RegionCommandsController.hasValue(startupRecoveryDelay)) {
            command.addOption("startup-recovery-delay", String.valueOf(startupRecoveryDelay));
        }
        if (RegionCommandsController.hasValue(totalMaxMemory)) {
            command.addOption("total-max-memory", String.valueOf(totalMaxMemory));
        }
        if (RegionCommandsController.hasValue(totalNumBuckets)) {
            command.addOption("total-num-buckets", String.valueOf(totalNumBuckets));
        }
        if (RegionCommandsController.hasValue(compressor)) {
            command.addOption("compressor", compressor);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/regions/{name}"})
    @ResponseBody
    public String destroyRegion(@PathVariable(value="name") String regionNamePath) {
        CommandStringBuilder command = new CommandStringBuilder("destroy region");
        command.addOption("name", RegionCommandsController.decode(regionNamePath));
        return this.processCommand(command.toString());
    }
}

