/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.GemFireException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.naming.NamingException;

public class GemFireSecurityException
extends GemFireException {
    private static final long serialVersionUID = 3814254578203076926L;
    private Throwable cause;

    public GemFireSecurityException(String message) {
        this(message, null);
    }

    public GemFireSecurityException(Throwable cause) {
        this(cause != null ? cause.getMessage() : null, cause);
    }

    public GemFireSecurityException(String message, Throwable cause) {
        super(message != null ? message : (cause != null ? cause.getMessage() : null));
        this.cause = cause;
    }

    @Override
    public final synchronized Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    protected final boolean isSerializable(Object object) {
        if (object == null) {
            return true;
        }
        return Serializable.class.isInstance(object);
    }

    protected final Object getResolvedObj() {
        Throwable thisCause = this.cause;
        if (thisCause != null && NamingException.class.isInstance(thisCause)) {
            return ((NamingException)thisCause).getResolvedObj();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Object resolvedObj = this.getResolvedObj();
        if (this.isSerializable(resolvedObj)) {
            out.defaultWriteObject();
        } else {
            NamingException namingException = (NamingException)this.getCause();
            namingException.setResolvedObj(null);
            try {
                out.defaultWriteObject();
            }
            finally {
                namingException.setResolvedObj(resolvedObj);
            }
        }
    }
}

