/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.redis;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.hll.HyperLogLogPlus;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.ByteToCommandDecoder;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.RegionProvider;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class GemFireRedisServer {
    private static Thread mainThread = null;
    public static final int DEFAULT_REDIS_SERVER_PORT = 6379;
    private final int numWorkerThreads;
    private final int numSelectorThreads;
    private final int serverPort;
    private final String bindAddress;
    private static final int connectTimeoutMillis = 1000;
    private boolean singleThreadPerConnection;
    private final String logLevel;
    private Cache cache;
    private Channel serverChannel;
    private LogWriter logger;
    private RegionProvider regionCache;
    private final MetaCacheListener metaListener;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private static final int numExpirationThreads = 1;
    private final ScheduledExecutorService expirationExecutor;
    private final ConcurrentMap<ByteArrayWrapper, ScheduledFuture<?>> expirationFutures;
    public static final String STRING_REGION = "__StRiNgS";
    public static final String HLL_REGION = "__HlL";
    public static final String REDIS_META_DATA_REGION = "__ReDiS_MeTa_DaTa";
    public static final String DEFAULT_REGION_SYS_PROP_NAME = "gemfireredis.regiontype";
    public static final String NUM_THREADS_SYS_PROP_NAME = "gemfireredis.numthreads";
    public final RegionShortcut DEFAULT_REGION_TYPE;
    private boolean shutdown;
    private boolean started;

    private static RegionShortcut setRegionType() {
        RegionShortcut type;
        String regionType = System.getProperty(DEFAULT_REGION_SYS_PROP_NAME, "PARTITION");
        try {
            type = RegionShortcut.valueOf(regionType);
        }
        catch (Exception e) {
            type = RegionShortcut.PARTITION;
        }
        return type;
    }

    private int setNumWorkerThreads() {
        int threads;
        String prop = System.getProperty(NUM_THREADS_SYS_PROP_NAME);
        int numCores = Runtime.getRuntime().availableProcessors();
        int def = 4 * numCores;
        if (prop == null || prop.isEmpty()) {
            return def;
        }
        try {
            threads = Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            return def;
        }
        return threads;
    }

    public GemFireRedisServer(int port) {
        this(null, port, null);
    }

    public GemFireRedisServer(String bindAddress, int port) {
        this(bindAddress, port, null);
    }

    public GemFireRedisServer(String bindAddress, int port, String logLevel) {
        this.serverPort = port <= 0 ? 6379 : port;
        this.bindAddress = bindAddress;
        this.logLevel = logLevel;
        this.numWorkerThreads = this.setNumWorkerThreads();
        if (this.numWorkerThreads == 0) {
            this.singleThreadPerConnection = true;
        }
        this.numSelectorThreads = 1;
        this.metaListener = new MetaCacheListener();
        this.expirationFutures = new ConcurrentHashMap();
        this.expirationExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("GemFireRedis-ScheduledExecutor-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        this.DEFAULT_REGION_TYPE = GemFireRedisServer.setRegionType();
        this.shutdown = false;
        this.started = false;
    }

    private InetAddress getBindAddress() throws UnknownHostException {
        return this.bindAddress == null || this.bindAddress.isEmpty() ? SocketCreator.getLocalHost() : InetAddress.getByName(this.bindAddress);
    }

    public synchronized void start() {
        if (!this.started) {
            try {
                this.startGemFire();
                this.initializeRedis();
                this.startRedisServer();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not start Server", e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Could not start Server", e);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void startGemFire() {
        Cache c = GemFireCacheImpl.getInstance();
        if (c == null) {
            Class<GemFireRedisServer> clazz = GemFireRedisServer.class;
            // MONITORENTER : com.gemstone.gemfire.redis.GemFireRedisServer.class
            c = GemFireCacheImpl.getInstance();
            if (c == null) {
                CacheFactory cacheFactory = new CacheFactory();
                if (this.logLevel != null) {
                    cacheFactory.set("log-level", this.logLevel);
                }
                c = cacheFactory.create();
            }
            // MONITOREXIT : clazz
        }
        this.cache = c;
        this.logger = c.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRedis() {
        Cache cache = this.cache;
        synchronized (cache) {
            Region<String, RedisDataType> redisMetaData;
            Region<ByteArrayWrapper, HyperLogLogPlus> hLLRegion;
            RegionFactory<String, RedisDataType> rfMeta = this.cache.createRegionFactory(RegionShortcut.REPLICATE);
            rfMeta.addCacheListener(this.metaListener);
            RegionFactory rfString = this.cache.createRegionFactory(this.DEFAULT_REGION_TYPE);
            RegionFactory rfHLL = this.cache.createRegionFactory(this.DEFAULT_REGION_TYPE);
            Region<ByteArrayWrapper, ByteArrayWrapper> stringsRegion = this.cache.getRegion(STRING_REGION);
            if (stringsRegion == null) {
                stringsRegion = rfString.create(STRING_REGION);
            }
            if ((hLLRegion = this.cache.getRegion(HLL_REGION)) == null) {
                hLLRegion = rfHLL.create(HLL_REGION);
            }
            if ((redisMetaData = this.cache.getRegion(REDIS_META_DATA_REGION)) == null) {
                redisMetaData = rfMeta.create(REDIS_META_DATA_REGION);
            }
            this.regionCache = new RegionProvider(stringsRegion, hLLRegion, redisMetaData, this.expirationFutures, this.expirationExecutor, this.DEFAULT_REGION_TYPE);
            redisMetaData.put(REDIS_META_DATA_REGION, RedisDataType.REDIS_PROTECTED);
            redisMetaData.put(HLL_REGION, RedisDataType.REDIS_PROTECTED);
            redisMetaData.put(STRING_REGION, RedisDataType.REDIS_PROTECTED);
        }
        this.checkForRegions();
    }

    private void checkForRegions() {
        Set<Map.Entry<String, RedisDataType>> entrySet = this.regionCache.metaEntrySet();
        for (Map.Entry entry : entrySet) {
            String regionName = (String)entry.getKey();
            RedisDataType type = (RedisDataType)((Object)entry.getValue());
            Region newRegion = this.cache.getRegion(regionName);
            if (newRegion != null || type == RedisDataType.REDIS_STRING || type == RedisDataType.REDIS_HLL || type == RedisDataType.REDIS_PROTECTED) continue;
            try {
                this.regionCache.createRemoteRegionReferenceLocally(Coder.stringToByteArrayWrapper(regionName), type);
            }
            catch (Exception e) {
                if (!this.logger.errorEnabled()) continue;
                this.logger.error(e);
            }
        }
    }

    private void startRedisServer() throws IOException, InterruptedException {
        ThreadFactory selectorThreadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("GemFireRedisServer-SelectorThread-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        };
        ThreadFactory workerThreadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("GemFireRedisServer-WorkerThread-" + this.counter.incrementAndGet());
                return t;
            }
        };
        this.bossGroup = null;
        this.workerGroup = null;
        Class<OioServerSocketChannel> socketClass = null;
        if (this.singleThreadPerConnection) {
            this.bossGroup = new OioEventLoopGroup(Integer.MAX_VALUE, selectorThreadFactory);
            this.workerGroup = new OioEventLoopGroup(Integer.MAX_VALUE, workerThreadFactory);
            socketClass = OioServerSocketChannel.class;
        } else {
            this.bossGroup = new NioEventLoopGroup(this.numSelectorThreads, selectorThreadFactory);
            this.workerGroup = new NioEventLoopGroup(this.numWorkerThreads, workerThreadFactory);
            socketClass = NioServerSocketChannel.class;
        }
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        String pwd = system.getConfig().getRedisPassword();
        final byte[] pwdB = Coder.stringToBytes(pwd);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(socketClass)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                if (GemFireRedisServer.this.logger.fineEnabled()) {
                    GemFireRedisServer.this.logger.fine("GemFireRedisServer-Connection established with " + ch.remoteAddress());
                }
                ChannelPipeline p = ch.pipeline();
                p.addLast(ByteToCommandDecoder.class.getSimpleName(), (ChannelHandler)new ByteToCommandDecoder());
                p.addLast(ExecutionHandlerContext.class.getSimpleName(), (ChannelHandler)new ExecutionHandlerContext((Channel)ch, GemFireRedisServer.this.cache, GemFireRedisServer.this.regionCache, GemFireRedisServer.this, pwdB));
            }
        }).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)this.getBufferSize())).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        ChannelFuture f = b.bind((SocketAddress)new InetSocketAddress(this.getBindAddress(), this.serverPort)).sync();
        if (this.logger.infoEnabled()) {
            String logMessage = "GemFireRedisServer started {" + this.getBindAddress() + ":" + this.serverPort + "}, Selector threads: " + this.numSelectorThreads;
            logMessage = this.singleThreadPerConnection ? logMessage + ", One worker thread per connection" : logMessage + ", Worker threads: " + this.numWorkerThreads;
            this.logger.info(logMessage);
        }
        this.serverChannel = f.channel();
    }

    private void afterKeyCreate(EntryEvent<String, RedisDataType> event) {
        if (event.isOriginRemote()) {
            String key = event.getKey();
            RedisDataType value = event.getNewValue();
            if (value != RedisDataType.REDIS_STRING && value != RedisDataType.REDIS_HLL && value != RedisDataType.REDIS_PROTECTED) {
                try {
                    this.regionCache.createRemoteRegionReferenceLocally(Coder.stringToByteArrayWrapper(key), value);
                }
                catch (RegionDestroyedException regionDestroyedException) {
                    // empty catch block
                }
            }
        }
    }

    private void afterKeyDestroy(EntryEvent<String, RedisDataType> event) {
        if (event.isOriginRemote()) {
            ByteArrayWrapper kW;
            Region<?, ?> r;
            String key = event.getKey();
            RedisDataType value = event.getOldValue();
            if (value != null && value != RedisDataType.REDIS_STRING && value != RedisDataType.REDIS_HLL && value != RedisDataType.REDIS_PROTECTED && (r = this.regionCache.getRegion(kW = Coder.stringToByteArrayWrapper(key))) != null) {
                this.regionCache.removeRegionReferenceLocally(kW, value);
            }
        }
    }

    private int getBufferSize() {
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        return system.getConfig().getSocketBufferSize();
    }

    public synchronized void shutdown() {
        if (!this.shutdown) {
            if (this.logger.infoEnabled()) {
                this.logger.info("GemFireRedisServer shutting down");
            }
            ChannelFuture closeFuture = this.serverChannel.closeFuture();
            Future c = this.workerGroup.shutdownGracefully();
            Future c2 = this.bossGroup.shutdownGracefully();
            this.serverChannel.close();
            c.syncUninterruptibly();
            c2.syncUninterruptibly();
            this.regionCache.close();
            if (mainThread != null) {
                mainThread.interrupt();
            }
            for (ScheduledFuture f : this.expirationFutures.values()) {
                f.cancel(true);
            }
            this.expirationFutures.clear();
            this.expirationExecutor.shutdownNow();
            closeFuture.syncUninterruptibly();
            this.shutdown = true;
        }
    }

    public static void main(String[] args) {
        int port = 6379;
        String bindAddress = null;
        String logLevel = null;
        for (String arg : args) {
            if (arg.startsWith("-port")) {
                port = GemFireRedisServer.getPort(arg);
                continue;
            }
            if (arg.startsWith("-bind-address")) {
                bindAddress = GemFireRedisServer.getBindAddress(arg);
                continue;
            }
            if (!arg.startsWith("-log-level")) continue;
            logLevel = GemFireRedisServer.getLogLevel(arg);
        }
        mainThread = Thread.currentThread();
        GemFireRedisServer server = new GemFireRedisServer(bindAddress, port, logLevel);
        server.start();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException e1) {
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static int getPort(String arg) {
        int port = 6379;
        if (arg != null && arg.length() > 6 && arg.startsWith("-port")) {
            String p = arg.substring(arg.indexOf(61) + 1);
            p = p.trim();
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException e) {
                System.out.println("Unable to parse port, using default port");
            }
        }
        return port;
    }

    private static String getBindAddress(String arg) {
        String address = null;
        if (arg != null && arg.length() > 14 && arg.startsWith("-bind-address")) {
            String p = arg.substring(arg.indexOf(61) + 1);
            address = p.trim();
        }
        return address;
    }

    private static String getLogLevel(String arg) {
        String logLevel = null;
        if (arg != null && arg.length() > 11 && arg.startsWith("-log-level")) {
            String p = arg.substring(arg.indexOf(61) + 1);
            logLevel = p.trim();
        }
        return logLevel;
    }

    private final class MetaCacheListener
    extends CacheListenerAdapter<String, RedisDataType> {
        private MetaCacheListener() {
        }

        @Override
        public void afterCreate(EntryEvent<String, RedisDataType> event) {
            GemFireRedisServer.this.afterKeyCreate(event);
        }

        @Override
        public void afterDestroy(EntryEvent<String, RedisDataType> event) {
            GemFireRedisServer.this.afterKeyDestroy(event);
        }
    }
}

