/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.util.concurrent.CopyOnWriteHashMap;
import com.gemstone.gemfire.pdx.PdxInitializationException;
import com.gemstone.gemfire.pdx.PdxRegistryMismatchException;
import com.gemstone.gemfire.pdx.internal.CheckTypeRegistryState;
import com.gemstone.gemfire.pdx.internal.EnumId;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.TypeRegistration;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PeerTypeRegistration
implements TypeRegistration {
    private static final int MAX_TRANSACTION_FAILURES = 10;
    public static final String LOCK_SERVICE_NAME = "__PDX";
    public static final String REGION_NAME = "PdxTypes";
    public static final String REGION_FULL_PATH = "/PdxTypes";
    private int nextTypeId;
    private final int maxTypeId;
    private int nextEnumId;
    private final int maxEnumId;
    private volatile DistributedLockService dls;
    private final Object dlsLock = new Object();
    private GemFireCacheImpl cache;
    private Region<Object, Object> idToType;
    private Map<PdxType, Integer> typeToId = Collections.synchronizedMap(new HashMap());
    private Map<EnumInfo, EnumId> enumToId = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<PdxType>> classToType = new CopyOnWriteHashMap<String, Set<PdxType>>();
    private volatile boolean typeRegistryInUse = false;
    private static final String LOCK_NAME = "PDX_LOCK";
    private int lastAllocatedTypeId;
    private int lastAllocatedEnumId;

    public PeerTypeRegistration(GemFireCacheImpl cache) {
        this.cache = cache;
        int distributedSystemId = cache.getDistributedSystem().getDistributionManager().getDistributedSystemId();
        if (distributedSystemId == -1) {
            distributedSystemId = 0;
        }
        this.nextTypeId = distributedSystemId << 24;
        this.maxTypeId = distributedSystemId << 24 | 0xFFFFFF;
        this.nextEnumId = distributedSystemId << 24;
        this.maxEnumId = distributedSystemId << 24 | 0xFFFFFF;
    }

    private Region<Object, Object> getIdToType() {
        if (this.idToType != null) {
            return this.idToType;
        }
        if (this.cache.getPdxPersistent() && this.cache.getCacheConfig().pdxDiskStoreUserSet) {
            throw new PdxInitializationException("PDX registry could not be initialized because the disk store " + this.cache.getPdxDiskStore() + " was not created.");
        }
        throw new PdxInitializationException("PDX registry was not initialized.");
    }

    @Override
    public void initialize() {
        AttributesFactory<Object, Object> factory = new AttributesFactory<Object, Object>();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        if (this.cache.getPdxPersistent()) {
            if (this.cache.getCacheConfig().pdxDiskStoreUserSet) {
                factory.setDiskStoreName(this.cache.getPdxDiskStore());
            } else {
                factory.setDiskStoreName(this.cache.getOrCreateDefaultDiskStore().getName());
            }
            factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        } else {
            factory.setDataPolicy(DataPolicy.REPLICATE);
        }
        factory.addCacheListener(new CacheListenerAdapter<Object, Object>(){

            @Override
            public void afterCreate(EntryEvent<Object, Object> event) {
                PeerTypeRegistration.this.verifyConfiguration();
                Object value = event.getNewValue();
                if (value instanceof PdxType) {
                    PeerTypeRegistration.this.updateClassToTypeMap((PdxType)value);
                }
            }
        });
        factory.setCacheWriter(new CacheWriterAdapter<Object, Object>(){

            @Override
            public void beforeUpdate(EntryEvent<Object, Object> event) throws CacheWriterException {
                if (!event.getOldValue().equals(event.getNewValue())) {
                    PdxRegistryMismatchException ex = new PdxRegistryMismatchException("Trying to add a PDXType with the same id as an existing PDX type. id=" + event.getKey() + ", existing pdx type " + event.getOldValue() + ", new type " + event.getNewValue());
                    throw new CacheWriterException(ex);
                }
            }
        });
        RegionAttributes regionAttrs = factory.create();
        InternalRegionArguments internalArgs = new InternalRegionArguments();
        internalArgs.setIsUsedForMetaRegion(true);
        internalArgs.setMetaRegionWithTransactions(true);
        try {
            this.idToType = this.cache.createVMRegion(REGION_NAME, regionAttrs, internalArgs);
        }
        catch (IOException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        catch (TimeoutException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        catch (RegionExistsException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        if (!this.getIdToType().isEmpty()) {
            this.verifyConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributedLockService getLockService() {
        if (this.dls != null) {
            return this.dls;
        }
        Object object = this.dlsLock;
        synchronized (object) {
            block7: {
                if (this.dls == null) {
                    try {
                        this.dls = DLockService.create(LOCK_SERVICE_NAME, this.cache.getDistributedSystem(), true, true, true);
                    }
                    catch (IllegalArgumentException e) {
                        this.dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
                        if (this.dls != null) break block7;
                        throw e;
                    }
                }
            }
            return this.dls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateTypeId() {
        TXStateProxy currentState = this.suspendTX();
        Region<Object, Object> r = this.getIdToType();
        try {
            do {
                ++this.nextTypeId;
                if (this.nextTypeId != this.maxTypeId) continue;
                throw new InternalGemFireError("Used up all of the PDX type ids for this distributed system. The maximum number of PDX types is " + this.maxTypeId);
            } while (r.get(this.nextTypeId) != null);
            this.lastAllocatedTypeId = this.nextTypeId;
            int n = this.nextTypeId;
            return n;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumId allocateEnumId() {
        TXStateProxy currentState = this.suspendTX();
        Region<Object, Object> r = this.getIdToType();
        try {
            do {
                ++this.nextEnumId;
                if (this.nextEnumId != this.maxEnumId) continue;
                throw new InternalGemFireError("Used up all of the PDX enum ids for this distributed system. The maximum number of PDX types is " + this.maxEnumId);
            } while (r.get(new EnumId(this.nextEnumId)) != null);
            this.lastAllocatedEnumId = this.nextEnumId;
            EnumId enumId = new EnumId(this.nextEnumId);
            return enumId;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    private void unlock() {
        try {
            DistributedLockService dls = this.getLockService();
            dls.unlock(LOCK_NAME);
        }
        catch (LockServiceDestroyedException e) {
            this.cache.getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
    }

    private void lock() {
        DistributedLockService dls = this.getLockService();
        try {
            if (!dls.lock(LOCK_NAME, -1L, -1L)) {
                throw new InternalGemFireException("Could not obtain pdx lock");
            }
        }
        catch (LockServiceDestroyedException e) {
            this.cache.getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
    }

    private boolean useUDPMessagingIfNecessary() {
        boolean result = false;
        InternalDistributedSystem sys = this.cache.getDistributedSystem();
        if (sys != null && !sys.threadOwnsResources()) {
            sys.getDistributionManager().forceUDPMessagingForCurrentThread();
            result = true;
        }
        return result;
    }

    private void releaseUDPMessaging(boolean release) {
        InternalDistributedSystem sys;
        if (release && (sys = this.cache.getDistributedSystem()) != null) {
            sys.getDistributionManager().releaseUDPMessagingForCurrentThread();
        }
    }

    @Override
    public int getLastAllocatedTypeId() {
        this.verifyConfiguration();
        return this.lastAllocatedTypeId;
    }

    public int getLastAllocatedEnumId() {
        this.verifyConfiguration();
        return this.lastAllocatedEnumId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int defineType(PdxType newType) {
        this.verifyConfiguration();
        Integer existingId = this.typeToId.get(newType);
        if (existingId != null) {
            return existingId;
        }
        this.lock();
        try {
            int id = this.getExistingIdForType(newType);
            if (id != -1) {
                int n = id;
                return n;
            }
            id = this.allocateTypeId();
            newType.setTypeId(id);
            this.updateIdToTypeRegion(newType);
            this.typeToId.put(newType, id);
            int n = newType.getTypeId();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    private void updateIdToTypeRegion(PdxType newType) {
        this.updateRegion(newType.getTypeId(), newType);
    }

    private void updateIdToEnumRegion(EnumId id, EnumInfo ei) {
        this.updateRegion(id, ei);
    }

    private void updateRegion(Object k, Object v) {
        Region<Object, Object> r = this.getIdToType();
        Cache c = (Cache)r.getRegionService();
        this.checkDistributedTypeRegistryState();
        TXManagerImpl txManager = (TXManagerImpl)c.getCacheTransactionManager();
        TXStateProxy currentState = this.suspendTX();
        boolean state = this.useUDPMessagingIfNecessary();
        try {
            int failureCount = 0;
            while (true) {
                txManager.begin();
                try {
                    r.put(k, v);
                    txManager.commit();
                    return;
                }
                catch (TransactionException e) {
                    if (!txManager.exists()) continue;
                    txManager.rollback();
                    if (++failureCount <= 10) continue;
                    throw e;
                }
                break;
            }
        }
        finally {
            this.releaseUDPMessaging(state);
            this.resumeTX(currentState);
        }
    }

    private void checkDistributedTypeRegistryState() {
        CheckTypeRegistryState.send(this.cache.getDistributionManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PdxType getType(int typeId) {
        this.verifyConfiguration();
        TXStateProxy currentState = this.suspendTX();
        try {
            PdxType pdxType = (PdxType)this.getIdToType().get(typeId);
            return pdxType;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteType(int typeId, PdxType type) {
        block6: {
            this.verifyConfiguration();
            TXStateProxy currentState = this.suspendTX();
            Region<Object, Object> r = this.getIdToType();
            try {
                if (r.containsKey(typeId)) break block6;
                this.lock();
                try {
                    r.put(typeId, type);
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                this.resumeTX(currentState);
            }
        }
    }

    @Override
    public void gatewaySenderStarted(GatewaySender gatewaySender) {
        if (!this.typeRegistryInUse || this.idToType == null) {
            return;
        }
        this.checkAllowed(true, this.hasPersistentRegions());
    }

    @Override
    public void creatingPersistentRegion() {
        if (!this.typeRegistryInUse) {
            return;
        }
        this.checkAllowed(this.hasGatewaySender(), true);
    }

    public boolean hasGatewaySender() {
        Set<GatewaySender> sendersAndAsyncQueues = this.cache.getGatewaySenders();
        Iterator<GatewaySender> itr = sendersAndAsyncQueues.iterator();
        while (itr.hasNext()) {
            GatewaySender sender = itr.next();
            if (!AsyncEventQueueImpl.isAsyncEventQueue(sender.getId())) continue;
            itr.remove();
        }
        return !sendersAndAsyncQueues.isEmpty();
    }

    @Override
    public void creatingPool() {
        if (this.typeRegistryInUse) {
            throw new PdxInitializationException("The PDX metadata has already been created as a peer metadata region. Please create your pools first");
        }
    }

    void verifyConfiguration() {
        if (this.typeRegistryInUse) {
            return;
        }
        boolean hasPersistentRegions = this.hasPersistentRegions();
        this.checkAllowed(this.hasGatewaySender(), hasPersistentRegions);
        for (Pool pool : PoolManager.getAll().values()) {
            if (((PoolImpl)pool).isUsedByGateway()) continue;
            throw new PdxInitializationException("The PDX metadata has already been created as a peer metadata region. Please use ClientCacheFactory to create clients.");
        }
        this.typeRegistryInUse = true;
    }

    public boolean hasPersistentRegions() {
        Collection<DiskStoreImpl> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
        boolean hasPersistentRegions = false;
        for (DiskStoreImpl store : diskStores) {
            hasPersistentRegions |= store.hasPersistedData();
        }
        return hasPersistentRegions;
    }

    private void checkAllowed(boolean hasGatewaySender, boolean hasDiskStore) {
        if (hasDiskStore && !this.cache.getPdxPersistent()) {
            throw new PdxInitializationException("The PDX metadata must be persistent in a member that has persistent data. See CacheFactory.setPdxPersistent.");
        }
        int distributedSystemId = this.cache.getDistributedSystem().getDistributionManager().getDistributedSystemId();
        if (hasGatewaySender && distributedSystemId == -1) {
            throw new PdxInitializationException("When using PDX with a WAN gateway sender, you must set the distributed-system-id gemfire property for your distributed system. See the javadocs for DistributedSystem.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getExistingIdForType(PdxType newType) {
        TXStateProxy currentState = this.suspendTX();
        try {
            int result = -1;
            for (Map.Entry<Object, Object> entry : this.getIdToType().entrySet()) {
                Object v = entry.getValue();
                Object k = entry.getKey();
                if (k instanceof EnumId) {
                    EnumId id = (EnumId)k;
                    EnumInfo info = (EnumInfo)v;
                    this.enumToId.put(info, id);
                    continue;
                }
                PdxType foundType = (PdxType)v;
                Integer id = (Integer)k;
                this.typeToId.put(foundType, id);
                if (!foundType.equals(newType)) continue;
                result = foundType.getTypeId();
            }
            int n = result;
            return n;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumId getExistingIdForEnum(EnumInfo ei) {
        TXStateProxy currentState = this.suspendTX();
        try {
            EnumId result = null;
            for (Map.Entry<Object, Object> entry : this.getIdToType().entrySet()) {
                Object v = entry.getValue();
                Object k = entry.getKey();
                if (k instanceof EnumId) {
                    EnumId id = (EnumId)k;
                    EnumInfo info = (EnumInfo)v;
                    this.enumToId.put(info, id);
                    if (!ei.equals(info)) continue;
                    result = id;
                    continue;
                }
                this.typeToId.put((PdxType)v, (Integer)k);
            }
            Iterator<Map.Entry<Object, Object>> iterator = result;
            return iterator;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    private TXStateProxy suspendTX() {
        Cache c = (Cache)this.getIdToType().getRegionService();
        TXManagerImpl txManager = (TXManagerImpl)c.getCacheTransactionManager();
        TXStateProxy currentState = txManager.internalSuspend();
        return currentState;
    }

    private void resumeTX(TXStateProxy state) {
        if (state != null) {
            TXManagerImpl txManager = state.getTxMgr();
            txManager.resume(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEnumId(Enum<?> v) {
        this.verifyConfiguration();
        EnumInfo ei = new EnumInfo(v);
        EnumId existingId = this.enumToId.get(ei);
        if (existingId != null) {
            return existingId.intValue();
        }
        this.lock();
        try {
            EnumId id = this.getExistingIdForEnum(ei);
            if (id != null) {
                int n = id.intValue();
                return n;
            }
            id = this.allocateEnumId();
            this.updateIdToEnumRegion(id, ei);
            this.enumToId.put(ei, id);
            int n = id.intValue();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteEnum(int id, EnumInfo enumInfo) {
        block6: {
            this.verifyConfiguration();
            TXStateProxy currentState = this.suspendTX();
            EnumId enumId = new EnumId(id);
            Region<Object, Object> r = this.getIdToType();
            try {
                if (r.containsKey(enumId)) break block6;
                this.lock();
                try {
                    r.put(enumId, enumInfo);
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                this.resumeTX(currentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int defineEnum(EnumInfo newInfo) {
        this.verifyConfiguration();
        EnumId existingId = this.enumToId.get(newInfo);
        if (existingId != null) {
            return existingId.intValue();
        }
        this.lock();
        try {
            EnumId id = this.getExistingIdForEnum(newInfo);
            if (id != null) {
                int n = id.intValue();
                return n;
            }
            id = this.allocateEnumId();
            this.updateIdToEnumRegion(id, newInfo);
            this.enumToId.put(newInfo, id);
            int n = id.intValue();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumInfo getEnumById(int id) {
        this.verifyConfiguration();
        EnumId enumId = new EnumId(id);
        TXStateProxy currentState = this.suspendTX();
        try {
            EnumInfo enumInfo = (EnumInfo)this.getIdToType().get(enumId);
            return enumInfo;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    @Override
    public Map<Integer, PdxType> types() {
        HashMap<Integer, PdxType> types = new HashMap<Integer, PdxType>();
        for (Map.Entry<Object, Object> type : this.getIdToType().entrySet()) {
            Object id = type.getKey();
            if (!(type.getValue() instanceof PdxType)) continue;
            types.put((Integer)id, (PdxType)type.getValue());
        }
        return types;
    }

    @Override
    public Map<Integer, EnumInfo> enums() {
        HashMap<Integer, EnumInfo> enums = new HashMap<Integer, EnumInfo>();
        for (Map.Entry<Object, Object> type : this.getIdToType().entrySet()) {
            Object id = type.getKey();
            if (!(type.getValue() instanceof EnumInfo)) continue;
            enums.put(((EnumId)id).intValue(), (EnumInfo)type.getValue());
        }
        return enums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassToTypeMap(PdxType type) {
        if (type != null) {
            Map<String, Set<PdxType>> map = this.classToType;
            synchronized (map) {
                if (type.getClassName().equals("__GEMFIRE_JSON")) {
                    return;
                }
                Set<PdxType> pdxTypeSet = this.classToType.get(type.getClassName());
                if (pdxTypeSet == null) {
                    pdxTypeSet = new CopyOnWriteHashSet<PdxType>();
                }
                pdxTypeSet.add(type);
                this.classToType.put(type.getClassName(), pdxTypeSet);
            }
        }
    }

    @Override
    public PdxType getPdxTypeForField(String fieldName, String className) {
        Set<PdxType> pdxTypes = this.classToType.get(className);
        if (pdxTypes != null) {
            for (PdxType pdxType : pdxTypes) {
                if (pdxType.getPdxField(fieldName) == null) continue;
                return pdxType;
            }
        }
        return null;
    }

    public Map<String, Set<PdxType>> getClassToType() {
        return this.classToType;
    }

    @Override
    public void testClearRegistry() {
        this.idToType.clear();
        this.enumToId.clear();
        this.typeToId.clear();
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void addImportedType(int typeId, PdxType importedType) {
        this.addRemoteType(typeId, importedType);
    }

    @Override
    public void addImportedEnum(int id, EnumInfo importedInfo) {
        this.addRemoteEnum(id, importedInfo);
    }

    public static int getPdxRegistrySize() {
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
        if (cache == null) {
            return 0;
        }
        TypeRegistry registry = cache.getPdxRegistry();
        if (registry == null) {
            return 0;
        }
        return registry.getLocalSize();
    }

    @Override
    public int getLocalSize() {
        return this.idToType.size();
    }
}

