/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.tcp.ByteBufferInputStream;
import com.gemstone.gemfire.pdx.FieldType;
import com.gemstone.gemfire.pdx.PdxFieldAlreadyExistsException;
import com.gemstone.gemfire.pdx.PdxFieldDoesNotExistException;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxSerializationException;
import com.gemstone.gemfire.pdx.PdxUnreadFields;
import com.gemstone.gemfire.pdx.PdxWriter;
import com.gemstone.gemfire.pdx.internal.AutoSerializableManager;
import com.gemstone.gemfire.pdx.internal.PdxField;
import com.gemstone.gemfire.pdx.internal.PdxInputStream;
import com.gemstone.gemfire.pdx.internal.PdxInstanceImpl;
import com.gemstone.gemfire.pdx.internal.PdxOutputStream;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.PdxUnreadData;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;

public class PdxWriterImpl
implements PdxWriter {
    public static final byte TYPE_ID_SIZE = 4;
    public static final byte HEADER_SIZE = 9;
    public static final int EXPAND_SIZE = 32;
    private TypeRegistry tr;
    private final Object pdx;
    private final PdxOutputStream os;
    private final AutoSerializableManager.AutoClassInfo aci;
    private int[] vlfOffsets;
    private int vlfCount = 0;
    private boolean hasSeenFirstVlf = false;
    protected final int headerOffset;
    private PdxUnreadData unreadData;
    private PdxType existingType;
    private PdxType newType;
    private int fieldId = -1;
    private static final boolean sysPropDoExtraPdxValidation = Boolean.getBoolean("gemfire.validatePdxWriters");
    private boolean doExtraValidation = sysPropDoExtraPdxValidation;
    private boolean unreadDataInitialized = false;
    private boolean alreadyGenerated = false;
    private HeapDataOutputStream.LongUpdater lu;

    public PdxWriterImpl(TypeRegistry tr, Object pdx, PdxOutputStream out) {
        this.tr = tr;
        this.pdx = pdx;
        this.os = out;
        this.headerOffset = this.os.size();
        this.aci = null;
    }

    PdxWriterImpl(PdxType pdxType, PdxOutputStream out) {
        this.tr = null;
        this.pdx = null;
        this.os = out;
        this.existingType = pdxType;
        this.headerOffset = this.os.size();
        this.aci = null;
    }

    PdxWriterImpl(PdxType pt, TypeRegistry tr, PdxOutputStream out) {
        this.tr = tr;
        this.pdx = null;
        this.os = out;
        this.newType = pt;
        this.headerOffset = this.os.size();
        this.aci = null;
    }

    public PdxWriterImpl(TypeRegistry tr, Object pdx, AutoSerializableManager.AutoClassInfo aci, PdxOutputStream os) {
        this.tr = tr;
        this.pdx = pdx;
        this.os = os;
        this.headerOffset = this.os.size();
        this.aci = aci;
    }

    private boolean fieldsWritten() {
        return this.fieldId >= 0;
    }

    private void beforeFieldWrite() {
        ++this.fieldId;
        if (this.fieldId > 0) {
            return;
        }
        this.initialize();
    }

    private void initialize() {
        this.writeHeader();
        if (this.existingType != null) {
            return;
        }
        if (this.definingNewPdxType()) {
            return;
        }
        PdxUnreadData ud = this.initUnreadData();
        if (ud == null && this.pdx != null) {
            this.existingType = this.aci != null ? this.aci.getSerializedType() : this.tr.getExistingType(this.pdx);
        } else if (ud != null) {
            this.existingType = ud.getSerializedType();
        }
        if (this.existingType != null) {
            int c = this.existingType.getVariableLengthFieldCount();
            if (c > 0) {
                this.vlfOffsets = new int[c];
            }
        } else if (this.pdx != null) {
            this.newType = new PdxType(this.pdx.getClass().getName(), true);
        }
    }

    PdxUnreadData initUnreadData() {
        PdxUnreadData ud;
        if (this.unreadDataInitialized) {
            return this.unreadData;
        }
        this.unreadDataInitialized = true;
        if (this.tr == null) {
            this.tr = GemFireCacheImpl.getForPdx("Could not access Pdx registry").getPdxRegistry();
        }
        if ((ud = this.unreadData) == null && this.pdx != null) {
            this.unreadData = ud = this.tr.getUnreadData(this.pdx);
        }
        return ud;
    }

    @Override
    public PdxWriter writeChar(String fieldName, char value) {
        this.updateMetaData(fieldName, FieldType.CHAR);
        this.os.writeChar(value);
        return this;
    }

    public void writeChar(char value) {
        this.beforeFieldWrite();
        this.os.writeChar(value);
    }

    @Override
    public PdxWriter writeBoolean(String fieldName, boolean value) {
        this.updateMetaData(fieldName, FieldType.BOOLEAN);
        this.os.writeByte(value ? 1 : 0);
        return this;
    }

    public void writeBoolean(boolean value) {
        this.beforeFieldWrite();
        this.os.writeByte(value ? 1 : 0);
    }

    @Override
    public PdxWriter writeByte(String fieldName, byte value) {
        this.updateMetaData(fieldName, FieldType.BYTE);
        this.os.writeByte(value);
        return this;
    }

    public void writeByte(byte value) {
        this.beforeFieldWrite();
        this.os.writeByte(value);
    }

    @Override
    public PdxWriter writeShort(String fieldName, short value) {
        this.updateMetaData(fieldName, FieldType.SHORT);
        this.os.writeShort(value);
        return this;
    }

    public void writeShort(short value) {
        this.beforeFieldWrite();
        this.os.writeShort(value);
    }

    @Override
    public PdxWriter writeInt(String fieldName, int value) {
        this.updateMetaData(fieldName, FieldType.INT);
        this.os.writeInt(value);
        return this;
    }

    public void writeInt(int value) {
        this.beforeFieldWrite();
        this.os.writeInt(value);
    }

    @Override
    public PdxWriter writeLong(String fieldName, long value) {
        this.updateMetaData(fieldName, FieldType.LONG);
        this.os.writeLong(value);
        return this;
    }

    public void writeLong(long value) {
        this.beforeFieldWrite();
        this.os.writeLong(value);
    }

    @Override
    public PdxWriter writeFloat(String fieldName, float value) {
        this.updateMetaData(fieldName, FieldType.FLOAT);
        this.os.writeFloat(value);
        return this;
    }

    public void writeFloat(float value) {
        this.beforeFieldWrite();
        this.os.writeFloat(value);
    }

    @Override
    public PdxWriter writeDouble(String fieldName, double value) {
        this.updateMetaData(fieldName, FieldType.DOUBLE);
        this.os.writeDouble(value);
        return this;
    }

    public void writeDouble(double value) {
        this.beforeFieldWrite();
        this.os.writeDouble(value);
    }

    @Override
    public PdxWriter writeDate(String fieldName, Date date) {
        if (date != null && !Date.class.equals(date.getClass())) {
            throw new IllegalArgumentException("writeDate only accepts instances of Date. Subclasses are not supported. Use writeObject for subclasses of Date.");
        }
        this.updateMetaData(fieldName, FieldType.DATE);
        this.os.writeDate(date);
        return this;
    }

    public void writeDate(Date date) {
        if (date != null && !Date.class.equals(date.getClass())) {
            throw new IllegalArgumentException("writeDate only accepts instances of Date. Subclasses are not supported. Use writeObject for subclasses of Date.");
        }
        this.beforeFieldWrite();
        this.os.writeDate(date);
    }

    @Override
    public PdxWriter writeString(String fieldName, String value) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.STRING);
        this.os.writeString(value);
        return this;
    }

    public void writeString(String value) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeString(value);
    }

    @Override
    public PdxWriter writeObject(String fieldName, Object object) {
        return this.writeObject(fieldName, object, false);
    }

    public void writeObject(Object object) {
        this.writeObject(object, false);
    }

    @Override
    public PdxWriter writeObject(String fieldName, Object object, boolean onlyPortableObjects) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.OBJECT);
        this.os.writeObject(object, onlyPortableObjects);
        return this;
    }

    public void writeObject(Object object, boolean onlyPortableObjects) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeObject(object, onlyPortableObjects);
    }

    @Override
    public PdxWriter writeBooleanArray(String fieldName, boolean[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.BOOLEAN_ARRAY);
        this.os.writeBooleanArray(array);
        return this;
    }

    public void writeBooleanArray(boolean[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeBooleanArray(array);
    }

    @Override
    public PdxWriter writeCharArray(String fieldName, char[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.CHAR_ARRAY);
        this.os.writeCharArray(array);
        return this;
    }

    public void writeCharArray(char[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeCharArray(array);
    }

    @Override
    public PdxWriter writeByteArray(String fieldName, byte[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.BYTE_ARRAY);
        this.os.writeByteArray(array);
        return this;
    }

    public void writeByteArray(byte[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeByteArray(array);
    }

    @Override
    public PdxWriter writeShortArray(String fieldName, short[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.SHORT_ARRAY);
        this.os.writeShortArray(array);
        return this;
    }

    public void writeShortArray(short[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeShortArray(array);
    }

    @Override
    public PdxWriter writeIntArray(String fieldName, int[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.INT_ARRAY);
        this.os.writeIntArray(array);
        return this;
    }

    public void writeIntArray(int[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeIntArray(array);
    }

    @Override
    public PdxWriter writeLongArray(String fieldName, long[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.LONG_ARRAY);
        this.os.writeLongArray(array);
        return this;
    }

    public void writeLongArray(long[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeLongArray(array);
    }

    @Override
    public PdxWriter writeFloatArray(String fieldName, float[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.FLOAT_ARRAY);
        this.os.writeFloatArray(array);
        return this;
    }

    public void writeFloatArray(float[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeFloatArray(array);
    }

    @Override
    public PdxWriter writeDoubleArray(String fieldName, double[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.DOUBLE_ARRAY);
        this.os.writeDoubleArray(array);
        return this;
    }

    public void writeDoubleArray(double[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeDoubleArray(array);
    }

    @Override
    public PdxWriter writeStringArray(String fieldName, String[] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.STRING_ARRAY);
        this.os.writeStringArray(array);
        return this;
    }

    public void writeStringArray(String[] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeStringArray(array);
    }

    @Override
    public PdxWriter writeObjectArray(String fieldName, Object[] array) {
        return this.writeObjectArray(fieldName, array, false);
    }

    public void writeObjectArray(Object[] array) {
        this.writeObjectArray(array, false);
    }

    @Override
    public PdxWriter writeObjectArray(String fieldName, Object[] array, boolean onlyPortableObjects) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.OBJECT_ARRAY);
        this.os.writeObjectArray(array, onlyPortableObjects);
        return this;
    }

    public void writeObjectArray(Object[] array, boolean onlyPortableObjects) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeObjectArray(array, onlyPortableObjects);
    }

    @Override
    public PdxWriter writeArrayOfByteArrays(String fieldName, byte[][] array) {
        this.markVariableField();
        this.updateMetaData(fieldName, FieldType.ARRAY_OF_BYTE_ARRAYS);
        this.os.writeArrayOfByteArrays(array);
        return this;
    }

    public void writeArrayOfByteArrays(byte[][] array) {
        this.markVariableField();
        this.beforeFieldWrite();
        this.os.writeArrayOfByteArrays(array);
    }

    public int completeByteStreamGeneration() {
        if (!this.alreadyGenerated) {
            int typeId;
            this.alreadyGenerated = true;
            if (!this.fieldsWritten()) {
                this.initialize();
            }
            this.writeUnreadData();
            this.appendOffsets();
            if (this.definingNewPdxType()) {
                this.newType.initialize(this);
                if (this.unreadData != null && !this.unreadData.isEmpty()) {
                    typeId = this.tr.defineType(this.newType);
                    this.unreadData.setSerializedType(this.newType);
                } else {
                    this.newType = this.tr.defineLocalType(this.pdx, this.newType);
                    typeId = this.newType.getTypeId();
                }
            } else {
                if (this.doExtraValidation()) {
                    int fieldCount = this.fieldId + 1;
                    if (this.existingType.getFieldCount() != fieldCount) {
                        throw new PdxSerializationException("Expected the number of fields for class " + this.existingType.getClassName() + " to be " + this.existingType.getFieldCount() + " but instead it was " + fieldCount);
                    }
                }
                typeId = this.existingType.getTypeId();
            }
            long bits = (long)this.getCurrentOffset() << 32 | 0xFFFFFFFFL & (long)typeId;
            this.lu.update(bits);
        }
        return this.getCurrentOffset() + 1;
    }

    public PdxType getAutoPdxType() {
        if (this.unreadData != null && !this.unreadData.isEmpty()) {
            return null;
        }
        this.completeByteStreamGeneration();
        if (this.definingNewPdxType()) {
            return this.newType;
        }
        return this.existingType;
    }

    public PdxType getPdxType() {
        return this.newType;
    }

    private int getBaseOffset() {
        return this.headerOffset + 1 + 8;
    }

    private int getCurrentOffset() {
        return this.os.size() - this.getBaseOffset();
    }

    private void appendOffsets() {
        int fieldDataSize = this.getCurrentOffset();
        byte sizeOfOffset = PdxWriterImpl.getSizeOfOffset(this.vlfCount, fieldDataSize);
        block5: for (int i = this.vlfCount - 1; i >= 0; --i) {
            switch (sizeOfOffset) {
                case 1: {
                    this.os.write((byte)this.vlfOffsets[i]);
                    continue block5;
                }
                case 2: {
                    this.os.writeShort((short)this.vlfOffsets[i]);
                    continue block5;
                }
                case 4: {
                    this.os.writeInt(this.vlfOffsets[i]);
                    continue block5;
                }
            }
        }
    }

    public static byte getSizeOfOffset(int offsetCount, int size) {
        if (offsetCount < 0 || size < 0) {
            throw new InternalGemFireException("Values cannot be negative. offsetCount: " + offsetCount + ", size: " + size + " bytes");
        }
        if (offsetCount * 1 + size <= 255) {
            return 1;
        }
        if (offsetCount * 2 + size <= 65535) {
            return 2;
        }
        return 4;
    }

    public void sendTo(DataOutput out) throws IOException {
        this.os.sendTo(out);
    }

    public byte[] toByteArray() {
        return this.os.toByteArray();
    }

    private void markVariableField() {
        if (!this.hasSeenFirstVlf) {
            this.hasSeenFirstVlf = true;
        } else {
            this.ensureVlfCapacity();
            this.vlfOffsets[this.vlfCount] = this.getCurrentOffset();
            ++this.vlfCount;
        }
    }

    private void ensureVlfCapacity() {
        int vlfOffsetsCapacity = 0;
        if (this.vlfOffsets != null) {
            vlfOffsetsCapacity = this.vlfOffsets.length;
        }
        if (this.vlfCount == vlfOffsetsCapacity) {
            int[] tmp = new int[vlfOffsetsCapacity + 32];
            for (int i = 0; i < vlfOffsetsCapacity; ++i) {
                tmp[i] = this.vlfOffsets[i];
            }
            this.vlfOffsets = tmp;
        }
    }

    int getVlfCount() {
        return this.vlfCount;
    }

    @Override
    public <CT, VT extends CT> PdxWriter writeField(String fieldName, VT fieldValue, Class<CT> fieldType) {
        return this.writeField(fieldName, fieldValue, fieldType, false);
    }

    @Override
    public <CT, VT extends CT> PdxWriter writeField(String fieldName, VT fieldValue, Class<CT> fieldType, boolean onlyPortableObjects) {
        if (fieldType.equals(Boolean.TYPE)) {
            boolean v = false;
            if (fieldValue != null) {
                v = (Boolean)fieldValue;
            }
            this.writeBoolean(fieldName, v);
        } else if (fieldType.equals(Byte.TYPE)) {
            byte v = 0;
            if (fieldValue != null) {
                v = (Byte)fieldValue;
            }
            this.writeByte(fieldName, v);
        } else if (fieldType.equals(Character.TYPE)) {
            char v = '\u0000';
            if (fieldValue != null) {
                v = ((Character)fieldValue).charValue();
            }
            this.writeChar(fieldName, v);
        } else if (fieldType.equals(Short.TYPE)) {
            short v = 0;
            if (fieldValue != null) {
                v = (Short)fieldValue;
            }
            this.writeShort(fieldName, v);
        } else if (fieldType.equals(Integer.TYPE)) {
            int v = 0;
            if (fieldValue != null) {
                v = (Integer)fieldValue;
            }
            this.writeInt(fieldName, v);
        } else if (fieldType.equals(Long.TYPE)) {
            long v = 0L;
            if (fieldValue != null) {
                v = (Long)fieldValue;
            }
            this.writeLong(fieldName, v);
        } else if (fieldType.equals(Float.TYPE)) {
            float v = 0.0f;
            if (fieldValue != null) {
                v = ((Float)fieldValue).floatValue();
            }
            this.writeFloat(fieldName, v);
        } else if (fieldType.equals(Double.TYPE)) {
            double v = 0.0;
            if (fieldValue != null) {
                v = (Double)fieldValue;
            }
            this.writeDouble(fieldName, v);
        } else if (fieldType.equals(String.class)) {
            this.writeString(fieldName, (String)fieldValue);
        } else if (fieldType.isArray()) {
            if (fieldType.equals(boolean[].class)) {
                this.writeBooleanArray(fieldName, (boolean[])fieldValue);
            } else if (fieldType.equals(byte[].class)) {
                this.writeByteArray(fieldName, (byte[])fieldValue);
            } else if (fieldType.equals(char[].class)) {
                this.writeCharArray(fieldName, (char[])fieldValue);
            } else if (fieldType.equals(short[].class)) {
                this.writeShortArray(fieldName, (short[])fieldValue);
            } else if (fieldType.equals(int[].class)) {
                this.writeIntArray(fieldName, (int[])fieldValue);
            } else if (fieldType.equals(long[].class)) {
                this.writeLongArray(fieldName, (long[])fieldValue);
            } else if (fieldType.equals(float[].class)) {
                this.writeFloatArray(fieldName, (float[])fieldValue);
            } else if (fieldType.equals(double[].class)) {
                this.writeDoubleArray(fieldName, (double[])fieldValue);
            } else if (fieldType.equals(String[].class)) {
                this.writeStringArray(fieldName, (String[])fieldValue);
            } else if (fieldType.equals(byte[][].class)) {
                this.writeArrayOfByteArrays(fieldName, (byte[][])fieldValue);
            } else {
                this.writeObjectArray(fieldName, (Object[])fieldValue, onlyPortableObjects);
            }
        } else if (fieldType.equals(Date.class)) {
            this.writeDate(fieldName, (Date)fieldValue);
        } else {
            this.writeObject(fieldName, fieldValue, onlyPortableObjects);
        }
        return this;
    }

    private void writeUnreadData() {
        if (this.unreadData != null) {
            this.unreadData.sendTo(this);
        }
    }

    public void writeRawField(PdxField ft, ByteBufferInputStream.ByteSource data) {
        if (ft.isVariableLengthType()) {
            this.markVariableField();
        }
        this.updateMetaData(ft);
        this.os.write(data);
    }

    public void writeRawField(PdxField ft, byte[] data) {
        if (ft.isVariableLengthType()) {
            this.markVariableField();
        }
        this.updateMetaData(ft);
        this.os.write(data, 0, data.length);
    }

    void writeField(PdxField f, Object value) {
        switch (f.getFieldType()) {
            case CHAR: {
                this.writeChar(null, ((Character)value).charValue());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean(null, (Boolean)value);
                break;
            }
            case BYTE: {
                this.writeByte(null, (Byte)value);
                break;
            }
            case SHORT: {
                this.writeShort(null, (Short)value);
                break;
            }
            case INT: {
                this.writeInt(null, (Integer)value);
                break;
            }
            case FLOAT: {
                this.writeFloat(null, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble(null, (Double)value);
                break;
            }
            case LONG: {
                this.writeLong(null, (Long)value);
                break;
            }
            case DATE: {
                this.writeDate(null, (Date)value);
                break;
            }
            case STRING: {
                this.writeString(null, (String)value);
                break;
            }
            case BOOLEAN_ARRAY: {
                this.writeBooleanArray(null, (boolean[])value);
                break;
            }
            case CHAR_ARRAY: {
                this.writeCharArray(null, (char[])value);
                break;
            }
            case BYTE_ARRAY: {
                this.writeByteArray(null, (byte[])value);
                break;
            }
            case SHORT_ARRAY: {
                this.writeShortArray(null, (short[])value);
                break;
            }
            case INT_ARRAY: {
                this.writeIntArray(null, (int[])value);
                break;
            }
            case LONG_ARRAY: {
                this.writeLongArray(null, (long[])value);
                break;
            }
            case FLOAT_ARRAY: {
                this.writeFloatArray(null, (float[])value);
                break;
            }
            case DOUBLE_ARRAY: {
                this.writeDoubleArray(null, (double[])value);
                break;
            }
            case STRING_ARRAY: {
                this.writeStringArray(null, (String[])value);
                break;
            }
            case ARRAY_OF_BYTE_ARRAYS: {
                this.writeArrayOfByteArrays(null, (byte[][])value);
                break;
            }
            case OBJECT_ARRAY: {
                this.writeObjectArray(null, (Object[])value);
                break;
            }
            case OBJECT: {
                this.writeObject(null, value);
                break;
            }
            default: {
                throw new InternalGemFireException("Unhandled field type " + (Object)((Object)f.getFieldType()));
            }
        }
    }

    private void writeHeader() {
        this.os.write((byte)93);
        this.lu = this.os.reserveLong();
    }

    public boolean definingNewPdxType() {
        return this.newType != null;
    }

    public void setDoExtraValidation(boolean v) {
        this.doExtraValidation = v;
    }

    private boolean doExtraValidation() {
        return this.doExtraValidation;
    }

    @Override
    public PdxWriter markIdentityField(String fieldName) {
        if (this.definingNewPdxType()) {
            PdxField ft = this.newType.getPdxField(fieldName);
            if (ft == null) {
                throw new PdxFieldDoesNotExistException("Field " + fieldName + " must be written before calling markIdentityField");
            }
            ft.setIdentityField(true);
        } else if (this.doExtraValidation()) {
            PdxField ft = this.existingType.getPdxField(fieldName);
            if (ft == null) {
                throw new PdxFieldDoesNotExistException("Field " + fieldName + " must be written before calling markIdentityField");
            }
            if (!ft.isIdentityField()) {
                throw new PdxSerializationException("Expected field " + fieldName + " to not be marked as an identity field since it was not for the first serialization");
            }
        }
        return this;
    }

    @Override
    public PdxWriter writeUnreadFields(PdxUnreadFields unread) {
        if (this.fieldsWritten()) {
            throw new PdxFieldAlreadyExistsException("writeUnreadFields must be called before any other fields are written.");
        }
        this.unreadData = (PdxUnreadData)unread;
        return this;
    }

    private void updateMetaData(String fieldName, FieldType type) {
        this.updateMetaData(fieldName, type, false);
    }

    private void updateMetaData(String fieldName, FieldType type, boolean isIdentityField) {
        this.beforeFieldWrite();
        if (this.definingNewPdxType()) {
            PdxField ft = new PdxField(fieldName, this.fieldId, this.vlfCount, type, isIdentityField);
            this.newType.addField(ft);
        } else if (this.doExtraValidation()) {
            PdxField ft = this.existingType.getPdxField(fieldName);
            if (ft == null) {
                throw new PdxSerializationException("Did not expect field " + fieldName + " to be serialized since it was not the first time this class was serialized.");
            }
            if (this.fieldId != ft.getFieldIndex()) {
                throw new PdxSerializationException("Detected that the order in which the fields are serialized changed since the first time this class was serialized.");
            }
            if (!ft.getFieldType().equals((Object)type)) {
                throw new PdxSerializationException("Expected field " + fieldName + " to be of type " + (Object)((Object)ft.getFieldType()) + " not of type " + (Object)((Object)type));
            }
        }
    }

    private void updateMetaData(PdxField ft) {
        this.updateMetaData(ft.getFieldName(), ft.getFieldType(), ft.isIdentityField());
    }

    PdxInstance makePdxInstance() {
        ByteBuffer bb = this.os.toByteBuffer();
        bb.get();
        int len = bb.getInt();
        bb.getInt();
        PdxType pt = this.newType;
        if (pt == null) {
            pt = this.existingType;
        }
        return new PdxInstanceImpl(pt, new PdxInputStream(bb), len);
    }

    public static boolean isPdx(byte[] valueBytes) {
        if (valueBytes == null || valueBytes.length < 1) {
            return false;
        }
        return valueBytes[0] == 93;
    }

    public int position() {
        return this.os.size();
    }
}

