/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.PdxFieldAlreadyExistsException;
import com.gemstone.gemfire.pdx.PdxSerializationException;
import com.gemstone.gemfire.pdx.internal.AutoSerializableManager;
import com.gemstone.gemfire.pdx.internal.PdxField;
import com.gemstone.gemfire.pdx.internal.PdxWriterImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class PdxType
implements DataSerializable {
    private static final long serialVersionUID = -1950047949756115279L;
    private int cachedHash = 0;
    private int typeId;
    private String className;
    private boolean noDomainClass;
    private boolean hasDeletedField;
    private int vlfCount;
    private final ArrayList<PdxField> fields = new ArrayList();
    private final transient Map<String, PdxField> fieldsMap = new HashMap<String, PdxField>();
    private volatile transient SortedSet<PdxField> sortedIdentityFields;
    private static final byte NO_DOMAIN_CLASS_BIT = 1;
    private static final byte HAS_DELETED_FIELD_BIT = 2;
    private final transient AtomicReference<AutoSerializableManager.AutoClassInfo> autoClassInfo = new AtomicReference();

    public PdxType() {
    }

    public PdxType(String name, boolean expectDomainClass) {
        this.className = name;
        this.noDomainClass = !expectDomainClass;
    }

    public PdxType(PdxType copy) {
        this.typeId = copy.typeId;
        this.className = copy.className;
        this.noDomainClass = copy.noDomainClass;
        this.vlfCount = copy.vlfCount;
        for (PdxField ft : copy.fields) {
            this.addField(ft);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.className = DataSerializer.readString(in);
        byte bits = in.readByte();
        this.noDomainClass = (bits & 1) != 0;
        this.hasDeletedField = (bits & 2) != 0;
        this.typeId = in.readInt();
        this.vlfCount = in.readInt();
        int arrayLen = InternalDataSerializer.readArrayLength(in);
        for (int i = 0; i < arrayLen; ++i) {
            PdxField vft = new PdxField();
            vft.fromData(in);
            this.addField(vft);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        Version sourceVersion;
        DataSerializer.writeString(this.className, out);
        byte bits = 0;
        if (this.noDomainClass) {
            bits = (byte)(bits | 1);
        }
        if ((sourceVersion = InternalDataSerializer.getVersionForDataStream(out)).compareTo(Version.GFE_81) >= 0 && this.hasDeletedField) {
            bits = (byte)(bits | 2);
        }
        out.writeByte(bits);
        out.writeInt(this.typeId);
        out.writeInt(this.vlfCount);
        InternalDataSerializer.writeArrayLength(this.fields.size(), out);
        for (int i = 0; i < this.fields.size(); ++i) {
            PdxField vft = this.fields.get(i);
            vft.toData(out);
        }
    }

    public int hashCode() {
        int hash = this.cachedHash;
        if (hash == 0) {
            hash = 1;
            hash = hash * 31 + this.className.hashCode();
            for (PdxField field : this.fields) {
                hash = hash * 31 + field.hashCode();
            }
            if (hash == 0) {
                hash = 1;
            }
            this.cachedHash = hash;
        }
        return this.cachedHash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof PdxType)) {
            return false;
        }
        PdxType otherVT = (PdxType)other;
        if (!this.className.equals(otherVT.className)) {
            return false;
        }
        if (this.noDomainClass != otherVT.noDomainClass) {
            return false;
        }
        if (otherVT.fields.size() != this.fields.size() || otherVT.vlfCount != this.vlfCount) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).equals(otherVT.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean compatible(PdxType other) {
        if (other == null) {
            return false;
        }
        if (!this.getClassName().equals(other.getClassName())) {
            return false;
        }
        Collection<PdxField> myFields = this.getSortedFields();
        Collection<PdxField> otherFields = other.getSortedFields();
        return myFields.equals(otherFields);
    }

    public int getVariableLengthFieldCount() {
        return this.vlfCount;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getPdxClass() {
        try {
            return InternalDataSerializer.getCachedClass(this.getClassName());
        }
        catch (Exception e) {
            PdxSerializationException ex = new PdxSerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_A_CLASS_0.toLocalizedString(this.getClassName()), e);
            throw ex;
        }
    }

    public boolean getNoDomainClass() {
        return this.noDomainClass;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getDSId() {
        return this.typeId >> 24;
    }

    public int getTypeNum() {
        return this.typeId & 0xFFFFFF;
    }

    public void setTypeId(int tId) {
        this.typeId = tId;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addField(PdxField ft) {
        if (this.fieldsMap.put(ft.getFieldName(), ft) != null) {
            throw new PdxFieldAlreadyExistsException("The field \"" + ft.getFieldName() + "\" already exists.");
        }
        this.fields.add(ft);
    }

    public void initialize(PdxWriterImpl writer) {
        this.vlfCount = writer.getVlfCount();
        int size = this.fields.size();
        int fixedLenFieldOffset = 0;
        boolean seenVariableLenType = false;
        for (int i = 0; i < size; ++i) {
            PdxField vft = this.fields.get(i);
            if (vft.isVariableLengthType()) {
                if (seenVariableLenType) {
                    vft.setVlfOffsetIndex(vft.getVarLenFieldSeqId());
                } else {
                    vft.setRelativeOffset(fixedLenFieldOffset);
                    vft.setVlfOffsetIndex(-1);
                }
                seenVariableLenType = true;
                continue;
            }
            if (seenVariableLenType) {
                PdxField tmp = null;
                int minusOffset = vft.getFieldType().getWidth();
                for (int j = i + 1; j < size && !(tmp = this.fields.get(j)).isVariableLengthType(); ++j) {
                    minusOffset += tmp.getFieldType().getWidth();
                }
                if (tmp != null && tmp.isVariableLengthType()) {
                    vft.setRelativeOffset(-minusOffset);
                    vft.setVlfOffsetIndex(tmp.getVarLenFieldSeqId());
                    continue;
                }
                vft.setRelativeOffset(-minusOffset);
                vft.setVlfOffsetIndex(-1);
                continue;
            }
            vft.setRelativeOffset(fixedLenFieldOffset);
            fixedLenFieldOffset += vft.getFieldType().getWidth();
        }
    }

    public PdxField getPdxField(String fieldName) {
        PdxField result = this.fieldsMap.get(fieldName);
        if (result != null && result.isDeleted()) {
            result = null;
        }
        return result;
    }

    public List<PdxField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public PdxField getPdxFieldByIndex(int index) {
        return this.fields.get(index);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int getUndeletedFieldCount() {
        if (!this.getHasDeletedField()) {
            return 0;
        }
        int result = this.fields.size();
        for (PdxField f : this.fields) {
            if (!f.isDeleted()) continue;
            --result;
        }
        return result;
    }

    public String toFormattedString() {
        StringBuffer sb = new StringBuffer("PdxType[\n    ");
        sb.append("dsid=").append(this.getDSId());
        sb.append(", typenum=").append(this.getTypeNum());
        sb.append(", name=").append(this.className);
        sb.append(", fields=[");
        for (PdxField vft : this.fields) {
            sb.append("\n        ");
            sb.append(vft.toString());
        }
        sb.append("]]");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PdxType[");
        sb.append("dsid=").append(this.getDSId());
        sb.append(",typenum=").append(this.getTypeNum());
        sb.append(",name=").append(this.className);
        sb.append(",fields=[");
        for (PdxField vft : this.fields) {
            sb.append(vft.toString()).append(", ");
        }
        sb.append("]]");
        return sb.toString();
    }

    public List<Integer> getUnreadFieldIndexes(List<String> readFields) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (PdxField ft : this.fields) {
            if (ft.isDeleted() || readFields.contains(ft.getFieldName())) continue;
            result.add(ft.getFieldIndex());
        }
        return result;
    }

    public boolean hasExtraFields(PdxType other) {
        for (PdxField ft : this.fields) {
            if (ft.isDeleted() || other.getPdxField(ft.getFieldName()) != null) continue;
            return true;
        }
        return false;
    }

    public SortedSet<PdxField> getSortedIdentityFields() {
        if (this.sortedIdentityFields == null) {
            TreeSet<PdxField> sortedSet = new TreeSet<PdxField>();
            for (PdxField field : this.fields) {
                if (!field.isIdentityField() || field.isDeleted()) continue;
                sortedSet.add(field);
            }
            if (sortedSet.isEmpty()) {
                for (PdxField field : this.fields) {
                    if (field.isDeleted()) continue;
                    sortedSet.add(field);
                }
            }
            this.sortedIdentityFields = sortedSet;
        }
        return this.sortedIdentityFields;
    }

    public Collection<PdxField> getSortedFields() {
        TreeSet<PdxField> sortedSet = new TreeSet<PdxField>();
        for (PdxField pf : this.fields) {
            if (pf.isDeleted()) continue;
            sortedSet.add(pf);
        }
        return new ArrayList<PdxField>(sortedSet);
    }

    public List<String> getFieldNames() {
        ArrayList<String> result = new ArrayList<String>(this.fields.size());
        for (PdxField f : this.fields) {
            if (f.isDeleted()) continue;
            result.add(f.getFieldName());
        }
        return Collections.unmodifiableList(result);
    }

    public void setAutoInfo(AutoSerializableManager.AutoClassInfo autoClassInfo) {
        this.autoClassInfo.set(autoClassInfo);
    }

    public AutoSerializableManager.AutoClassInfo getAutoInfo(Class<?> c) {
        AutoSerializableManager.AutoClassInfo ci = this.autoClassInfo.get();
        if (ci != null) {
            Class<?> lastClassAutoSerialized = ci.getInfoClass();
            if (c.equals(lastClassAutoSerialized)) {
                return ci;
            }
            if (lastClassAutoSerialized == null) {
                this.autoClassInfo.compareAndSet(ci, null);
            }
        }
        return null;
    }

    public void toStream(PrintStream printStream, boolean printFields) {
        printStream.print("  ");
        printStream.print(this.getClassName());
        printStream.print(": ");
        printStream.print("id=");
        printStream.print(this.getTypeNum());
        if (this.getDSId() != 0) {
            printStream.print(" dsId=");
            printStream.print(this.getDSId());
        }
        printStream.println();
        if (printFields) {
            for (PdxField field : this.fields) {
                field.toStream(printStream);
            }
        }
    }

    public boolean getHasDeletedField() {
        return this.hasDeletedField;
    }

    public void setHasDeletedField(boolean b) {
        this.hasDeletedField = b;
    }
}

