/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.internal.AddPDXEnumOp;
import com.gemstone.gemfire.cache.client.internal.AddPDXTypeOp;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.GetPDXEnumByIdOp;
import com.gemstone.gemfire.cache.client.internal.GetPDXEnumsOp;
import com.gemstone.gemfire.cache.client.internal.GetPDXIdForEnumOp;
import com.gemstone.gemfire.cache.client.internal.GetPDXIdForTypeOp;
import com.gemstone.gemfire.cache.client.internal.GetPDXTypeByIdOp;
import com.gemstone.gemfire.cache.client.internal.GetPDXTypesOp;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.TypeRegistration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class ClientTypeRegistration
implements TypeRegistration {
    private static final Logger logger = LogService.getLogger();
    private final GemFireCacheImpl cache;
    private volatile boolean typeRegistryInUse = false;

    public ClientTypeRegistration(GemFireCacheImpl cache) {
        this.cache = cache;
    }

    @Override
    public int defineType(PdxType newType) {
        this.verifyConfiguration();
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                int result = GetPDXIdForTypeOp.execute((ExecutablePool)((Object)pool), newType);
                newType.setTypeId(result);
                this.sendTypeToAllPools(newType, result, pools, pool);
                return result;
            }
            catch (ServerConnectivityException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (this.cache.isClosed()) {
            throw new CacheClosedException("PDX detected cache was closed");
        }
        throw new CacheClosedException("Client pools have been closed so the PDX type registry can not define a type.");
    }

    private void sendTypeToAllPools(PdxType type, int id, Collection<Pool> pools, Pool definingPool) {
        for (Pool pool : pools) {
            if (pool.equals(definingPool)) continue;
            try {
                AddPDXTypeOp.execute((ExecutablePool)((Object)pool), id, type);
            }
            catch (ServerConnectivityException ignore) {
                logger.debug("Received an exception sending pdx type to pool {}, {}", new Object[]{pool, ignore.getMessage(), ignore});
            }
        }
    }

    @Override
    public PdxType getType(int typeId) {
        this.verifyConfiguration();
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                PdxType type = GetPDXTypeByIdOp.execute((ExecutablePool)((Object)pool), typeId);
                if (type == null) continue;
                return type;
            }
            catch (ServerConnectivityException e) {
                logger.debug("Received an exception getting pdx type from pool {}, {}", new Object[]{pool, e.getMessage(), e});
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (pools.isEmpty()) {
            if (this.cache.isClosed()) {
                throw new CacheClosedException("PDX detected cache was closed");
            }
            throw new CacheClosedException("Client pools have been closed so the PDX type registry can not lookup a type.");
        }
        throw new InternalGemFireError("getType: Unable to determine PDXType for id " + typeId + " from existing client to server pools " + pools);
    }

    private Collection<Pool> getAllPools() {
        return ClientTypeRegistration.getAllPools(this.cache);
    }

    private static Collection<Pool> getAllPools(GemFireCacheImpl cache) {
        Collection<Pool> pools = PoolManagerImpl.getPMI().getMap().values();
        Iterator<Pool> itr = pools.iterator();
        while (itr.hasNext()) {
            PoolImpl pool = (PoolImpl)itr.next();
            if (!pool.isUsedByGateway()) continue;
            itr.remove();
        }
        return pools;
    }

    @Override
    public void addRemoteType(int typeId, PdxType type) {
        throw new UnsupportedOperationException("Clients will not be asked to add remote types");
    }

    @Override
    public int getLastAllocatedTypeId() {
        throw new UnsupportedOperationException("Clients does not keep track of last allocated id");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void gatewaySenderStarted(GatewaySender gatewaySender) {
        this.checkAllowed();
    }

    @Override
    public void creatingPersistentRegion() {
    }

    @Override
    public void creatingPool() {
    }

    @Override
    public int getEnumId(Enum<?> v) {
        EnumInfo ei = new EnumInfo(v);
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                int result = GetPDXIdForEnumOp.execute((ExecutablePool)((Object)pool), ei);
                this.sendEnumIdToAllPools(ei, result, pools, pool);
                return result;
            }
            catch (ServerConnectivityException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (this.cache.isClosed()) {
            throw new CacheClosedException("PDX detected cache was closed");
        }
        throw new CacheClosedException("Client pools have been closed so the PDX type registry can not define a type.");
    }

    private void sendEnumIdToAllPools(EnumInfo enumInfo, int id, Collection<Pool> pools, Pool definingPool) {
        for (Pool pool : pools) {
            if (pool.equals(definingPool)) continue;
            try {
                AddPDXEnumOp.execute((ExecutablePool)((Object)pool), id, enumInfo);
            }
            catch (ServerConnectivityException ignore) {
                logger.debug("Received an exception sending pdx type to pool {}, {}", new Object[]{pool, ignore.getMessage(), ignore});
            }
        }
    }

    @Override
    public void addRemoteEnum(int enumId, EnumInfo newInfo) {
        throw new UnsupportedOperationException("Clients will not be asked to add remote enums");
    }

    @Override
    public int defineEnum(EnumInfo newInfo) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                int result = GetPDXIdForEnumOp.execute((ExecutablePool)((Object)pool), newInfo);
                this.sendEnumIdToAllPools(newInfo, result, pools, pool);
                return result;
            }
            catch (ServerConnectivityException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (this.cache.isClosed()) {
            throw new CacheClosedException("PDX detected cache was closed");
        }
        throw new CacheClosedException("Client pools have been closed so the PDX type registry can not define a type.");
    }

    @Override
    public EnumInfo getEnumById(int enumId) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                EnumInfo result = GetPDXEnumByIdOp.execute((ExecutablePool)((Object)pool), enumId);
                if (result == null) continue;
                return result;
            }
            catch (ServerConnectivityException e) {
                logger.debug("Received an exception getting pdx type from pool {}, {}", new Object[]{pool, e.getMessage(), e});
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (pools.isEmpty()) {
            if (this.cache.isClosed()) {
                throw new CacheClosedException("PDX detected cache was closed");
            }
            throw new CacheClosedException("Client pools have been closed so the PDX type registry can not lookup an enum.");
        }
        throw new InternalGemFireError("getEnum: Unable to determine pdx enum for id " + enumId + " from existing client to server pools " + pools);
    }

    private void verifyConfiguration() {
        if (this.typeRegistryInUse) {
            return;
        }
        this.typeRegistryInUse = true;
        this.checkAllowed();
    }

    private void checkAllowed() {
        if (!this.typeRegistryInUse) {
            return;
        }
    }

    @Override
    public Map<Integer, PdxType> types() {
        Collection<Pool> pools = this.getAllPools();
        if (pools.isEmpty()) {
            if (this.cache.isClosed()) {
                throw new CacheClosedException("PDX detected cache was closed");
            }
            throw new CacheClosedException("Client pools have been closed so the PDX type registry is not available.");
        }
        HashMap<Integer, PdxType> types = new HashMap<Integer, PdxType>();
        for (Pool p : pools) {
            try {
                types.putAll(GetPDXTypesOp.execute((ExecutablePool)((Object)p)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return types;
    }

    @Override
    public Map<Integer, EnumInfo> enums() {
        Collection<Pool> pools = this.getAllPools();
        if (pools.isEmpty()) {
            if (this.cache.isClosed()) {
                throw new CacheClosedException("PDX detected cache was closed");
            }
            throw new CacheClosedException("Client pools have been closed so the PDX type registry is not available.");
        }
        HashMap<Integer, EnumInfo> enums = new HashMap<Integer, EnumInfo>();
        for (Pool p : pools) {
            enums.putAll(GetPDXEnumsOp.execute((ExecutablePool)((Object)p)));
        }
        return enums;
    }

    @Override
    public PdxType getPdxTypeForField(String fieldName, String className) {
        for (PdxType value : this.types().values()) {
            PdxType pdxType;
            if (!(value instanceof PdxType) || !(pdxType = value).getClassName().equals(className) || pdxType.getPdxField(fieldName) == null) continue;
            return pdxType;
        }
        return null;
    }

    @Override
    public void testClearRegistry() {
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void addImportedType(int typeId, PdxType importedType) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                this.sendTypeToAllPools(importedType, typeId, pools, pool);
            }
            catch (ServerConnectivityException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (this.cache.isClosed()) {
            throw new CacheClosedException("PDX detected cache was closed");
        }
        throw new CacheClosedException("Client pools have been closed so the PDX type registry can not define a type.");
    }

    @Override
    public void addImportedEnum(int enumId, EnumInfo importedInfo) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                this.sendEnumIdToAllPools(importedInfo, enumId, pools, pool);
            }
            catch (ServerConnectivityException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (this.cache.isClosed()) {
            throw new CacheClosedException("PDX detected cache was closed");
        }
        throw new CacheClosedException("Client pools have been closed so the PDX type registry can not define a type.");
    }

    @Override
    public int getLocalSize() {
        return 0;
    }
}

