/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.security;

import com.gemstone.gemfire.cache.operations.OperationContext;
import java.util.HashMap;
import java.util.Map;

public abstract class ResourceOperationContext
extends OperationContext {
    public abstract ResourceOperationCode getResourceOperationCode();

    @Override
    public boolean isPostOperation() {
        return false;
    }

    public static class ResourceOperationCode {
        private static final byte OP_LIST_DS = 1;
        private static final byte OP_READ_DS = 2;
        private static final byte OP_SET_DS = 3;
        private static final byte OP_ADMIN_DS = 4;
        private static final byte OP_CHANGE_ALERT_LEVEL_DS = 5;
        private static final byte OP_BACKUP_DS = 6;
        private static final byte OP_REMOVE_DISKSTORE_DS = 7;
        private static final byte OP_SHUTDOWN_DS = 8;
        private static final byte OP_QUERYDATA_DS = 9;
        private static final byte OP_REBALANCE_DS = 10;
        private static final byte OP_EXPORT_DATA_REGION = 11;
        private static final byte OP_IMPORT_DATA_REGION = 12;
        private static final byte OP_PUT_REGION = 13;
        private static final byte OP_LOCATE_ENTRY_REGION = 14;
        private static final byte OP_PULSE_DASHBOARD = 15;
        private static final byte OP_PULSE_DATABROWSER = 16;
        private static final byte OP_PULSE_WEBGFSH = 17;
        private static final byte OP_PULSE_ADMIN_V1 = 18;
        private static final ResourceOperationCode[] VALUES = new ResourceOperationCode[20];
        private static final Map OperationNameMap = new HashMap();
        public static final ResourceOperationCode LIST_DS = new ResourceOperationCode("LIST_DS", 1);
        public static final ResourceOperationCode READ_DS = new ResourceOperationCode("READ_DS", 2);
        public static final ResourceOperationCode SET_DS = new ResourceOperationCode("SET_DS", 3);
        public static final ResourceOperationCode CHANGE_ALERT_LEVEL_DS = new ResourceOperationCode("CHANGE_ALERT_LEVEL_DS", 5);
        public static final ResourceOperationCode BACKUP_DS = new ResourceOperationCode("BACKUP_DS", 6);
        public static final ResourceOperationCode REMOVE_DISKSTORE_DS = new ResourceOperationCode("REMOVE_DISKSTORE_DS", 7);
        public static final ResourceOperationCode SHUTDOWN_DS = new ResourceOperationCode("SHUTDOWN_DS", 8);
        public static final ResourceOperationCode QUERYDATA_DS = new ResourceOperationCode("QUERYDATA_DS", 9);
        public static final ResourceOperationCode REBALANCE_DS = new ResourceOperationCode("REBALANCE", 10);
        public static final ResourceOperationCode EXPORT_DATA_REGION = new ResourceOperationCode("EXPORT_DATA", 11);
        public static final ResourceOperationCode IMPORT_DATA_REGION = new ResourceOperationCode("IMPORT_DATA", 12);
        public static final ResourceOperationCode PUT_REGION = new ResourceOperationCode("PUT", 13);
        public static final ResourceOperationCode LOCATE_ENTRY_REGION = new ResourceOperationCode("LOCATE_ENTRY", 14);
        public static final ResourceOperationCode PULSE_DASHBOARD = new ResourceOperationCode("PULSE_DASHBOARD", 15);
        public static final ResourceOperationCode PULSE_DATABROWSER = new ResourceOperationCode("PULSE_DATABROWSER", 16);
        public static final ResourceOperationCode PULSE_WEBGFSH = new ResourceOperationCode("PULSE_WEBGFSH", 17);
        public static final ResourceOperationCode PULSE_ADMIN_V1 = new ResourceOperationCode("PULSE_ADMIN_V1", 18);
        public static final ResourceOperationCode ADMIN_DS = new ResourceOperationCode("ADMIN_DS", 4, new ResourceOperationCode[]{CHANGE_ALERT_LEVEL_DS, BACKUP_DS, REMOVE_DISKSTORE_DS, SHUTDOWN_DS, QUERYDATA_DS, REBALANCE_DS, PULSE_DASHBOARD, PULSE_DATABROWSER, PULSE_WEBGFSH, PULSE_ADMIN_V1});
        private final String name;
        private final byte opCode;
        private final ResourceOperationCode[] children;

        private ResourceOperationCode(String name, byte opCode) {
            this.name = name;
            this.opCode = opCode;
            ResourceOperationCode.VALUES[opCode] = this;
            OperationNameMap.put(name, this);
            this.children = null;
        }

        private ResourceOperationCode(String name, byte opCode, ResourceOperationCode[] children) {
            this.name = name;
            this.opCode = opCode;
            ResourceOperationCode.VALUES[opCode] = this;
            OperationNameMap.put(name, this);
            this.children = children;
        }

        public ResourceOperationCode[] getChildren() {
            return this.children;
        }

        public static ResourceOperationCode fromOrdinal(byte opCode) {
            return VALUES[opCode];
        }

        public static ResourceOperationCode parse(String operationName) {
            return (ResourceOperationCode)OperationNameMap.get(operationName);
        }

        public byte toOrdinal() {
            return this.opCode;
        }

        public final String toString() {
            return this.name;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ResourceOperationCode)) {
                return false;
            }
            ResourceOperationCode other = (ResourceOperationCode)obj;
            return other.opCode == this.opCode;
        }

        public final boolean equals(ResourceOperationCode opCode) {
            return opCode != null && opCode.opCode == this.opCode;
        }

        public final int hashCode() {
            return this.opCode;
        }
    }
}

