/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.security;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.util.ClasspathScanLoadHelper;
import com.gemstone.gemfire.management.internal.security.Resource;
import com.gemstone.gemfire.management.internal.security.ResourceOperation;
import com.gemstone.gemfire.management.internal.security.ResourceOperationContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;

public class JMXOperationContext
extends ResourceOperationContext {
    private OperationContext.OperationCode code = OperationContext.OperationCode.RESOURCE;
    private ResourceOperationContext.ResourceOperationCode resourceCode = null;
    private static Map<String, ResourceOperationContext.ResourceOperationCode> cacheDSResourceOps = null;
    private static Map<String, ResourceOperationContext.ResourceOperationCode> cacheMemberResourceOps = null;
    private static Map<String, ResourceOperationContext.ResourceOperationCode> cacheRegionResourceOps = null;
    private static Map<String, ResourceOperationContext.ResourceOperationCode> cacheDiskStoreResourceOps = null;

    private static void readJMXAnnotations() {
        try {
            Class<?>[] klassList;
            for (Class<?> klass : klassList = ClasspathScanLoadHelper.getClasses("com.gemstone.gemfire.management")) {
                Method[] methods;
                if (!klass.getName().endsWith("MXBean")) continue;
                for (Method method : methods = klass.getMethods()) {
                    Annotation[] ans;
                    String name = method.getName();
                    boolean found = false;
                    for (Annotation an : ans = method.getDeclaredAnnotations()) {
                        if (!(an instanceof ResourceOperation)) continue;
                        JMXOperationContext.cache(klass, name, (ResourceOperation)an);
                        found = true;
                    }
                    if (found) continue;
                    JMXOperationContext.cache(klass, name, null);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new GemFireConfigException("Error while configuring authorization for jmx - ", e);
        }
        catch (IOException e) {
            throw new GemFireConfigException("Error while configuring authorization for jmx - ", e);
        }
    }

    private static void cache(Class klass, String name, ResourceOperation op) {
        String opString;
        ResourceOperationContext.ResourceOperationCode code = null;
        if (op != null && (opString = op.operation()) != null) {
            code = ResourceOperationContext.ResourceOperationCode.parse(opString);
        }
        if (code == null) {
            if (name.startsWith("list") || name.startsWith("fetch") || name.startsWith("view") || name.startsWith("show")) {
                code = ResourceOperationContext.ResourceOperationCode.LIST_DS;
            } else if (name.startsWith("get")) {
                code = ResourceOperationContext.ResourceOperationCode.READ_DS;
            } else if (name.startsWith("is")) {
                code = ResourceOperationContext.ResourceOperationCode.READ_DS;
            } else if (name.startsWith("set")) {
                code = ResourceOperationContext.ResourceOperationCode.SET_DS;
            }
        }
        Resource targetedResource = null;
        if (op != null) {
            targetedResource = op.resource();
        } else if (klass.equals(DistributedSystemMXBean.class)) {
            targetedResource = Resource.DISTRIBUTED_SYSTEM;
        }
        if (targetedResource != null) {
            switch (targetedResource) {
                case DISTRIBUTED_SYSTEM: {
                    if (code == null) break;
                    if (cacheDSResourceOps == null) {
                        cacheDSResourceOps = new HashMap<String, ResourceOperationContext.ResourceOperationCode>();
                    }
                    cacheDSResourceOps.put(name, code);
                }
            }
        }
    }

    private static boolean isGetterSetter(String name) {
        return name.startsWith("is") || name.startsWith("get") || name.startsWith("set") || name.startsWith("fetch") || name.startsWith("list") || name.startsWith("view") || name.startsWith("show");
    }

    public JMXOperationContext(ObjectName name, String methodName) {
        if (name.equals(MBeanJMXAdapter.getDistributedSystemName())) {
            this.resourceCode = cacheDSResourceOps.get(methodName);
        }
    }

    @Override
    public OperationContext.OperationCode getOperationCode() {
        return this.code;
    }

    @Override
    public ResourceOperationContext.ResourceOperationCode getResourceOperationCode() {
        return this.resourceCode;
    }

    public static Map<String, ResourceOperationContext.ResourceOperationCode> getCacheDSResourceOps() {
        return cacheDSResourceOps;
    }

    public static void setCacheDSResourceOps(Map<String, ResourceOperationContext.ResourceOperationCode> cacheDSResourceOps) {
        JMXOperationContext.cacheDSResourceOps = cacheDSResourceOps;
    }

    static {
        JMXOperationContext.readJMXAnnotations();
    }
}

