/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.security;

import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.cli.CommandProcessingException;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.GfshParseResult;
import com.gemstone.gemfire.management.internal.cli.GfshParser;
import com.gemstone.gemfire.management.internal.cli.parser.CommandTarget;
import com.gemstone.gemfire.management.internal.security.Resource;
import com.gemstone.gemfire.management.internal.security.ResourceOperation;
import com.gemstone.gemfire.management.internal.security.ResourceOperationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.shell.event.ParseResult;

public class CLIOperationContext
extends ResourceOperationContext {
    private OperationContext.OperationCode code = OperationContext.OperationCode.RESOURCE;
    private ResourceOperationContext.ResourceOperationCode resourceCode = null;
    private Map<String, String> commandOptions = null;
    private static Map<String, ResourceOperationContext.ResourceOperationCode> commandToCodeMapping = new HashMap<String, ResourceOperationContext.ResourceOperationCode>();
    private static CommandManager commandManager = null;
    private static GfshParser parser = null;

    public CLIOperationContext(String commandString) throws CommandProcessingException, IllegalStateException {
        GfshParseResult parseResult = (GfshParseResult)CLIOperationContext.parseCommand(commandString);
        this.commandOptions = parseResult.getParamValueStrings();
        this.resourceCode = CLIOperationContext.findResourceCode(parseResult.getCommandName());
    }

    private static ParseResult parseCommand(String commentLessLine) throws CommandProcessingException, IllegalStateException {
        if (commentLessLine != null) {
            return parser.parse(commentLessLine);
        }
        throw new IllegalStateException("Command String should not be null.");
    }

    public static void registerCommand(CommandManager cmdManager, Method method, CommandTarget commandTarget) {
        Annotation[] ans;
        if (commandManager == null) {
            commandManager = cmdManager;
            parser = new GfshParser(cmdManager);
        }
        boolean found = false;
        for (Annotation an : ans = method.getDeclaredAnnotations()) {
            if (!(an instanceof ResourceOperation)) continue;
            CLIOperationContext.cache(commandTarget.getCommandName(), (ResourceOperation)an);
            found = true;
        }
        if (!found) {
            CLIOperationContext.cache(commandTarget.getCommandName(), null);
        }
    }

    private static void cache(String commandName, ResourceOperation op) {
        String opString;
        ResourceOperationContext.ResourceOperationCode code = null;
        if (op != null && (opString = op.operation()) != null) {
            code = ResourceOperationContext.ResourceOperationCode.parse(opString);
        }
        if (code == null && (commandName.startsWith("describe") || commandName.startsWith("list") || commandName.startsWith("status") || commandName.startsWith("show"))) {
            code = ResourceOperationContext.ResourceOperationCode.LIST_DS;
        }
        Resource targetedResource = null;
        targetedResource = op != null ? op.resource() : Resource.DISTRIBUTED_SYSTEM;
        LogService.getLogger().trace("#RegisterCommandSecurity : " + commandName + " code " + code + " op=" + op);
        if (code != null) {
            commandToCodeMapping.put(commandName, code);
        }
    }

    public Map<String, String> getCommandOptions() {
        return this.commandOptions;
    }

    private static ResourceOperationContext.ResourceOperationCode findResourceCode(String commandName) {
        return commandToCodeMapping.get(commandName);
    }

    @Override
    public OperationContext.OperationCode getOperationCode() {
        return this.code;
    }

    @Override
    public ResourceOperationContext.ResourceOperationCode getResourceOperationCode() {
        return this.resourceCode;
    }

    public String toString() {
        String str = "CLIOperationContext(resourceCode=" + this.resourceCode + ") options=" + this.commandOptions + ")";
        return str;
    }
}

