/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.configuration.handlers;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpHandler;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpServer;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.configuration.messages.ConfigurationRequest;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class ConfigurationRequestHandler
implements TcpHandler {
    private static final Logger logger = LogService.getLogger();
    SharedConfiguration sharedConfig;

    public ConfigurationRequestHandler(SharedConfiguration sharedConfig) {
        this.sharedConfig = sharedConfig;
    }

    @Override
    public Object processRequest(Object request) throws IOException {
        assert (request instanceof ConfigurationRequest);
        try {
            logger.info("Received request for configuration  : {}", new Object[]{request});
            ConfigurationRequest configRequest = (ConfigurationRequest)request;
            return this.sharedConfig.createConfigurationReponse(configRequest);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void endRequest(Object request, long startTime) {
    }

    @Override
    public void endResponse(Object request, long startTime) {
    }

    @Override
    public void shutDown() {
    }

    @Override
    public void init(TcpServer tcpServer) {
    }

    @Override
    public void restarting(DistributedSystem system, GemFireCache cache, SharedConfiguration sharedConfig) {
        if (sharedConfig != null) {
            this.sharedConfig = sharedConfig;
        }
    }
}

