/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.result;

import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.ArrayList;
import java.util.Collections;

public class TableBuilderHelper {
    private static final int SCREEN_WIDTH_MARGIN_BUFFER = 5;

    public static int[] recalculateColSizesForScreen(int screenWidth, int[] colSizes, String colSeparators) {
        if (TableBuilderHelper.shouldTrimColumns()) {
            int totalLength = 0;
            screenWidth -= (colSizes.length - 1) * colSeparators.length();
            ArrayList<Column> stringList = new ArrayList<Column>();
            int index = 0;
            for (int k : colSizes) {
                Column cs = new Column();
                cs.originalIndex = index++;
                cs.length = k;
                stringList.add(cs);
                totalLength += k;
            }
            if (totalLength <= screenWidth) {
                return colSizes;
            }
            Collections.sort(stringList);
            totalLength = 0;
            int spaceLeft = 0;
            int totalExtra = 0;
            for (Column s : stringList) {
                int newLength = totalLength + s.length;
                if (newLength + 5 > screenWidth) {
                    s.markForTrim = true;
                    totalExtra += s.length;
                    if (spaceLeft == 0) {
                        spaceLeft = screenWidth - totalLength;
                    }
                }
                totalLength = newLength;
            }
            Collections.sort(stringList, (o1, o2) -> o1.originalIndex - o2.originalIndex);
            int[] finalColSizes = new int[colSizes.length];
            int i = 0;
            for (Column s : stringList) {
                finalColSizes[i] = totalLength > screenWidth ? (s.markForTrim ? (s.trimmedLength = (int)Math.floor((double)spaceLeft * ((double)s.length / (double)totalExtra))) : (s.trimmedLength = s.length)) : (s.trimmedLength = s.length);
                ++i;
            }
            totalLength = 0;
            index = 0;
            for (Object colSize : (Object)finalColSizes) {
                if (colSize != colSizes[index] && colSize < 2) {
                    throw new TooManyColumnsException("Computed ColSize=" + (int)colSize + " Set RESULT_VIEWER to external. This uses the 'less' command (with horizontal scrolling) to see wider results");
                }
                totalLength += colSize;
                ++index;
            }
            return finalColSizes;
        }
        return colSizes;
    }

    public static int trimWidthForScreen(int maxColLength) {
        if (TableBuilderHelper.shouldTrimColumns()) {
            int screenWidth = TableBuilderHelper.getScreenWidth();
            if (maxColLength > screenWidth) {
                return screenWidth;
            }
            return maxColLength;
        }
        return maxColLength;
    }

    public static int getScreenWidth() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh == null) {
            return 100;
        }
        return gfsh.getTerminalWidth();
    }

    public static boolean shouldTrimColumns() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh == null) {
            return Boolean.getBoolean("GFSH.TRIMSCRWIDTH");
        }
        return "basic".equals(gfsh.getEnvProperty("APP_RESULT_VIEWER")) && !Gfsh.isInfoResult();
    }

    public static class TooManyColumnsException
    extends RuntimeException {
        public TooManyColumnsException(String str) {
            super(str);
        }
    }

    public static class Column
    implements Comparable<Column> {
        int length;
        int originalIndex;
        boolean markForTrim = false;
        int trimmedLength = 0;

        @Override
        public int compareTo(Column o) {
            return this.length - o.length;
        }

        public String toString() {
            return "OI:" + this.originalIndex + "<" + this.length + ">\n";
        }
    }
}

