/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.result;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileResult
implements Result {
    private String[] filePaths;
    private int fileIndex;
    private Result.Status status = Result.Status.ERROR;
    private byte[][] localFileData = null;
    private boolean failedToPersist = false;

    public FileResult(String[] filePathsToRead) throws FileNotFoundException, IOException {
        this.filePaths = filePathsToRead;
        this.localFileData = CliUtil.filesToBytes(filePathsToRead);
        this.status = Result.Status.OK;
    }

    @Override
    public Result.Status getStatus() {
        return this.status;
    }

    @Override
    public void resetToFirstLine() {
    }

    @Override
    public boolean hasNextLine() {
        return this.fileIndex < this.filePaths.length;
    }

    @Override
    public String nextLine() {
        return this.filePaths[this.fileIndex++];
    }

    public byte[][] toBytes() {
        return this.localFileData;
    }

    public long computeFileSizeTotal() {
        long byteCount = 0L;
        for (int i = 1; i < this.localFileData.length; i += 2) {
            byteCount += (long)this.localFileData[i].length;
        }
        return byteCount;
    }

    public String getFormattedFileList() {
        StringBuffer formattedFileList = new StringBuffer();
        for (int i = 0; i < this.localFileData.length; i += 2) {
            formattedFileList.append(new String(this.localFileData[i]));
            if (i >= this.localFileData.length - 2) continue;
            formattedFileList.append(", ");
        }
        return formattedFileList.toString();
    }

    @Override
    public boolean hasIncomingFiles() {
        return true;
    }

    @Override
    public void saveIncomingFiles(String directory) throws UnsupportedOperationException, IOException {
        CliUtil.bytesToFiles(this.localFileData, directory, true);
    }

    @Override
    public boolean failedToPersist() {
        return this.failedToPersist;
    }

    @Override
    public void setCommandPersisted(boolean commandPersisted) {
        this.failedToPersist = !commandPersisted;
    }
}

