/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.multistep;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.CommandRequest;
import com.gemstone.gemfire.management.internal.cli.GfshParseResult;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import com.gemstone.gemfire.management.internal.cli.multistep.CLIRemoteStep;
import com.gemstone.gemfire.management.internal.cli.multistep.CLIStep;
import com.gemstone.gemfire.management.internal.cli.multistep.CLIStepExecption;
import com.gemstone.gemfire.management.internal.cli.remote.CommandExecutionContext;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.ReflectionUtils;

public class CLIMultiStepHelper {
    public static final String STEP_SECTION = "STEP_SECTION";
    public static final String PAGE_SECTION = "PAGE_SECTION";
    public static final String ARG_SECTION = "ARG_SECTION";
    public static final String NEXT_STEP_NAME = "NEXT_STEP_NAME";
    public static final String NEXT_STEP_ARGS = "NEXT_STEP_ARGS";
    public static final String NEXT_STEP_NAMES = "NEXT_STEP_NAMES";
    public static final String STEP_ARGS = "stepArgs";
    public static final int DEFAULT_PAGE_SIZE = 20;

    public static Object execCLISteps(LogWrapper logWrapper, Gfsh shell, ParseResult parseResult) {
        CLIStep[] steps = (CLIStep[])ReflectionUtils.invokeMethod((Method)parseResult.getMethod(), (Object)parseResult.getInstance(), (Object[])parseResult.getArguments());
        if (steps != null) {
            boolean endStepReached = false;
            int stepNumber = 0;
            CLIStep nextStep = steps[stepNumber];
            Result lastResult = null;
            CompositeResultData.SectionResultData nextStepArgs = null;
            while (!endStepReached) {
                try {
                    Result result = CLIMultiStepHelper.executeStep(logWrapper, shell, nextStep, parseResult, nextStepArgs);
                    String nextStepString = null;
                    nextStepString = CLIMultiStepHelper.getNextStep(result);
                    nextStepArgs = CLIMultiStepHelper.extractArgumentsForNextStep(result);
                    if (!"END".equals(nextStepString)) {
                        String step = nextStepString;
                        boolean stepFound = false;
                        for (CLIStep s : steps) {
                            if (!step.equals(s.getName())) continue;
                            nextStep = s;
                            stepFound = true;
                        }
                        if (stepFound) continue;
                        return ResultBuilder.buildResult(ResultBuilder.createErrorResultData().addLine("Wrong step name returned by previous step : " + step));
                    }
                    lastResult = result;
                    endStepReached = true;
                }
                catch (CLIStepExecption e) {
                    endStepReached = true;
                    lastResult = e.getResult();
                }
            }
            return lastResult;
        }
        Gfsh.println("Command returned null steps");
        return ResultBuilder.buildResult(ResultBuilder.createErrorResultData().addLine("Multi-step command Return NULL STEP Array"));
    }

    private static Result executeStep(LogWrapper logWrapper, Gfsh shell, CLIStep nextStep, ParseResult parseResult, CompositeResultData.SectionResultData nextStepArgs) {
        try {
            if (nextStep instanceof CLIRemoteStep) {
                if (shell.isConnectedAndReady()) {
                    if (GfshParseResult.class.isInstance(parseResult)) {
                        GfshParseResult gfshParseResult = (GfshParseResult)parseResult;
                        CommandRequest commandRequest = new CommandRequest(gfshParseResult, CLIMultiStepHelper.prepareJSONArgs(shell.getEnv(), nextStepArgs));
                        commandRequest.setCustomInput(CLIMultiStepHelper.changeStepName(gfshParseResult.getUserInput(), nextStep.getName()));
                        commandRequest.getCustomParameters().put("step-name", nextStep.getName());
                        String json = (String)shell.getOperationInvoker().processCommand(commandRequest);
                        return ResultBuilder.fromJson(json);
                    }
                    throw new IllegalArgumentException("Command Configuration/Definition error.");
                }
                try {
                    throw new Exception();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new IllegalStateException("Can't execute a remote command without connection. Use 'connect' first to connect.");
                }
            }
            Map<String, String> args = CommandExecutionContext.getShellEnv();
            if (args == null) {
                args = new HashMap<String, String>();
                CommandExecutionContext.setShellEnv(args);
            }
            if (nextStepArgs != null) {
                GfJsonObject argsJSon = nextStepArgs.getSectionGfJsonObject();
                Gfsh.getCurrentInstance().setEnvProperty(STEP_ARGS, argsJSon.toString());
            }
            return nextStep.exec();
        }
        catch (CLIStepExecption e) {
            logWrapper.severe("CLIStep " + nextStep.getName() + " failed aborting command");
            throw e;
        }
    }

    private static String changeStepName(String userInput, String stepName) {
        int i = userInput.indexOf("--step-name=");
        if (i == -1) {
            return userInput + " --step-name=" + stepName;
        }
        return userInput.substring(0, i) + "--step-name=" + stepName;
    }

    public static Map<String, String> prepareJSONArgs(Map<String, String> env, CompositeResultData.SectionResultData nextStepArgs) {
        if (nextStepArgs != null) {
            GfJsonObject argsJSon = nextStepArgs.getSectionGfJsonObject();
            env.put(STEP_ARGS, argsJSon.toString());
        }
        return env;
    }

    public static CompositeResultData.SectionResultData extractArgumentsForNextStep(Result result) {
        CommandResult cResult = (CommandResult)result;
        if ("composite".equals(cResult.getType())) {
            CompositeResultData rd = (CompositeResultData)cResult.getResultData();
            CompositeResultData.SectionResultData data = rd.retrieveSection(ARG_SECTION);
            return data;
        }
        if ("error".equals(cResult.getType())) {
            throw new CLIStepExecption(cResult);
        }
        throw new StepExecutionException("Step returned result of type other than composite Type " + cResult.getType());
    }

    public static String getNextStep(Result cdata) {
        CommandResult cResult = (CommandResult)cdata;
        if ("composite".equals(cResult.getType())) {
            CompositeResultData rd = (CompositeResultData)cResult.getResultData();
            CompositeResultData.SectionResultData section = rd.retrieveSection(STEP_SECTION);
            String nextStep = (String)section.retrieveObject(NEXT_STEP_NAME);
            return nextStep;
        }
        if ("error".equals(cResult.getType())) {
            throw new CLIStepExecption(cResult);
        }
        throw new RuntimeException("Step returned result of type other than composite Type " + cResult.getType());
    }

    public static CommandResult getDisplayResultFromArgs(GfJsonObject args) {
        CompositeResultData.SectionResultData sectionData = new CompositeResultData.SectionResultData(args);
        CompositeResultData data = ResultBuilder.createCompositeResultData();
        data.addSection(sectionData);
        return (CommandResult)ResultBuilder.buildResult(data);
    }

    public static GfJsonObject getStepArgs() {
        GfJsonObject object;
        Map<String, String> args = null;
        args = CliUtil.isGfshVM ? Gfsh.getCurrentInstance().getEnv() : CommandExecutionContext.getShellEnv();
        if (args == null) {
            return null;
        }
        String stepArg = args.get(STEP_ARGS);
        if (stepArg == null) {
            return null;
        }
        try {
            object = new GfJsonObject(stepArg);
        }
        catch (GfJsonException e) {
            throw new RuntimeException("Error converting arguments section into json object");
        }
        return object;
    }

    public static Result createSimpleStepResult(String nextStep) {
        CompositeResultData result = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = result.addSection(STEP_SECTION);
        section.addData(NEXT_STEP_NAME, nextStep);
        return ResultBuilder.buildResult(result);
    }

    public static Object chooseStep(CLIStep[] steps, String stepName) {
        if ("ALL".equals(stepName)) {
            return steps;
        }
        for (CLIStep s : steps) {
            if (!stepName.equals(s.getName())) continue;
            return s.exec();
        }
        return null;
    }

    public static Result createStepSeqResult(CLIStep[] steps) {
        CompositeResultData result = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = result.addSection(STEP_SECTION);
        section.addData(NEXT_STEP_NAME, steps[0].getName());
        String[] array = new String[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            array[i] = steps[i++].getName();
        }
        section.addData(NEXT_STEP_NAMES, array);
        return ResultBuilder.buildResult(result);
    }

    public static Result createEmptyResult(String step) {
        CompositeResultData result = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = result.addSection(STEP_SECTION);
        section.addData(NEXT_STEP_NAME, step);
        return ResultBuilder.buildResult(result);
    }

    public static Result createPageResult(String[] fields, Object[] values, String step, String[] header, Object[][] table) {
        CompositeResultData result = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = result.addSection(STEP_SECTION);
        section.addData(NEXT_STEP_NAME, step);
        CompositeResultData.SectionResultData page = result.addSection(ARG_SECTION);
        if (fields.length != values.length) {
            throw new RuntimeException("Fields array and its value arraylength dont match");
        }
        for (int i = 0; i < fields.length; ++i) {
            page.addData(fields[i], values[i]);
        }
        CLIMultiStepHelper.createPageTableAndBanner(page, header, table);
        return ResultBuilder.buildResult(result);
    }

    public static Result createPageResult(List<String> fields, List values, String step, String[] header, Object[][] table) {
        CompositeResultData result = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = result.addSection(STEP_SECTION);
        section.addData(NEXT_STEP_NAME, step);
        CompositeResultData.SectionResultData page = result.addSection(ARG_SECTION);
        if (fields.size() != values.size()) {
            throw new RuntimeException("Fields array and its value arraylength dont match");
        }
        for (int i = 0; i < fields.size(); ++i) {
            page.addData(fields.get(i), values.get(i));
        }
        CLIMultiStepHelper.createPageTableAndBanner(page, header, table);
        return ResultBuilder.buildResult(result);
    }

    private static void createPageTableAndBanner(CompositeResultData.SectionResultData page, String[] header, Object[][] table) {
        int i;
        TabularResultData resultData = page.addTable();
        int columns = header.length;
        for (i = 0; i < table.length; ++i) {
            int rowLength = table[i].length;
            if (rowLength == columns) continue;
            throw new RuntimeException("Row contains more than " + columns + " :  " + rowLength);
        }
        for (i = 0; i < table.length; ++i) {
            for (int j = 0; j < columns; ++j) {
                resultData.accumulate(header[j], table[i][j]);
            }
        }
    }

    public static Result createBannerResult(String[] fields, Object[] values, String step) {
        CompositeResultData result = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = result.addSection(STEP_SECTION);
        section.addData(NEXT_STEP_NAME, step);
        CompositeResultData.SectionResultData page = result.addSection(ARG_SECTION);
        if (fields.length != values.length) {
            throw new RuntimeException("Fields array and its value arraylength dont match");
        }
        for (int i = 0; i < fields.length; ++i) {
            page.addData(fields[i], values[i]);
        }
        return ResultBuilder.buildResult(result);
    }

    public static Result createBannerResult(List<String> fields, List values, String step) {
        CompositeResultData result = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = result.addSection(STEP_SECTION);
        section.addData(NEXT_STEP_NAME, step);
        CompositeResultData.SectionResultData page = result.addSection(ARG_SECTION);
        if (fields.size() != values.size()) {
            throw new RuntimeException("Fields array and its value arraylength dont match");
        }
        for (int i = 0; i < fields.size(); ++i) {
            page.addData(fields.get(i), values.get(i));
        }
        return ResultBuilder.buildResult(result);
    }

    public static void logFine(String msg) {
        Gfsh.println(msg);
    }

    public static class StepExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private String message;

        public StepExecutionException(String message) {
            LogWriter logger = CacheFactory.getAnyInstance().getLogger();
            logger.severe(message);
            this.message = message;
        }

        @Override
        public String getMessage() {
            return StepExecutionException.class.getName();
        }

        public String getStepExecutionExceptionMessage() {
            return this.message;
        }
    }

    public static abstract class RemoteStep
    implements CLIRemoteStep {
        private String name = null;
        protected Object[] commandArguments = null;

        public RemoteStep(String name, Object[] arguments) {
            this.name = name;
            this.commandArguments = arguments;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static abstract class LocalStep
    implements CLIStep {
        private String name = null;
        protected Object[] commandArguments = null;

        public LocalStep(String name, Object[] arguments) {
            this.name = name;
            this.commandArguments = arguments;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

