/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.modes;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommandModes {
    public static final String DEFAULT_MODE = "default";
    private static CommandModes _allModes;
    private Map<String, Map<String, CommandMode>> modeMap = new HashMap<String, Map<String, CommandMode>>();

    public Map<String, Map<String, CommandMode>> getModeMap() {
        return this.modeMap;
    }

    private CommandModes() {
        this.readAllModes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandModes getInstance() {
        Class<CommandModes> clazz = CommandModes.class;
        synchronized (CommandModes.class) {
            if (_allModes == null) {
                _allModes = new CommandModes();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _allModes;
        }
    }

    private void readAllModes() {
        try {
            InputStream stream = CommandModes.class.getResourceAsStream("commands.json");
            byte[] bytes = new byte[51200];
            int bytesRead = stream.read(bytes);
            String str = new String(bytes, 0, bytesRead);
            this.parseModes(str);
            stream.close();
        }
        catch (IOException e) {
            this.logException(e);
        }
        catch (JSONException e) {
            this.logException((Exception)((Object)e));
        }
    }

    private void parseModes(String str) throws JSONException {
        JSONObject jsonObject = new JSONObject(str);
        JSONArray array = jsonObject.getJSONArray("commands");
        for (int i = 0; i < array.length(); ++i) {
            try {
                this.addCommandMode(array.getString(i));
                continue;
            }
            catch (JSONException e) {
                this.logException((Exception)((Object)e));
                continue;
            }
            catch (IOException e) {
                this.logException(e);
            }
        }
    }

    private void logException(Exception e) {
        Cache cache = CacheFactory.getAnyInstance();
        LogWriter logger = cache.getLogger();
        logger.warning("Error parsing command mode descriptor", e);
    }

    private void addCommandMode(String commandName) throws JSONException, IOException {
        InputStream stream = CommandModes.class.getResourceAsStream(commandName + ".json");
        byte[] bytes = new byte[51200];
        int bytesRead = stream.read(bytes);
        String str = new String(bytes, 0, bytesRead);
        JSONObject object = new JSONObject(str);
        String name = object.getString("name");
        JSONArray array = object.getJSONArray("modes");
        HashMap<String, CommandMode> map = new HashMap<String, CommandMode>();
        for (int i = 0; i < array.length(); ++i) {
            CommandMode mode = this.readMode(array.getJSONObject(i));
            map.put(mode.name, mode);
        }
        this.modeMap.put(name, map);
    }

    private CommandMode readMode(JSONObject jsonObject) throws JSONException {
        CommandMode mode = new CommandMode();
        mode.name = jsonObject.getString("name");
        mode.text = jsonObject.getString("text");
        mode.leadOption = jsonObject.getString("lead-option");
        mode.options = this.toStringArray(jsonObject.getJSONArray("options"));
        return mode;
    }

    private String[] toStringArray(JSONArray jsonArray) throws JSONException {
        String[] array = new String[jsonArray.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = jsonArray.getString(i);
        }
        return array;
    }

    public Collection<CommandMode> getCommandModes(String name) {
        Map<String, CommandMode> commandModes = this.modeMap.get(name);
        if (commandModes != null) {
            return commandModes.values();
        }
        return null;
    }

    public CommandMode getCommandMode(String commandName, String modeName) {
        Map<String, CommandMode> commandModes = this.modeMap.get(commandName);
        if (commandModes != null) {
            return commandModes.get(modeName);
        }
        return null;
    }

    public String toString() {
        return this.modeMap.toString();
    }

    public static class CommandMode {
        public String name;
        public String leadOption;
        public String[] options;
        public String text;

        public String toString() {
            return "CM: name : " + this.name + " text:" + this.text;
        }
    }
}

