/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.help.utils;

import com.gemstone.gemfire.management.internal.cli.help.format.Block;
import com.gemstone.gemfire.management.internal.cli.help.format.DataNode;
import com.gemstone.gemfire.management.internal.cli.help.format.Help;
import com.gemstone.gemfire.management.internal.cli.help.format.NewHelp;
import com.gemstone.gemfire.management.internal.cli.help.format.Row;
import com.gemstone.gemfire.management.internal.cli.modes.CommandModes;
import com.gemstone.gemfire.management.internal.cli.parser.Argument;
import com.gemstone.gemfire.management.internal.cli.parser.CommandTarget;
import com.gemstone.gemfire.management.internal.cli.parser.Option;
import java.util.ArrayList;
import java.util.Collection;

public class HelpUtils {
    public static final String EXE_PREFIX_FOR_EXTERNAL_HELP = "gfsh ";
    public static final String HELP__COMMAND_AVAILABLE = "Available";
    public static final String HELP__COMMAND_NOTAVAILABLE = "Not Available";
    private static final String NAME_NAME = "NAME";
    private static final String SYNONYMS_NAME = "SYNONYMS";
    private static final String SYNOPSIS_NAME = "SYNOPSIS";
    private static final String SYNTAX_NAME = "SYNTAX";
    private static final String ARGUMENTS_NAME = "ARGUMENTS";
    private static final String OPTIONS_NAME = "PARAMETERS";
    private static final String IS_AVAILABLE_NAME = "IS AVAILABLE";
    private static final String MODES = "MODES";
    private static final String REQUIRED_SUB_NAME = "Required: ";
    private static final String DEFAULTVALUE_SUB_NAME = "Default value: ";
    private static final String SYNONYMS_SUB_NAME = "Synonyms: ";
    private static final String SPECIFIEDDEFAULTVALUE_SUB_NAME = "Default (if the parameter is specified without value): ";
    private static final String UNSPECIFIEDDEFAULTVALUE_VALUE_SUB_NAME = "Default (if the parameter is not specified): ";
    private static final String VALUE_FIELD = "value";
    private static final String TRUE_TOKEN = "true";
    private static final String FALSE_TOKEN = "false";

    private static Help help(Block[] blocks) {
        return new Help().setBlocks(blocks);
    }

    private static Block block(String heading, Row ... rows) {
        return new Block().setHeading(heading).setRows(rows);
    }

    private static Row row(String ... info) {
        return new Row().setInfo(info);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Help getHelp(CommandTarget commandTarget) {
        void var6_25;
        String temp;
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(HelpUtils.block(NAME_NAME, HelpUtils.row(commandTarget.getCommandName())));
        if (commandTarget.getSynonyms() != null) {
            blocks.add(HelpUtils.block(SYNONYMS_NAME, HelpUtils.row(commandTarget.getSynonyms())));
        }
        if (commandTarget.getCommandHelp() != null && !commandTarget.getCommandHelp().equals("")) {
            blocks.add(HelpUtils.block(SYNOPSIS_NAME, HelpUtils.row(commandTarget.getCommandHelp())));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(commandTarget.getCommandName());
        ArrayList<Argument> optionalArguments = new ArrayList<Argument>();
        for (Argument argument : commandTarget.getOptionParser().getArguments()) {
            if (argument.isRequired()) {
                buffer.append(" " + argument.getArgumentName());
                continue;
            }
            optionalArguments.add(argument);
        }
        for (Argument argument : optionalArguments) {
            buffer.append(" [" + argument.getArgumentName() + "]");
        }
        ArrayList<Option> optionalOptions = new ArrayList<Option>();
        for (Option option : commandTarget.getOptionParser().getOptions()) {
            if (option.isRequired()) {
                buffer.append(" --" + option.getLongOption());
                temp = HelpUtils.buildOptionHelpText(option);
                if (option.getSpecifiedDefaultValue() != null && !option.getSpecifiedDefaultValue().equals("")) {
                    buffer.append("(");
                    buffer.append(temp);
                    buffer.append(")?");
                    continue;
                }
                buffer.append(temp);
                continue;
            }
            optionalOptions.add(option);
        }
        for (Option option : optionalOptions) {
            buffer.append(" [--" + option.getLongOption());
            temp = HelpUtils.buildOptionHelpText(option);
            if (option.getSpecifiedDefaultValue() != null && !option.getSpecifiedDefaultValue().equals("")) {
                buffer.append("(");
                buffer.append(temp);
                buffer.append(")?");
            } else {
                buffer.append(temp);
            }
            buffer.append("]");
        }
        blocks.add(HelpUtils.block(SYNTAX_NAME, HelpUtils.row(buffer.toString())));
        if (commandTarget.getOptionParser().getArguments().size() > 0) {
            ArrayList<Row> arrayList = new ArrayList<Row>();
            for (Argument argument : commandTarget.getOptionParser().getArguments()) {
                arrayList.add(HelpUtils.row(argument.getArgumentName() + (argument.getHelp() != null && !argument.getHelp().equals("") ? ":" + argument.getHelp() : "")));
            }
            Row[] rowArray = new Row[arrayList.size()];
            blocks.add(HelpUtils.block(ARGUMENTS_NAME, arrayList.toArray(rowArray)));
        }
        if (commandTarget.getOptionParser().getOptions().size() > 0) {
            ArrayList<Row> arrayList = new ArrayList<Row>();
            for (Option option : commandTarget.getOptionParser().getOptions()) {
                arrayList.add(HelpUtils.row(option.getLongOption() + (option.getHelp() != null && !option.getHelp().equals("") ? ":" + option.getHelp() : "")));
            }
            Row[] rowArray = new Row[arrayList.size()];
            blocks.add(HelpUtils.block(OPTIONS_NAME, arrayList.toArray(rowArray)));
        }
        Block[] blockArray = new Block[blocks.size()];
        boolean bl = false;
        while (var6_25 < blocks.size()) {
            blockArray[var6_25] = (Block)blocks.get((int)var6_25);
            ++var6_25;
        }
        return HelpUtils.help(blockArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NewHelp getNewHelp(CommandTarget commandTarget, boolean withinShell) {
        DataNode root = new DataNode(null, new ArrayList<DataNode>());
        DataNode name = new DataNode(NAME_NAME, new ArrayList<DataNode>());
        name.addChild(new DataNode(commandTarget.getCommandName(), null));
        root.addChild(name);
        if (withinShell) {
            DataNode availability = new DataNode(IS_AVAILABLE_NAME, new ArrayList<DataNode>());
            boolean isAvailable = false;
            try {
                isAvailable = commandTarget.isAvailable();
            }
            catch (Exception e) {
                isAvailable = false;
            }
            availability.addChild(new DataNode(String.valueOf(isAvailable), null));
            root.addChild(availability);
        }
        if (commandTarget.getSynonyms() != null) {
            DataNode synonyms = new DataNode(SYNONYMS_NAME, new ArrayList<DataNode>());
            for (String string : commandTarget.getSynonyms()) {
                synonyms.addChild(new DataNode(string, null));
            }
            root.addChild(synonyms);
        }
        if (commandTarget.getCommandHelp() != null && !commandTarget.getCommandHelp().equals("")) {
            DataNode synopsis = new DataNode(SYNOPSIS_NAME, new ArrayList<DataNode>());
            synopsis.addChild(new DataNode(commandTarget.getCommandHelp(), null));
            root.addChild(synopsis);
        }
        StringBuffer buffer = new StringBuffer();
        if (withinShell) {
            buffer.append(commandTarget.getCommandName());
        } else {
            buffer.append(EXE_PREFIX_FOR_EXTERNAL_HELP).append(commandTarget.getCommandName());
        }
        HelpUtils.appendArguments(buffer, commandTarget);
        HelpUtils.appendOptions(buffer, commandTarget);
        DataNode syntax = new DataNode(SYNTAX_NAME, new ArrayList<DataNode>());
        syntax.addChild(new DataNode(buffer.toString(), null));
        root.addChild(syntax);
        if (commandTarget.getOptionParser().getArguments().size() > 0) {
            DataNode arguments = new DataNode(ARGUMENTS_NAME, new ArrayList<DataNode>());
            for (Argument argument : commandTarget.getOptionParser().getArguments()) {
                DataNode argumentNode = new DataNode(argument.getArgumentName(), new ArrayList<DataNode>());
                argumentNode.addChild(new DataNode(argument.getHelp() != null && !argument.getHelp().equals("") ? argument.getHelp() : "", null));
                argumentNode.addChild(new DataNode(REQUIRED_SUB_NAME + (argument.isRequired() ? TRUE_TOKEN : FALSE_TOKEN), null));
                if (argument.getUnspecifiedDefaultValue() != null) {
                    argumentNode.addChild(new DataNode(DEFAULTVALUE_SUB_NAME + argument.getUnspecifiedDefaultValue(), null));
                }
                arguments.addChild(argumentNode);
            }
            root.addChild(arguments);
        }
        try {
            CommandModes modes = CommandModes.getInstance();
            Collection<CommandModes.CommandMode> comModes = modes.getCommandModes(commandTarget.getCommandName());
            DataNode modesDN = new DataNode(MODES, new ArrayList<DataNode>());
            if (comModes != null) {
                for (CommandModes.CommandMode cmd : comModes) {
                    StringBuffer sb = new StringBuffer();
                    ArrayList<Option> optionalOptions = new ArrayList<Option>();
                    sb.append(commandTarget.getCommandName()).append(" ");
                    if (!cmd.name.equals("default")) {
                        HelpUtils.appendRequiredOption(sb, HelpUtils.getOption(commandTarget, cmd.leadOption));
                    }
                    for (String opt : cmd.options) {
                        if (opt.equals(cmd.leadOption)) continue;
                        Option option = HelpUtils.getOption(commandTarget, opt);
                        if (option.isRequired()) {
                            HelpUtils.appendRequiredOption(sb, option);
                            continue;
                        }
                        optionalOptions.add(option);
                    }
                    for (Option optOpt : optionalOptions) {
                        HelpUtils.appendOption(sb, optOpt);
                    }
                    DataNode modeDN = new DataNode(cmd.text, new ArrayList<DataNode>());
                    modeDN.addChild(new DataNode(sb.toString(), null));
                    modesDN.addChild(modeDN);
                }
                root.addChild(modesDN);
            }
        }
        catch (Exception modes) {}
        if (commandTarget.getOptionParser().getOptions().size() > 0) {
            DataNode options = new DataNode(OPTIONS_NAME, new ArrayList<DataNode>());
            for (Option option : commandTarget.getOptionParser().getOptions()) {
                DataNode optionNode = new DataNode(option.getLongOption(), new ArrayList<DataNode>());
                optionNode.addChild(new DataNode(option.getHelp() != null && !option.getHelp().equals("") ? option.getHelp() : "", null));
                if (option.getSynonyms() != null && option.getSynonyms().size() > 0) {
                    StringBuilder builder = new StringBuilder();
                    for (String string : option.getSynonyms()) {
                        if (builder.length() > 0) {
                            builder.append(",");
                        }
                        builder.append(string);
                    }
                    optionNode.addChild(new DataNode(SYNONYMS_SUB_NAME + builder.toString(), null));
                }
                optionNode.addChild(new DataNode(REQUIRED_SUB_NAME + (option.isRequired() ? TRUE_TOKEN : FALSE_TOKEN), null));
                if (option.getSpecifiedDefaultValue() != null && !option.getSpecifiedDefaultValue().equals("")) {
                    optionNode.addChild(new DataNode(SPECIFIEDDEFAULTVALUE_SUB_NAME + option.getSpecifiedDefaultValue(), null));
                }
                if (option.getUnspecifiedDefaultValue() != null && !option.getUnspecifiedDefaultValue().equals("")) {
                    optionNode.addChild(new DataNode(UNSPECIFIEDDEFAULTVALUE_VALUE_SUB_NAME + option.getUnspecifiedDefaultValue(), null));
                }
                options.addChild(optionNode);
            }
            root.addChild(options);
        }
        return new NewHelp(root);
    }

    private static Option getOption(CommandTarget commandTarget, String opt) {
        for (Option option : commandTarget.getOptionParser().getOptions()) {
            if (!option.getLongOption().equals(opt)) continue;
            return option;
        }
        return null;
    }

    private static void appendOptions(StringBuffer buffer, CommandTarget commandTarget) {
        ArrayList<Option> optionalOptions = new ArrayList<Option>();
        for (Option option : commandTarget.getOptionParser().getOptions()) {
            if (option.isRequired()) {
                HelpUtils.appendRequiredOption(buffer, option);
                continue;
            }
            optionalOptions.add(option);
        }
        for (Option option : optionalOptions) {
            HelpUtils.appendOption(buffer, option);
        }
    }

    private static void appendRequiredOption(StringBuffer buffer, Option option) {
        buffer.append(" --" + option.getLongOption());
        String temp = HelpUtils.buildOptionHelpText(option);
        if (option.getSpecifiedDefaultValue() != null && !option.getSpecifiedDefaultValue().equals("")) {
            buffer.append("(").append(temp).append(")?");
        } else {
            buffer.append(temp);
        }
    }

    private static void appendOption(StringBuffer buffer, Option option) {
        buffer.append(" [--" + option.getLongOption());
        String temp = HelpUtils.buildOptionHelpText(option);
        if (option.getSpecifiedDefaultValue() != null && !option.getSpecifiedDefaultValue().equals("")) {
            buffer.append("(").append(temp).append(")?");
        } else {
            buffer.append(temp);
        }
        buffer.append("]");
    }

    private static void appendArguments(StringBuffer buffer, CommandTarget commandTarget) {
        ArrayList<Argument> optionalArguments = new ArrayList<Argument>();
        for (Argument argument : commandTarget.getOptionParser().getArguments()) {
            if (argument.isRequired()) {
                buffer.append(" " + argument.getArgumentName());
                continue;
            }
            optionalArguments.add(argument);
        }
        for (Argument argument : optionalArguments) {
            buffer.append(" [" + argument.getArgumentName() + "]");
        }
    }

    public static String buildOptionHelpText(Option option) {
        String temp = "=value";
        if (option.getValueSeparator() != null && option.getValueSeparator() != "__NULL__" && !option.getValueSeparator().equals("") || HelpUtils.isCollectionOrArrayType(option.getDataType())) {
            temp = temp + "(" + option.getValueSeparator() + VALUE_FIELD + ")*";
        }
        return temp;
    }

    private static boolean isCollectionOrArrayType(Class<?> typeToCheck) {
        return typeToCheck != null && (typeToCheck.isArray() || Collection.class.isAssignableFrom(typeToCheck));
    }
}

