/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.GfshParser;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;

public class UserFunctionExecution
implements Function,
InternalEntity {
    public static final String ID = UserFunctionExecution.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        block25: {
            try {
                Cache cache = CacheFactory.getAnyInstance();
                DistributedMember member = cache.getDistributedSystem().getDistributedMember();
                String[] functionArgs = null;
                Object[] args = (Object[])context.getArguments();
                if (args != null) {
                    String functionId = (String)args[0];
                    String filterString = (String)args[1];
                    String resultCollectorName = (String)args[2];
                    String argumentsString = (String)args[3];
                    String onRegion = (String)args[4];
                    try {
                        Function function;
                        if (argumentsString != null && argumentsString.length() > 0) {
                            functionArgs = argumentsString.split(",");
                        }
                        HashSet<String> filters = new HashSet<String>();
                        ResultCollector resultCollectorInstance = null;
                        if (resultCollectorName != null && resultCollectorName.length() > 0) {
                            resultCollectorInstance = (ResultCollector)ClassPathLoader.getLatest().forName(resultCollectorName).newInstance();
                        }
                        if (filterString != null && filterString.length() > 0) {
                            filters.add(filterString);
                        }
                        if ((function = FunctionService.getFunction(functionId)) == null) {
                            context.getResultSender().lastResult(CliStrings.format("Function : {0} is not registered on member.", (Object)functionId));
                            break block25;
                        }
                        Execution execution = null;
                        if (onRegion != null && onRegion.length() > 0) {
                            Region region = cache.getRegion(onRegion);
                            if (region != null) {
                                execution = FunctionService.onRegion(region);
                            }
                        } else {
                            execution = FunctionService.onMember(member);
                        }
                        if (execution != null) {
                            if (resultCollectorInstance != null) {
                                execution = execution.withCollector(resultCollectorInstance);
                            }
                            if (functionArgs != null && functionArgs.length > 0) {
                                execution = execution.withArgs(functionArgs);
                            }
                            if (filters != null && filters.size() > 0) {
                                execution = execution.withFilter(filters);
                            }
                            List results = (List)execution.execute(function).getResult();
                            StringBuilder resultMessege = new StringBuilder();
                            if (results != null) {
                                for (Object resultObj : results) {
                                    if (resultObj == null) continue;
                                    if (resultObj instanceof String) {
                                        resultMessege.append((String)resultObj);
                                        resultMessege.append(GfshParser.LINE_SEPARATOR);
                                        continue;
                                    }
                                    if (resultObj instanceof Exception) {
                                        resultMessege.append(((IllegalArgumentException)resultObj).getMessage());
                                        continue;
                                    }
                                    resultMessege.append(resultObj);
                                    resultMessege.append(GfshParser.LINE_SEPARATOR);
                                }
                            }
                            context.getResultSender().lastResult(resultMessege);
                            break block25;
                        }
                        context.getResultSender().lastResult(CliStrings.format("While executing function : {0} on member : {1} one region : {2} error occured : {3}", functionId, member.getId(), onRegion, "Could not retrieve executor"));
                    }
                    catch (ClassNotFoundException e) {
                        context.getResultSender().lastResult(CliStrings.format("ResultCollector : {0} not found. Error : {1}", resultCollectorName, e.getMessage()));
                    }
                    catch (FunctionException e) {
                        context.getResultSender().lastResult(CliStrings.format("While executing function : {0} on member : {1} error occured : {2}", functionId, member.getId(), e.getMessage()));
                    }
                    catch (CancellationException e) {
                        context.getResultSender().lastResult(CliStrings.format("While executing function : {0} on member : {1} error occured : {2}", functionId, member.getId(), e.getMessage()));
                    }
                    catch (InstantiationException e) {
                        context.getResultSender().lastResult(CliStrings.format("ResultCollector : {0} not found. Error : {1}", resultCollectorName, e.getMessage()));
                    }
                    catch (IllegalAccessException e) {
                        context.getResultSender().lastResult(CliStrings.format("ResultCollector : {0} not found. Error : {1}", resultCollectorName, e.getMessage()));
                    }
                    catch (Exception e) {
                        context.getResultSender().lastResult(CliStrings.format("While executing function : {0} on member : {1} error occured : {2}", functionId, member.getId(), e.getMessage()));
                    }
                    break block25;
                }
                context.getResultSender().lastResult("Could not retrieve arguments");
            }
            catch (Exception ex) {
                context.getResultSender().lastResult(ex.getMessage());
            }
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

