/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import org.apache.logging.log4j.Logger;

public class ShutDownFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ShutDownFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        try {
            Cache cache = CacheFactory.getAnyInstance();
            String memberName = cache.getDistributedSystem().getDistributedMember().getId();
            cache.getLogger().info("Received GFSH shutdown. Shutting down member " + memberName);
            InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
            if (system.isConnected()) {
                ConnectionTable.threadWantsSharedResources();
                if (system.isConnected()) {
                    system.disconnect();
                }
            }
            context.getResultSender().lastResult("SUCCESS: succeeded in shutting down " + memberName);
        }
        catch (Exception ex) {
            context.getResultSender().lastResult("FAILURE: failed in shutting down " + ex.getMessage());
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

