/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.internal.CqQueryVsdStats;
import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.cache.query.internal.cq.InternalCqQuery;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.domain.SubscriptionQueueSizeResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;

public class GetSubscriptionQueueSizeFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext context) {
        Cache cache = CliUtil.getCacheIfExists();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        String[] args = (String[])context.getArguments();
        String durableClientId = null;
        String cqName = null;
        SubscriptionQueueSizeResult result = new SubscriptionQueueSizeResult(memberNameOrId);
        durableClientId = args[0];
        cqName = args[1];
        try {
            CacheClientNotifier cacheClientNotifier = CacheClientNotifier.getInstance();
            if (cacheClientNotifier != null) {
                CacheClientProxy cacheClientProxy = cacheClientNotifier.getClientProxy(durableClientId);
                if (cacheClientProxy != null) {
                    if (cqName != null && !cqName.isEmpty()) {
                        CqService cqService = cacheClientProxy.getCache().getCqService();
                        if (cqService != null) {
                            CqQuery cqQuery = cqService.getClientCqFromServer(cacheClientProxy.getProxyID(), cqName);
                            if (cqQuery != null) {
                                CqQueryVsdStats cqVsdStats = ((InternalCqQuery)cqQuery).getVsdStats();
                                if (cqVsdStats != null) {
                                    long queueSize = cqVsdStats.getNumHAQueuedEvents();
                                    result.setSubscriptionQueueSize(queueSize);
                                } else {
                                    result.setErrorMessage(CliStrings.format("No cq stats found on server for durable client id {0} with cq name {1}.", durableClientId, cqName));
                                }
                            } else {
                                result.setErrorMessage(CliStrings.format("No cq found on server for client with durable-client-id : {0} with cq-name : {1}.", durableClientId, cqName));
                            }
                        } else {
                            result.setErrorMessage("No cq's registered on this member");
                        }
                    } else {
                        result.setSubscriptionQueueSize(cacheClientNotifier.getDurableClientHAQueueSize(durableClientId));
                    }
                } else {
                    result.setErrorMessage(CliStrings.format("No client found with client-id : {0}", (Object)durableClientId));
                }
            } else {
                result.setErrorMessage("No client found on this server");
            }
        }
        catch (Exception e) {
            result.setExceptionMessage(e.getMessage());
        }
        finally {
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return GetSubscriptionQueueSizeFunction.class.getName();
    }
}

