/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.configuration.domain.SharedConfigurationStatus;
import java.io.Serializable;

public class FetchSharedConfigurationStatusFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        InternalDistributedMember member = cache.getDistributedSystem().getDistributedMember();
        SharedConfigurationStatus status = locator.getSharedConfigurationStatus().getStatus();
        String memberId = member.getName();
        if (StringUtils.isBlank(memberId)) {
            memberId = member.getId();
        }
        CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])new String[]{status.name()});
        context.getResultSender().lastResult(result);
    }

    @Override
    public String getId() {
        return FetchSharedConfigurationStatusFunction.class.getName();
    }
}

