/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.InternalCache;
import com.gemstone.gemfire.internal.lang.ObjectUtils;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.management.internal.cli.domain.DiskStoreDetails;
import com.gemstone.gemfire.management.internal.cli.util.DiskStoreNotFoundException;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class DescribeDiskStoreFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final Set<DataPolicy> PERSISTENT_DATA_POLICIES = new HashSet<DataPolicy>(2);

    protected static void assertState(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    public void init(Properties props) {
    }

    @Override
    public void execute(FunctionContext context) {
        Cache cache = this.getCache();
        try {
            if (cache instanceof InternalCache) {
                InternalCache gemfireCache = (InternalCache)cache;
                DistributedMember member = gemfireCache.getMyId();
                String diskStoreName = (String)context.getArguments();
                String memberId = member.getId();
                String memberName = member.getName();
                DiskStore diskStore = gemfireCache.findDiskStore(diskStoreName);
                if (diskStore != null) {
                    DiskStoreDetails diskStoreDetails = new DiskStoreDetails(diskStore.getDiskStoreUUID(), diskStore.getName(), memberId, memberName);
                    diskStoreDetails.setAllowForceCompaction(diskStore.getAllowForceCompaction());
                    diskStoreDetails.setAutoCompact(diskStore.getAutoCompact());
                    diskStoreDetails.setCompactionThreshold(diskStore.getCompactionThreshold());
                    diskStoreDetails.setMaxOplogSize(diskStore.getMaxOplogSize());
                    diskStoreDetails.setQueueSize(diskStore.getQueueSize());
                    diskStoreDetails.setTimeInterval(diskStore.getTimeInterval());
                    diskStoreDetails.setWriteBufferSize(diskStore.getWriteBufferSize());
                    diskStoreDetails.setDiskUsageWarningPercentage(Float.valueOf(diskStore.getDiskUsageWarningPercentage()));
                    diskStoreDetails.setDiskUsageCriticalPercentage(Float.valueOf(diskStore.getDiskUsageCriticalPercentage()));
                    this.setDiskDirDetails(diskStore, diskStoreDetails);
                    this.setRegionDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setCacheServerDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setGatewayDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setPdxSerializationDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setAsyncEventQueueDetails(gemfireCache, diskStore, diskStoreDetails);
                    context.getResultSender().lastResult(diskStoreDetails);
                } else {
                    context.getResultSender().sendException(new DiskStoreNotFoundException(String.format("A disk store with name (%1$s) was not found on member (%2$s).", diskStoreName, memberName)));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while executing 'describe disk-store': {}!", new Object[]{e.getMessage(), e});
            context.getResultSender().sendException(e);
        }
    }

    private void setDiskDirDetails(DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        Integer[] diskDirSizes;
        File[] diskDirs = diskStore.getDiskDirs();
        DescribeDiskStoreFunction.assertState(diskDirs.length == (diskDirSizes = ArrayUtils.toIntegerArray(diskStore.getDiskDirSizes())).length, "The number of disk directories with a specified size (%1$d) does not match the number of disk directories (%2$d)!", diskDirSizes.length, diskDirs.length);
        for (int index = 0; index < diskDirs.length; ++index) {
            diskStoreDetails.add(new DiskStoreDetails.DiskDirDetails(diskDirs[index].getAbsolutePath(), ArrayUtils.getElementAtIndex(diskDirSizes, index, 0)));
        }
    }

    protected String getDiskStoreName(Region region) {
        return StringUtils.defaultIfBlank(region.getAttributes().getDiskStoreName(), "DEFAULT");
    }

    protected boolean isOverflowToDisk(Region region) {
        return region.getAttributes().getEvictionAttributes() != null && EvictionAction.OVERFLOW_TO_DISK.equals(region.getAttributes().getEvictionAttributes().getAction());
    }

    protected boolean isPersistent(Region region) {
        return region.getAttributes().getDataPolicy().withPersistence();
    }

    protected boolean isUsingDiskStore(Region region, DiskStore diskStore) {
        return (this.isPersistent(region) || this.isOverflowToDisk(region)) && ObjectUtils.equals(this.getDiskStoreName(region), diskStore.getName());
    }

    protected void setRegionDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (Region<?, ?> region : cache.rootRegions()) {
            this.setRegionDetails(region, diskStore, diskStoreDetails);
        }
    }

    private void setRegionDetails(Region<?, ?> region, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        if (this.isUsingDiskStore(region, diskStore)) {
            String regionFullPath = region.getFullPath();
            DiskStoreDetails.RegionDetails regionDetails = new DiskStoreDetails.RegionDetails(regionFullPath, StringUtils.defaultIfBlank(region.getName(), regionFullPath));
            regionDetails.setOverflowToDisk(this.isOverflowToDisk(region));
            regionDetails.setPersistent(this.isPersistent(region));
            diskStoreDetails.add(regionDetails);
        }
        for (Region<?, ?> subregion : region.subregions(false)) {
            this.setRegionDetails(subregion, diskStore, diskStoreDetails);
        }
    }

    protected String getDiskStoreName(CacheServer cacheServer) {
        return cacheServer.getClientSubscriptionConfig() == null ? null : StringUtils.defaultIfBlank(cacheServer.getClientSubscriptionConfig().getDiskStoreName(), "DEFAULT");
    }

    protected boolean isUsingDiskStore(CacheServer cacheServer, DiskStore diskStore) {
        return ObjectUtils.equals(this.getDiskStoreName(cacheServer), diskStore.getName());
    }

    protected void setCacheServerDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (CacheServer cacheServer : cache.getCacheServers()) {
            if (!this.isUsingDiskStore(cacheServer, diskStore)) continue;
            DiskStoreDetails.CacheServerDetails cacheServerDetails = new DiskStoreDetails.CacheServerDetails(cacheServer.getBindAddress(), cacheServer.getPort());
            cacheServerDetails.setHostName(cacheServer.getHostnameForClients());
            diskStoreDetails.add(cacheServerDetails);
        }
    }

    protected String getDiskStoreName(GatewaySender gateway) {
        return StringUtils.defaultIfBlank(gateway.getDiskStoreName(), "DEFAULT");
    }

    protected boolean isPersistent(GatewaySender gateway) {
        return gateway.isPersistenceEnabled();
    }

    protected boolean isUsingDiskStore(GatewaySender gateway, DiskStore diskStore) {
        return ObjectUtils.equals(this.getDiskStoreName(gateway), diskStore.getName());
    }

    protected void setGatewayDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (GatewaySender gatewaySender : cache.getGatewaySenders()) {
            if (!this.isUsingDiskStore(gatewaySender, diskStore)) continue;
            DiskStoreDetails.GatewayDetails gatewayDetails = new DiskStoreDetails.GatewayDetails(gatewaySender.getId());
            gatewayDetails.setPersistent(this.isPersistent(gatewaySender));
            diskStoreDetails.add(gatewayDetails);
        }
    }

    protected void setPdxSerializationDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        if (cache.getPdxPersistent()) {
            String diskStoreName = StringUtils.defaultIfBlank(cache.getPdxDiskStore(), "DEFAULT");
            diskStoreDetails.setPdxSerializationMetaDataStored(ObjectUtils.equals(diskStoreName, diskStore.getName()));
        }
    }

    protected String getDiskStoreName(AsyncEventQueue queue) {
        return StringUtils.defaultIfBlank(queue.getDiskStoreName(), "DEFAULT");
    }

    protected boolean isUsingDiskStore(AsyncEventQueue queue, DiskStore diskStore) {
        return queue.isPersistent() && ObjectUtils.equals(this.getDiskStoreName(queue), diskStore.getName());
    }

    protected void setAsyncEventQueueDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (AsyncEventQueue queue : cache.getAsyncEventQueues()) {
            if (!this.isUsingDiskStore(queue, diskStore)) continue;
            diskStoreDetails.add(new DiskStoreDetails.AsyncEventQueueDetails(queue.getId()));
        }
    }

    static {
        PERSISTENT_DATA_POLICIES.add(DataPolicy.PERSISTENT_PARTITION);
        PERSISTENT_DATA_POLICIES.add(DataPolicy.PERSISTENT_REPLICATE);
    }
}

