/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.exceptions;

import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandInvalidException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandMultiModeOptionException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandNotAvailableException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandOptionException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandOptionHasMultipleValuesException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandOptionNotApplicableException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandOptionValueException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliException;
import com.gemstone.gemfire.management.internal.cli.util.CLIConsoleBufferUtil;
import java.util.logging.Logger;

public class ExceptionHandler {
    private static Logger LOGGER = Logger.getLogger(ExceptionHandler.class.getCanonicalName());

    public static void handleException(CliException ce) {
        if (ce instanceof CliCommandException) {
            if (ce instanceof CliCommandNotAvailableException) {
                ExceptionHandler.handleCommandNotAvailableException((CliCommandNotAvailableException)ce);
            } else if (ce instanceof CliCommandInvalidException) {
                ExceptionHandler.handleCommandInvalidException((CliCommandInvalidException)ce);
            } else if (ce instanceof CliCommandOptionException) {
                ExceptionHandler.handleOptionException((CliCommandOptionException)ce);
            }
        }
    }

    private static void handleMultiModeOptionException(CliCommandMultiModeOptionException ce) {
        switch (ce.getCode()) {
            case 1: {
                LOGGER.warning(CLIConsoleBufferUtil.processMessegeForExtraCharactersFromConsoleBuffer("Input command contains multiple lead-options from modes : " + ce.getLeadOptionString()));
                break;
            }
            case 2: {
                LOGGER.warning(CLIConsoleBufferUtil.processMessegeForExtraCharactersFromConsoleBuffer("Input command contains options from multilpe modes : " + ce.getLeadOptionString()));
            }
        }
    }

    private static void handleCommandInvalidException(CliCommandInvalidException ccie) {
        LOGGER.warning(CLIConsoleBufferUtil.processMessegeForExtraCharactersFromConsoleBuffer(ccie.getCommandTarget().getGfshMethodTarget().getKey() + " is not a valid Command"));
    }

    private static void handleCommandNotAvailableException(CliCommandNotAvailableException ccnae) {
        LOGGER.warning(CLIConsoleBufferUtil.processMessegeForExtraCharactersFromConsoleBuffer(ccnae.getCommandTarget().getGfshMethodTarget().getKey() + " is not available at the moment"));
    }

    private static void handleOptionException(CliCommandOptionException ccoe) {
        if (ccoe instanceof CliCommandOptionNotApplicableException) {
            ExceptionHandler.handleOptionInvalidExcpetion((CliCommandOptionNotApplicableException)ccoe);
        } else if (ccoe instanceof CliCommandOptionValueException) {
            ExceptionHandler.handleOptionValueException((CliCommandOptionValueException)ccoe);
        } else if (ccoe instanceof CliCommandMultiModeOptionException) {
            ExceptionHandler.handleMultiModeOptionException((CliCommandMultiModeOptionException)ccoe);
        }
    }

    private static void handleOptionInvalidExcpetion(CliCommandOptionNotApplicableException cconae) {
        String messege = "Parameter " + cconae.getOption().getLongOption() + " is not applicable for " + cconae.getCommandTarget().getGfshMethodTarget().getKey();
        LOGGER.warning(CLIConsoleBufferUtil.processMessegeForExtraCharactersFromConsoleBuffer(messege));
    }

    private static void handleOptionValueException(CliCommandOptionValueException ccove) {
        if (ccove instanceof CliCommandOptionHasMultipleValuesException) {
            String messege = "Parameter " + ccove.getOption().getLongOption() + " can only be specified once";
            LOGGER.warning(CLIConsoleBufferUtil.processMessegeForExtraCharactersFromConsoleBuffer(messege));
        }
    }

    public static Logger getExceptionHanlderLogger() {
        return LOGGER;
    }
}

