/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.domain;

import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.lang.ObjectUtils;
import com.gemstone.gemfire.internal.lang.StringUtils;
import java.io.Serializable;

public class IndexDetails
implements Comparable<IndexDetails>,
Serializable {
    private IndexStatisticsDetails indexStatisticsDetails;
    private IndexType indexType;
    private String indexedExpression;
    private String fromClause;
    private String projectionAttributes;
    private String memberName;
    private String regionName;
    private final String indexName;
    private final String memberId;
    private final String regionPath;

    protected static void assertValidArgument(boolean valid, String message, Object ... args) {
        if (!valid) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    protected static <T extends Comparable<T>> int compare(T obj1, T obj2) {
        return obj1 == null && obj2 == null ? 0 : (obj1 == null ? 1 : (obj2 == null ? -1 : obj1.compareTo(obj2)));
    }

    protected static IndexStatisticsDetails createIndexStatisticsDetails(IndexStatistics indexStatistics) {
        IndexStatisticsDetails indexStatisticsDetails = new IndexStatisticsDetails();
        indexStatisticsDetails.setNumberOfKeys(indexStatistics.getNumberOfKeys());
        indexStatisticsDetails.setNumberOfUpdates(indexStatistics.getNumUpdates());
        indexStatisticsDetails.setNumberOfValues(indexStatistics.getNumberOfValues());
        indexStatisticsDetails.setTotalUpdateTime(indexStatistics.getTotalUpdateTime());
        indexStatisticsDetails.setTotalUses(indexStatistics.getTotalUses());
        return indexStatisticsDetails;
    }

    public IndexDetails(DistributedMember member, Index index) {
        this(member.getId(), index.getRegion().getFullPath(), index.getName());
        this.setFromClause(index.getFromClause());
        this.setIndexedExpression(index.getIndexedExpression());
        this.setIndexType(index.getType());
        this.setMemberName(member.getName());
        this.setProjectionAttributes(index.getProjectionAttributes());
        this.setRegionName(index.getRegion().getName());
        if (index.getStatistics() != null) {
            this.setIndexStatisticsDetails(IndexDetails.createIndexStatisticsDetails(index.getStatistics()));
        }
    }

    public IndexDetails(String memberId, String regionPath, String indexName) {
        IndexDetails.assertValidArgument(!StringUtils.isBlank(memberId), "The member having a region with an index must be specified!", new Object[0]);
        IndexDetails.assertValidArgument(!StringUtils.isBlank(regionPath), "The region in member (%1$s) with an index must be specified!", memberId);
        IndexDetails.assertValidArgument(!StringUtils.isBlank(indexName), "The name of the index on region (%1$s) of member (%2$s) must be specified!", regionPath, memberId);
        this.memberId = memberId;
        this.regionPath = regionPath;
        this.indexName = indexName;
    }

    public String getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public String getIndexedExpression() {
        return this.indexedExpression;
    }

    public void setIndexedExpression(String indexedExpression) {
        this.indexedExpression = indexedExpression;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexStatisticsDetails getIndexStatisticsDetails() {
        return this.indexStatisticsDetails;
    }

    public void setIndexStatisticsDetails(IndexStatisticsDetails indexStatisticsDetails) {
        this.indexStatisticsDetails = indexStatisticsDetails;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public void setIndexType(com.gemstone.gemfire.cache.query.IndexType indexType) {
        this.setIndexType(IndexType.valueOf(indexType));
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getProjectionAttributes() {
        return this.projectionAttributes;
    }

    public void setProjectionAttributes(String projectionAttributes) {
        this.projectionAttributes = projectionAttributes;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public int compareTo(IndexDetails indexDetails) {
        int comparisonValue = IndexDetails.compare(this.getMemberName(), indexDetails.getMemberName());
        comparisonValue = comparisonValue != 0 ? comparisonValue : IndexDetails.compare(this.getMemberId(), indexDetails.getMemberId());
        comparisonValue = comparisonValue != 0 ? comparisonValue : IndexDetails.compare(this.getRegionPath(), indexDetails.getRegionPath());
        return comparisonValue != 0 ? comparisonValue : IndexDetails.compare(this.getIndexName(), indexDetails.getIndexName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexDetails)) {
            return false;
        }
        IndexDetails that = (IndexDetails)obj;
        return ObjectUtils.equals(this.getMemberId(), that.getMemberId()) && ObjectUtils.equals(this.getRegionPath(), that.getRegionPath()) && ObjectUtils.equals(this.getIndexName(), that.getIndexName());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getMemberId());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getRegionPath());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getIndexName());
        return hashValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(" {fromClause = ").append(this.getFromClause());
        buffer.append(", indexExpression = ").append(this.getIndexedExpression());
        buffer.append(", indexName = ").append(this.getIndexName());
        buffer.append(", indexType = ").append((Object)this.getIndexType());
        buffer.append(", memberId = ").append(this.getMemberId());
        buffer.append(", memberName = ").append(this.getMemberName());
        buffer.append(", regionName = ").append(this.getRegionName());
        buffer.append(", regionPath = ").append(this.getRegionPath());
        buffer.append(", projectAttributes = ").append(this.getProjectionAttributes());
        buffer.append("}");
        return buffer.toString();
    }

    public static enum IndexType {
        FUNCTIONAL("RANGE"),
        HASH("HASH"),
        PRIMARY_KEY("KEY");

        private final String description;

        public static IndexType valueOf(com.gemstone.gemfire.cache.query.IndexType indexType) {
            for (IndexType type : IndexType.values()) {
                if (!type.name().equalsIgnoreCase(ObjectUtils.toString(indexType))) continue;
                return type;
            }
            return null;
        }

        private IndexType(String description) {
            IndexDetails.assertValidArgument(!StringUtils.isBlank(description), "The description for the IndexType must be specified!", new Object[0]);
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public com.gemstone.gemfire.cache.query.IndexType getType() {
            switch (this) {
                case HASH: {
                    return null;
                }
                case PRIMARY_KEY: {
                    return com.gemstone.gemfire.cache.query.IndexType.PRIMARY_KEY;
                }
            }
            return com.gemstone.gemfire.cache.query.IndexType.FUNCTIONAL;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static class IndexStatisticsDetails
    implements Serializable {
        private Long numberOfKeys;
        private Long numberOfUpdates;
        private Long numberOfValues;
        private Long totalUpdateTime;
        private Long totalUses;

        public Long getNumberOfKeys() {
            return this.numberOfKeys;
        }

        public void setNumberOfKeys(Long numberOfKeys) {
            this.numberOfKeys = numberOfKeys;
        }

        public Long getNumberOfUpdates() {
            return this.numberOfUpdates;
        }

        public void setNumberOfUpdates(Long numberOfUpdates) {
            this.numberOfUpdates = numberOfUpdates;
        }

        public Long getNumberOfValues() {
            return this.numberOfValues;
        }

        public void setNumberOfValues(Long numberOfValues) {
            this.numberOfValues = numberOfValues;
        }

        public Long getTotalUpdateTime() {
            return this.totalUpdateTime;
        }

        public void setTotalUpdateTime(Long totalUpdateTime) {
            this.totalUpdateTime = totalUpdateTime;
        }

        public Long getTotalUses() {
            return this.totalUses;
        }

        public void setTotalUses(Long totalUses) {
            this.totalUses = totalUses;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append(" {numberOfKeys = ").append(this.getNumberOfKeys());
            buffer.append(", numberOfUpdates = ").append(this.getNumberOfUpdates());
            buffer.append(", numberOfValues = ").append(this.getNumberOfValues());
            buffer.append(", totalUpdateTime = ").append(this.getTotalUpdateTime());
            buffer.append(", totalUses").append(this.getTotalUses());
            buffer.append("}");
            return buffer.toString();
        }
    }
}

