/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import com.gemstone.gemfire.management.internal.cli.MultipleValueAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.MethodTarget;

public class StringListConverter
extends MultipleValueAdapter<List<String>> {
    public boolean supports(Class<?> type, String optionContext) {
        return List.class.isAssignableFrom(type) && "converter.hint.list.string".equals(optionContext);
    }

    @Override
    public List<String> convertFromText(String[] value, Class<?> targetType, String context) {
        ArrayList<String> list = null;
        if (List.class.isAssignableFrom(targetType) && "converter.hint.list.string".equals(context) && value != null && value.length > 0) {
            list = new ArrayList<String>(Arrays.asList(value));
        }
        return list;
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String[] existingData, String context, MethodTarget target) {
        return List.class.isAssignableFrom(targetType) && "converter.hint.list.string".equals(context);
    }
}

