/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.commands.AbstractCommandsSupport;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.functions.FetchSharedConfigurationStatusFunction;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.configuration.domain.SharedConfigurationStatus;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;

public class StatusCommands
extends AbstractCommandsSupport
implements CommandMarker {
    static final FetchSharedConfigurationStatusFunction fetchSharedConfigStatusFunction = new FetchSharedConfigurationStatusFunction();

    @CliCommand(value={"status cluster-config-service"}, help="Displays the status of cluster configuration service on all the locators with enable-cluster-configuration set to true.")
    @CliMetaData(relatedTopic={"Locator"})
    public Result statusSharedConfiguration() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        HashSet<DistributedMember> locators = new HashSet<DistributedMember>(cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet());
        if (locators.isEmpty()) {
            return ResultBuilder.createInfoResult("No locators found with \"enable-cluster-configuration=true\".");
        }
        return ResultBuilder.buildResult(this.getSharedConfigurationStatus(locators));
    }

    private TabularResultData getSharedConfigurationStatus(Set<DistributedMember> locators) {
        boolean isSharedConfigRunning = false;
        ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)fetchSharedConfigStatusFunction, null, locators);
        List results = (List)rc.getResult();
        TabularResultData table = ResultBuilder.createTabularResultData();
        table.setHeader("Status of shared configuration on locators");
        for (CliFunctionResult result : results) {
            table.accumulate("Name", result.getMemberIdOrName());
            String status = (String)((Object)result.getSerializables()[0]);
            table.accumulate("Status", status);
            if (!SharedConfigurationStatus.RUNNING.name().equals(status)) continue;
            isSharedConfigRunning = true;
        }
        if (!isSharedConfigRunning) {
            table.setStatus(Result.Status.ERROR);
        }
        return table;
    }

    @CliAvailabilityIndicator(value={"status cluster-config-service"})
    public final boolean isConnected() {
        if (!CliUtil.isGfshVM()) {
            return true;
        }
        return this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }
}

