/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.AbstractCliAroundInterceptor;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.GfshParseResult;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.functions.ListFunctionFunction;
import com.gemstone.gemfire.management.internal.cli.functions.UnregisterFunction;
import com.gemstone.gemfire.management.internal.cli.functions.UserFunctionExecution;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResultException;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.ErrorResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class FunctionCommands
implements CommandMarker {
    private final ListFunctionFunction listFunctionFunction = new ListFunctionFunction();

    private Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"execute function"}, help="Execute the function with the specified ID. By default will execute on all members.")
    @CliMetaData(relatedTopic={"Function Execution"})
    public Result executeFunction(@CliOption(key={"id"}, mandatory=true, help="ID of the function to execute.") String functionId, @CliOption(key={"groups"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.member.groups", help="Groups of members on which the function will be executed.") String[] onGroups, @CliOption(key={"member"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.member.idOrName", help="Name/Id of the member on which the function will be executed.") String onMember, @CliOption(key={"region"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.region.path", help="Region on which the data dependent function will be executed.") String onRegion, @CliOption(key={"arguments"}, unspecifiedDefaultValue="__NULL__", help="Arguments to the function in comma separated String format.") String[] arguments, @CliOption(key={"result-collector"}, unspecifiedDefaultValue="__NULL__", help="Fully qualified class name of the ResultCollector to instantiate for gathering results.") String resultCollector, @CliOption(key={"filter"}, unspecifiedDefaultValue="__NULL__", help="Key list which causes the function to only be executed on members which have entries with these keys.") String filterString) {
        Result result = null;
        CompositeResultData executeFunctionResultTable = ResultBuilder.createCompositeResultData();
        TabularResultData resultTable = executeFunctionResultTable.addSection().addTable("Table1");
        String headerText = "Execution summary";
        resultTable.setHeader(headerText);
        ResultCollector resultCollectorInstance = null;
        HashSet<String> filters = new HashSet<String>();
        Execution execution = null;
        if (functionId != null) {
            functionId = functionId.trim();
        }
        if (onRegion != null) {
            onRegion = onRegion.trim();
        }
        if (onMember != null) {
            onMember = onMember.trim();
        }
        if (filterString != null) {
            filterString = filterString.trim();
        }
        try {
            if (functionId == null || functionId.length() == 0) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Provide FunctionId");
                result = ResultBuilder.buildResult(errorResultData);
                return result;
            }
            if (onRegion != null && onMember != null && onGroups != null) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Provide Only one of region/member/groups");
                result = ResultBuilder.buildResult(errorResultData);
                return result;
            }
            if (onRegion != null && onMember != null) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Provide Only one of region/member/groups");
                result = ResultBuilder.buildResult(errorResultData);
                return result;
            }
            if (onMember != null && onGroups != null) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Provide Only one of region/member/groups");
                result = ResultBuilder.buildResult(errorResultData);
                return result;
            }
            if (onRegion != null && onGroups != null) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Provide Only one of region/member/groups");
                result = ResultBuilder.buildResult(errorResultData);
                return result;
            }
            if (onRegion != null && onMember != null && onGroups != null) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Provide Only one of region/member/groups");
                result = ResultBuilder.buildResult(errorResultData);
                return result;
            }
            if ((onRegion == null || onRegion.length() == 0) && filterString != null) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Filters for executing on \"member\"/\"mebers of group\" is not supported.");
                result = ResultBuilder.buildResult(errorResultData);
                return result;
            }
            Cache cache = CacheFactory.getAnyInstance();
            if (resultCollector != null) {
                resultCollectorInstance = (ResultCollector)ClassPathLoader.getLatest().forName(resultCollector).newInstance();
            }
            if (filterString != null && filterString.length() > 0) {
                filters.add(filterString);
            }
            if (onRegion == null && onMember == null && onGroups == null) {
                Set<DistributedMember> dsMembers = CliUtil.getAllNormalMembers(cache);
                if (dsMembers.size() > 0) {
                    UserFunctionExecution function = new UserFunctionExecution();
                    LogWrapper.getInstance().info(CliStrings.format("Executing function : {0} on entire distributed system ", (Object)functionId));
                    for (DistributedMember member : dsMembers) {
                        this.executeAndGetResults(functionId, filterString, resultCollector, arguments, cache, member, resultTable, onRegion);
                    }
                    return ResultBuilder.buildResult(resultTable);
                }
                return ResultBuilder.createUserErrorResult("Distributed system has no members");
            }
            if (onRegion != null && onRegion.length() > 0) {
                if (cache.getRegion(onRegion) == null) {
                    DistributedRegionMXBean bean = ManagementService.getManagementService(GemFireCacheImpl.getInstance()).getDistributedRegionMXBean(onRegion);
                    if (bean == null && (bean = ManagementService.getManagementService(GemFireCacheImpl.getInstance()).getDistributedRegionMXBean("/" + onRegion)) == null) {
                        return ResultBuilder.createGemFireErrorResult(CliStrings.format("MXBean for : {0} not found. ", (Object)onRegion));
                    }
                    DistributedMember member = null;
                    String[] membersName = bean.getMembers();
                    Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
                    Iterator<DistributedMember> it = dsMembers.iterator();
                    boolean matchFound = false;
                    if (membersName.length > 0) {
                        block9: while (it.hasNext() && !matchFound) {
                            DistributedMember dsmember = it.next();
                            for (String memberName : membersName) {
                                if (!MBeanJMXAdapter.getMemberNameOrId(dsmember).equals(memberName)) continue;
                                member = dsmember;
                                matchFound = true;
                                continue block9;
                            }
                        }
                    }
                    if (matchFound) {
                        this.executeAndGetResults(functionId, filterString, resultCollector, arguments, cache, member, resultTable, onRegion);
                        return ResultBuilder.buildResult(resultTable);
                    }
                    return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not find a member associated with region ", (Object)(" " + onRegion)));
                }
                execution = FunctionService.onRegion(cache.getRegion(onRegion));
                if (execution != null) {
                    if (resultCollectorInstance != null) {
                        execution = execution.withCollector(resultCollectorInstance);
                    }
                    if (filters != null && filters.size() > 0) {
                        execution = execution.withFilter(filters);
                    }
                    if (arguments != null && arguments.length > 0) {
                        execution = execution.withArgs(arguments);
                    }
                    try {
                        List results = (List)execution.execute(functionId).getResult();
                        if (results.size() > 0) {
                            StringBuilder strResult = new StringBuilder();
                            for (Object obj : results) {
                                strResult.append(obj);
                            }
                            this.toTabularResultData(resultTable, cache.getDistributedSystem().getDistributedMember().getId(), strResult.toString());
                        }
                        return ResultBuilder.buildResult(resultTable);
                    }
                    catch (FunctionException e) {
                        return ResultBuilder.createGemFireErrorResult(CliStrings.format("While executing function : {0} on region : {1} error occured : {2}", functionId, onRegion, e.getMessage()));
                    }
                }
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("While executing function : {0} on region : {1} error occured : {2}", functionId, onRegion, "Could not retrieve executor"));
            }
            if (onGroups != null) {
                HashSet<DistributedMember> dsMembers = new HashSet<DistributedMember>();
                for (String grp : onGroups) {
                    dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(grp));
                }
                StringBuilder successMessage = new StringBuilder();
                if (dsMembers.size() > 0) {
                    for (DistributedMember member : dsMembers) {
                        this.executeAndGetResults(functionId, filterString, resultCollector, arguments, cache, member, resultTable, onRegion);
                    }
                    return ResultBuilder.buildResult(resultTable);
                }
                StringBuilder grps = new StringBuilder();
                for (String grp : onGroups) {
                    grps.append(grp);
                    grps.append(", ");
                }
                return ResultBuilder.createUserErrorResult(CliStrings.format("Groups : {0} has no members", (Object)grps.toString().substring(0, grps.toString().length() - 1)));
            }
            if (onMember != null && onMember.length() > 0) {
                DistributedMember member = CliUtil.getDistributedMemberByNameOrId(onMember);
                if (member != null) {
                    this.executeAndGetResults(functionId, filterString, resultCollector, arguments, cache, member, resultTable, onRegion);
                } else {
                    this.toTabularResultData(resultTable, onMember, CliStrings.format("Could not find a member matching " + onMember, new Object[0]));
                }
                return ResultBuilder.buildResult(resultTable);
            }
        }
        catch (InstantiationException e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
            return result;
        }
        catch (IllegalAccessException e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
            return result;
        }
        catch (IllegalArgumentException e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
            return result;
        }
        catch (SecurityException e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
            return result;
        }
        catch (Exception e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
            return result;
        }
        return result;
    }

    DistributedMember getMember(Cache cache, String memberNameOrId) {
        DistributedMember member = null;
        Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
        for (DistributedMember tempMember : dsMembers) {
            if (!memberNameOrId.equals(tempMember.getId()) && !memberNameOrId.equals(tempMember.getName())) continue;
            return tempMember;
        }
        return member;
    }

    void executeAndGetResults(String functionId, String filterString, String resultCollector, String[] arguments, Cache cache, DistributedMember member, TabularResultData resultTable, String onRegion) {
        StringBuilder resultMessege = new StringBuilder();
        try {
            UserFunctionExecution function = new UserFunctionExecution();
            Object[] args = new Object[5];
            args[0] = functionId;
            if (filterString != null) {
                args[1] = filterString;
            }
            if (resultCollector != null) {
                args[2] = resultCollector;
            }
            if (arguments != null && arguments.length > 0) {
                args[3] = new String();
                for (String str : arguments) {
                    if (str == null) continue;
                    args[3] = args[3] + str + ",";
                }
            }
            args[4] = onRegion;
            Execution execution = FunctionService.onMember(member).withArgs(args);
            if (execution != null) {
                List results = (List)execution.execute(function).getResult();
                if (results != null) {
                    for (Object resultObj : results) {
                        if (resultObj == null) continue;
                        if (resultObj instanceof String) {
                            resultMessege.append((String)resultObj);
                            continue;
                        }
                        if (resultObj instanceof Exception) {
                            resultMessege.append(((Exception)resultObj).getMessage());
                            continue;
                        }
                        resultMessege.append(resultObj);
                    }
                }
                this.toTabularResultData(resultTable, member.getId(), resultMessege.toString());
            } else {
                this.toTabularResultData(resultTable, member.getId(), "Could not retrieve executor");
            }
        }
        catch (FunctionException e) {
            resultMessege.append(CliStrings.format("Could not execute function :{0} on member : {1}. Details are : {2}", functionId, member.getId(), e.getMessage()));
            this.toTabularResultData(resultTable, member.getId(), resultMessege.toString());
        }
        catch (Exception e) {
            resultMessege.append(CliStrings.format("Could not execute function :{0} on member : {1}. Details are : {2}", functionId, member.getId(), e.getMessage()));
            this.toTabularResultData(resultTable, member.getId(), resultMessege.toString());
        }
    }

    protected void toTabularResultData(TabularResultData table, String memberId, String memberResult) {
        String newLine = System.getProperty("line.separator");
        table.accumulate("Member ID/Name", memberId);
        table.accumulate("Function Execution Result", memberResult);
    }

    @CliCommand(value={"destroy function"}, help="Destroy/Unregister a function. The default is for the function to be unregistered from all members.")
    @CliMetaData(relatedTopic={"Function Execution"}, interceptor="com.gemstone.gemfire.management.internal.cli.commands.FunctionCommands$Interceptor")
    public Result destroyFunction(@CliOption(key={"id"}, mandatory=true, help="Destroy/Unregister a function. The default is for the function to be unregistered from all members.") String functionId, @CliOption(key={"groups"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.member.groups", help="Groups of members from which this function will be unregistered.") String[] groups, @CliOption(key={"member"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.member.idOrName", help="Name/Id of the member from which this function will be unregistered.") String memberId) {
        Result result = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            HashSet<DistributedMember> dsMembers = new HashSet<DistributedMember>();
            if (groups != null && memberId != null) {
                return ResultBuilder.createUserErrorResult("Provide either --groups or --member");
            }
            if (groups != null && groups.length > 0) {
                for (String grp : groups) {
                    dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(grp));
                }
                Result results = this.executeFunction(cache, dsMembers, functionId);
                return results;
            }
            if (memberId != null) {
                dsMembers.add(this.getMember(cache, memberId));
                Result results = this.executeFunction(cache, dsMembers, functionId);
                return results;
            }
            Result results = this.executeFunction(cache, cache.getMembers(), functionId);
            return results;
        }
        catch (Exception e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
            return result;
        }
    }

    Result executeFunction(Cache cache, Set<DistributedMember> DsMembers, String functionId) {
        UnregisterFunction unregisterFunction = new UnregisterFunction();
        FunctionService.registerFunction(unregisterFunction);
        ArrayList resultList = null;
        if (DsMembers.isEmpty()) {
            return ResultBuilder.createInfoResult("No members for execution");
        }
        Object[] obj = new Object[]{functionId};
        Execution execution = FunctionService.onMembers(DsMembers).withArgs(obj);
        if (execution == null) {
            cache.getLogger().error("executeUnregister execution is null");
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Cannot execute");
            return ResultBuilder.buildResult(errorResultData);
        }
        try {
            resultList = (ArrayList)execution.execute(unregisterFunction).getResult();
        }
        catch (FunctionException ex) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(ex.getMessage());
            return ResultBuilder.buildResult(errorResultData);
        }
        String resultStr = (String)resultList.get(0);
        if (resultStr.equals("Succeeded in unregistering")) {
            StringBuilder members = new StringBuilder();
            for (DistributedMember member : DsMembers) {
                members.append(member.getId());
                members.append(",");
            }
            return ResultBuilder.createInfoResult("Destroyed " + functionId + " Successfully on " + members.toString().substring(0, members.toString().length() - 1));
        }
        return ResultBuilder.createInfoResult("Failed in unregistering");
    }

    @CliCommand(value={"list functions"}, help="Display a list of registered functions. The default is to display functions for all members.")
    @CliMetaData(relatedTopic={"Function Execution"})
    public Result listFunction(@CliOption(key={"matches"}, help="Pattern that the function ID must match in order to be included. Uses Java pattern matching rules, not UNIX. For example, to match any character any number of times use \".*\" instead of \"*\".") String matches, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group(s) of members for which functions will be displayed.") @CliMetaData(valueSeparator=",") String groups, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the member(s) for which functions will be displayed.") @CliMetaData(valueSeparator=",") String members) {
        Set<DistributedMember> targetMembers;
        TabularResultData tabularData = ResultBuilder.createTabularResultData();
        boolean accumulatedData = false;
        Cache cache = CacheFactory.getAnyInstance();
        try {
            targetMembers = CliUtil.findAllMatchingMembers(groups, members);
        }
        catch (CommandResultException crex) {
            return crex.getResult();
        }
        try {
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.listFunctionFunction, (Object)new Object[]{matches}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Function", "<ERROR: " + result.getThrowable().getMessage() + ">");
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                if (!result.isSuccessful()) continue;
                Object[] strings = (String[])result.getSerializables();
                Arrays.sort(strings);
                for (int i = 0; i < strings.length; ++i) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Function", strings[i]);
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No Functions Found");
            }
            return ResultBuilder.buildResult(tabularData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult("Exception while attempting to list functions: " + th.getMessage());
        }
    }

    @CliAvailabilityIndicator(value={"execute function", "destroy function", "list functions"})
    public boolean functionCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            Set<Map.Entry<String, String>> setEnvMap = paramValueMap.entrySet();
            String onGroup = paramValueMap.get("groups");
            String onMember = paramValueMap.get("member");
            if (onGroup == null && onMember == null) {
                AbstractCliAroundInterceptor.Response response = this.readYesNo("Do you really want to destroy " + paramValueMap.get("id") + " on entire DS?", AbstractCliAroundInterceptor.Response.NO);
                if (response == AbstractCliAroundInterceptor.Response.NO) {
                    return ResultBuilder.createShellClientAbortOperationResult("Aborted destroy of " + paramValueMap.get("id"));
                }
                return ResultBuilder.createInfoResult("Destroying " + paramValueMap.get("id"));
            }
            return ResultBuilder.createInfoResult("Destroying " + paramValueMap.get("id"));
        }

        @Override
        public Result postExecution(GfshParseResult parseResult, Result commandResult) {
            return commandResult;
        }
    }
}

