/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.domain.DataCommandRequest;
import com.gemstone.gemfire.management.internal.cli.domain.DataCommandResult;
import com.gemstone.gemfire.management.internal.cli.functions.DataCommandFunction;
import com.gemstone.gemfire.management.internal.cli.functions.ExportDataFunction;
import com.gemstone.gemfire.management.internal.cli.functions.ImportDataFunction;
import com.gemstone.gemfire.management.internal.cli.functions.RebalanceFunction;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.multistep.CLIMultiStepHelper;
import com.gemstone.gemfire.management.internal.cli.multistep.CLIStep;
import com.gemstone.gemfire.management.internal.cli.multistep.MultiStepCommand;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.ErrorResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.security.Resource;
import com.gemstone.gemfire.management.internal.security.ResourceOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DataCommands
implements CommandMarker {
    final int resultItemCount = 9;
    private final ExportDataFunction exportDataFunction = new ExportDataFunction();
    private final ImportDataFunction importDataFunction = new ImportDataFunction();

    private Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"rebalance"}, help="Rebalance partitioned regions. The default is for all partitioned regions to be rebalanced.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="REBALANCE")
    public Result rebalance(@CliOption(key={"include-region"}, unspecifiedDefaultValue="__NULL__", help="Partitioned regions to be included when rebalancing. Includes take precedence over excludes.") String[] includeRegions, @CliOption(key={"exclude-region"}, unspecifiedDefaultValue="__NULL__", help="Partitioned regions to be excluded when rebalancing.") String[] excludeRegions, @CliOption(key={"time-out"}, unspecifiedDefaultValue="-1", help="Time to wait (in seconds) before GFSH returns to a prompt while rebalancing continues in the background. The default is to wait for rebalancing to complete.") long timeout, @CliOption(key={"simulate"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to only simulate rebalancing. The --time-out parameter is not available when simulating.") boolean simulate) {
        ExecutorService commandExecutors = Executors.newSingleThreadExecutor();
        ArrayList<Future<Result>> commandResult = new ArrayList<Future<Result>>();
        Result result = null;
        try {
            commandResult.add(commandExecutors.submit(new ExecuteRebalanceWithTimeout(includeRegions, excludeRegions, simulate)));
            Future fs = (Future)commandResult.get(0);
            result = timeout > 0L ? (Result)fs.get(timeout, TimeUnit.SECONDS) : (Result)fs.get();
        }
        catch (TimeoutException timeoutException) {
            result = ResultBuilder.createInfoResult("Rebalance will continue in background");
        }
        catch (Exception ex) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Exception occured while rebelancing. Reason : {0}", (Object)ex.getMessage()));
        }
        LogWrapper.getInstance().info("Rebalance returning result >>>" + result);
        return result;
    }

    List<String> tokenize(String str, String separator) {
        StringTokenizer st = new StringTokenizer(str, separator);
        ArrayList<String> rstList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            rstList.add(st.nextToken());
        }
        return rstList;
    }

    boolean checkResultList(CompositeResultData rebalanceResulteData, List resultList, DistributedMember member) {
        boolean toContinueForOtherMembers = false;
        if (resultList != null && !resultList.isEmpty()) {
            for (int i = 0; i < resultList.size(); ++i) {
                Object object = resultList.get(i);
                if (object instanceof Exception) {
                    rebalanceResulteData.addSection().addData(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()), ((Exception)object).getMessage());
                    LogWrapper.getInstance().info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                } else {
                    if (!(object instanceof Throwable)) continue;
                    rebalanceResulteData.addSection().addData(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()), ((Throwable)object).getMessage());
                    LogWrapper.getInstance().info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                }
                break;
            }
        } else {
            LogWrapper.getInstance().info("Rebalancing for member=" + member.getId() + ", resultList is either null or empty");
            rebalanceResulteData.addSection().addData("Rebalancing for member=" + member.getId(), ", resultList is either null or empty");
            toContinueForOtherMembers = true;
        }
        return toContinueForOtherMembers;
    }

    Result executeRebalanceOnDS(Cache cache, String simulate, String[] excludeRegionsList) {
        List<MemberPRInfo> listMemberRegion;
        Result result = null;
        int index = 1;
        CompositeResultData rebalanceResulteData = ResultBuilder.createCompositeResultData();
        ArrayList<String> listExcludedRegion = new ArrayList<String>();
        if (excludeRegionsList != null) {
            for (String str : excludeRegionsList) {
                listExcludedRegion.add(str);
            }
        }
        if ((listMemberRegion = this.getMemberRegionList(cache, listExcludedRegion)).size() == 0) {
            return ResultBuilder.createInfoResult("Distributed system has no regions that can be rebalanced");
        }
        Iterator<MemberPRInfo> iterator = listMemberRegion.iterator();
        boolean flagToContinueWithRebalance = false;
        while (iterator.hasNext()) {
            if (iterator.next().dsMemberList.size() <= 1) continue;
            flagToContinueWithRebalance = true;
            break;
        }
        if (!flagToContinueWithRebalance) {
            return ResultBuilder.createInfoResult("Distributed system has no regions that can be rebalanced");
        }
        Iterator<MemberPRInfo> it1 = listMemberRegion.iterator();
        block6: while (it1.hasNext() && flagToContinueWithRebalance) {
            try {
                MemberPRInfo memberPR = it1.next();
                if (memberPR.dsMemberList.size() <= 1) continue;
                for (int i = 0; i < memberPR.dsMemberList.size(); ++i) {
                    List<String> rstList;
                    HashSet excludeRegionSet;
                    DistributedMember dsMember = memberPR.dsMemberList.get(i);
                    RebalanceFunction rebalanceFunction = new RebalanceFunction();
                    Object[] functionArgs = new Object[3];
                    functionArgs[0] = simulate;
                    HashSet<String> regionSet = new HashSet<String>();
                    regionSet.add(memberPR.region);
                    functionArgs[1] = regionSet;
                    functionArgs[2] = excludeRegionSet = new HashSet();
                    ArrayList resultList = null;
                    try {
                        if (this.checkMemberPresence(dsMember, cache)) {
                            resultList = (ArrayList)CliUtil.executeFunction((Function)rebalanceFunction, (Object)functionArgs, dsMember).getResult();
                            if (this.checkResultList(rebalanceResulteData, resultList, dsMember)) {
                                result = ResultBuilder.buildResult(rebalanceResulteData);
                                continue;
                            }
                            rstList = this.tokenize((String)resultList.get(0), ",");
                            result = ResultBuilder.buildResult(this.toCompositeResultData(rebalanceResulteData, (ArrayList)rstList, index, simulate.equals("true"), cache));
                            ++index;
                            continue block6;
                        }
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        rebalanceResulteData.addSection().addData(CliStrings.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)), " Reason : Members may be departed");
                        result = ResultBuilder.buildResult(rebalanceResulteData);
                    }
                    catch (Exception ex) {
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        rebalanceResulteData.addSection().addData(CliStrings.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)), " Reason : " + ex.getMessage());
                        result = ResultBuilder.buildResult(rebalanceResulteData);
                    }
                    if (this.checkResultList(rebalanceResulteData, resultList, dsMember)) {
                        result = ResultBuilder.buildResult(rebalanceResulteData);
                        continue;
                    }
                    rstList = this.tokenize((String)resultList.get(0), ",");
                    result = ResultBuilder.buildResult(this.toCompositeResultData(rebalanceResulteData, (ArrayList)rstList, index, simulate.equals("true"), cache));
                    ++index;
                }
            }
            catch (Exception e) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
                return ResultBuilder.buildResult(errorResultData);
            }
        }
        return result;
    }

    public boolean checkMemberPresence(DistributedMember dsMember, Cache cache) {
        Set<DistributedMember> dsMemberList = CliUtil.getAllNormalMembers(cache);
        return dsMemberList.contains(dsMember);
    }

    public String listOfAllMembers(ArrayList<DistributedMember> dsMemberList) {
        StringBuilder listMembersId = new StringBuilder();
        for (int j = 0; j < dsMemberList.size() - 1; ++j) {
            listMembersId.append(dsMemberList.get(j).getId());
            listMembersId.append(" ; ");
        }
        return listMembersId.toString();
    }

    protected CompositeResultData toCompositeResultData(CompositeResultData rebalanceResulteData, ArrayList<String> rstlist, int index, boolean simulate, Cache cache) {
        if (rstlist.size() > 9 && rstlist.get(9) != null && rstlist.get(9).length() > 0) {
            TabularResultData table1 = rebalanceResulteData.addSection().addTable("Table" + index);
            String newLine = System.getProperty("line.separator");
            StringBuilder resultStr = new StringBuilder();
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
            table1.accumulate("Value", rstlist.get(0));
            resultStr.append("Total bytes in all redundant bucket copies created during this rebalance = " + rstlist.get(0));
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
            table1.accumulate("Value", rstlist.get(1));
            resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance = " + rstlist.get(1));
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
            table1.accumulate("Value", rstlist.get(2));
            resultStr.append("Total number of redundant copies created during this rebalance = " + rstlist.get(2));
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
            table1.accumulate("Value", rstlist.get(3));
            resultStr.append("Total bytes in buckets moved during this rebalance = " + rstlist.get(3));
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
            table1.accumulate("Value", rstlist.get(4));
            resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance = " + rstlist.get(4));
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
            table1.accumulate("Value", rstlist.get(5));
            resultStr.append("Total number of buckets moved during this rebalance = " + rstlist.get(5));
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
            table1.accumulate("Value", rstlist.get(6));
            resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance = " + rstlist.get(6));
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
            table1.accumulate("Value", rstlist.get(7));
            resultStr.append("Total primaries transferred during this rebalance = " + rstlist.get(7));
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
            table1.accumulate("Value", rstlist.get(8));
            resultStr.append("Total time (in milliseconds) for this rebalance = " + rstlist.get(8));
            resultStr.append(newLine);
            String headerText = null;
            headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
            for (int i = 9; i < rstlist.size(); ++i) {
                headerText = headerText + " " + rstlist.get(i);
            }
            table1.setHeader(headerText);
            cache.getLogger().info(headerText + resultStr);
        }
        return rebalanceResulteData;
    }

    CompositeResultData buildResultForRebalance(CompositeResultData rebalanceResulteData, RebalanceResults results, int index, boolean simulate, Cache cache) {
        Set<PartitionRebalanceInfo> regions = results.getPartitionRebalanceDetails();
        Iterator<PartitionRebalanceInfo> iterator = regions.iterator();
        if (regions.size() > 0 && iterator.next().getRegionPath() != null && iterator.next().getRegionPath().length() > 0) {
            TabularResultData resultData = rebalanceResulteData.addSection().addTable("Table" + index);
            String newLine = System.getProperty("line.separator");
            StringBuilder resultStr = new StringBuilder();
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreateBytes());
            resultStr.append("Total bytes in all redundant bucket copies created during this rebalance = " + results.getTotalBucketCreateBytes());
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreateTime());
            resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance = " + results.getTotalBucketCreateTime());
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreatesCompleted());
            resultStr.append("Total number of redundant copies created during this rebalance = " + results.getTotalBucketCreatesCompleted());
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransferBytes());
            resultStr.append("Total bytes in buckets moved during this rebalance = " + results.getTotalBucketTransferBytes());
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransferTime());
            resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance = " + results.getTotalBucketTransferTime());
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransfersCompleted());
            resultStr.append("Total number of buckets moved during this rebalance = " + results.getTotalBucketTransfersCompleted());
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
            resultData.accumulate("Value", results.getTotalPrimaryTransferTime());
            resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance = " + results.getTotalPrimaryTransferTime());
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
            resultData.accumulate("Value", results.getTotalPrimaryTransfersCompleted());
            resultStr.append("Total primaries transferred during this rebalance = " + results.getTotalPrimaryTransfersCompleted());
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
            resultData.accumulate("Value", results.getTotalTime());
            resultStr.append("Total time (in milliseconds) for this rebalance = " + results.getTotalTime());
            resultStr.append(newLine);
            Iterator<PartitionRebalanceInfo> it = regions.iterator();
            String headerText = null;
            headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
            while (it.hasNext()) {
                PartitionRebalanceInfo rgn = it.next();
                headerText = headerText + " " + rgn.getRegionPath();
            }
            resultData.setHeader(resultData.getHeader() + headerText);
            cache.getLogger().info(headerText + resultStr);
        }
        return rebalanceResulteData;
    }

    public DistributedMember getAssociatedMembers(String region, Cache cache) {
        DistributedRegionMXBean bean = ManagementService.getManagementService(GemFireCacheImpl.getInstance()).getDistributedRegionMXBean(region);
        DistributedMember member = null;
        if (bean == null) {
            return member;
        }
        String[] membersName = bean.getMembers();
        Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
        Iterator<DistributedMember> it = dsMembers.iterator();
        boolean matchFound = false;
        if (membersName.length > 1) {
            block0: while (it.hasNext() && !matchFound) {
                DistributedMember dsmember = it.next();
                for (String memberName : membersName) {
                    if (!MBeanJMXAdapter.getMemberNameOrId(dsmember).equals(memberName)) continue;
                    member = dsmember;
                    matchFound = true;
                    continue block0;
                }
            }
        }
        return member;
    }

    List<MemberPRInfo> getMemberRegionList(Cache cache, List<String> listExcludedRegion) {
        ArrayList<MemberPRInfo> listMemberPRInfo = new ArrayList<MemberPRInfo>();
        String[] listDSRegions = ManagementService.getManagementService(cache).getDistributedSystemMXBean().listRegions();
        Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
        for (String regionName : listDSRegions) {
            DistributedRegionMXBean bean;
            boolean excludedRegionMatch = false;
            Iterator<String> it = listExcludedRegion.iterator();
            while (it.hasNext()) {
                String excludedRegion = it.next().trim();
                if (regionName.startsWith("/") && !excludedRegion.startsWith("/")) {
                    excludedRegion = "/" + excludedRegion;
                }
                if (excludedRegion.startsWith("/") && !regionName.startsWith("/")) {
                    regionName = "/" + regionName;
                }
                if (!excludedRegion.equals(regionName)) continue;
                excludedRegionMatch = true;
                break;
            }
            if (excludedRegionMatch) continue;
            if (!regionName.startsWith("/")) {
                regionName = "/" + regionName;
            }
            if ((bean = ManagementService.getManagementService(GemFireCacheImpl.getInstance()).getDistributedRegionMXBean(regionName)) == null || !bean.getRegionType().equals(DataPolicy.PARTITION.toString()) && !bean.getRegionType().equals(DataPolicy.PERSISTENT_PARTITION.toString())) continue;
            String[] memberNames = bean.getMembers();
            block2: for (DistributedMember dsmember : dsMembers) {
                for (String memberName : memberNames) {
                    if (!MBeanJMXAdapter.getMemberNameOrId(dsmember).equals(memberName)) continue;
                    MemberPRInfo memberAndItsPRRegions = new MemberPRInfo();
                    memberAndItsPRRegions.region = regionName;
                    memberAndItsPRRegions.dsMemberList.add(dsmember);
                    if (listMemberPRInfo.contains(memberAndItsPRRegions)) {
                        int index = listMemberPRInfo.indexOf(memberAndItsPRRegions);
                        MemberPRInfo listMember = (MemberPRInfo)listMemberPRInfo.get(index);
                        listMember.dsMemberList.add(dsmember);
                        continue block2;
                    }
                    listMemberPRInfo.add(memberAndItsPRRegions);
                    continue block2;
                }
            }
        }
        return listMemberPRInfo;
    }

    @CliCommand(value={"export data"}, help="Export user data from a region to a file.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ResourceOperation(resource=Resource.REGION, operation="EXPORT_DATA")
    public Result exportData(@CliOption(key={"region"}, mandatory=true, optionContext="converter.hint.region.path", help="Region from which data will be exported.") String regionName, @CliOption(key={"file"}, unspecifiedDefaultValue="__NULL__", mandatory=true, help="File to which the exported data will be written. The file must have an extension of \".gfd\".") String filePath, @CliOption(key={"member"}, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.member.idOrName", mandatory=true, help="Name/Id of a member which hosts the region. The data will be exported to the specified file on the host where the member is running.") String memberNameOrId) {
        Cache cache = CacheFactory.getAnyInstance();
        DistributedMember targetMember = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
        Result result = null;
        if (!filePath.endsWith(".gfd")) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".gfd"));
        }
        try {
            Object resultObj;
            String[] args;
            ResultCollector<?, ?> rc;
            List results;
            result = targetMember != null ? ((results = (List)(rc = CliUtil.executeFunction((Function)this.exportDataFunction, (Object)(args = new String[]{regionName, filePath}), targetMember)).getResult()) != null ? ((resultObj = results.get(0)) instanceof String ? ResultBuilder.createInfoResult((String)resultObj) : (resultObj instanceof Exception ? ResultBuilder.createGemFireErrorResult(((Exception)resultObj).getMessage()) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occured while executing : {0}", (Object)"export data")))) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occured while executing : {0}", (Object)"export data"))) : ResultBuilder.createUserErrorResult(CliStrings.format("Member {0} not found", (Object)memberNameOrId));
        }
        catch (CacheClosedException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occured while executing : {0}", (Object)"import data"));
        }
        return result;
    }

    @CliCommand(value={"import data"}, help="Import user data from a file to a region.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ResourceOperation(resource=Resource.REGION, operation="IMPORT_DATA")
    public Result importData(@CliOption(key={"region"}, optionContext="converter.hint.region.path", mandatory=true, help="Region into which data will be imported.") String regionName, @CliOption(key={"file"}, mandatory=true, unspecifiedDefaultValue="__NULL__", help="File from which the imported data will be read. The file must have an extension of \".gfd\".") String filePath, @CliOption(key={"member"}, mandatory=true, unspecifiedDefaultValue="__NULL__", optionContext="converter.hint.member.idOrName", help="Name/Id of a member which hosts the region. The data will be imported from the specified file on the host where the member is running.") String memberNameOrId) {
        Result result = null;
        try {
            Object resultObj;
            String[] args;
            ResultCollector<?, ?> rc;
            List results;
            Cache cache = CacheFactory.getAnyInstance();
            DistributedMember targetMember = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
            if (!filePath.endsWith(".gfd")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".gfd"));
            }
            result = targetMember != null ? ((results = (List)(rc = CliUtil.executeFunction((Function)this.importDataFunction, (Object)(args = new String[]{regionName, filePath}), targetMember)).getResult()) != null ? ((resultObj = results.get(0)) instanceof String ? ResultBuilder.createInfoResult((String)resultObj) : (resultObj instanceof Exception ? ResultBuilder.createGemFireErrorResult(((Exception)resultObj).getMessage()) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occured while executing : {0}", (Object)"import data")))) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occured while executing : {0}", (Object)"import data"))) : ResultBuilder.createUserErrorResult(CliStrings.format("Member {0} not found.", (Object)memberNameOrId));
        }
        catch (CacheClosedException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occured while executing : {0}", (Object)"import data"));
        }
        return result;
    }

    @CliMetaData(shellOnly=false, relatedTopic={"Data", "Region"})
    @CliCommand(value={"put"}, help="Add/Update an entry in a region. If using a region whose key and value classes have been set, then specifying --key-class and --value-class is unnecessary.")
    @ResourceOperation(resource=Resource.REGION, operation="PUT")
    public Result put(@CliOption(key={"key"}, mandatory=true, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"value"}, mandatory=true, help="String or JSON text from which to create the value.  Examples include: \"manager\", \"100L\" and \"('value': 'widget')\".") String value, @CliOption(key={"region"}, mandatory=true, help="Region into which the entry will be put.", optionContext="converter.hint.region.path") String regionPath, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is java.lang.String.") String keyClass, @CliOption(key={"value-class"}, help="Fully qualified class name of the value's type. The default is java.lang.String.") String valueClass, @CliOption(key={"skip-if-exists"}, help="Skip the put operation when an entry with the same key already exists. The default is to overwrite the entry (false).", unspecifiedDefaultValue="false") boolean putIfAbsent) {
        Cache cache = CacheFactory.getAnyInstance();
        DataCommandResult dataResult = null;
        if (regionPath == null || regionPath.isEmpty()) {
            return this.makePresentationResult(DataCommandResult.createPutResult(key, null, null, "Region name is either empty or Null", false));
        }
        if (key == null || key.isEmpty()) {
            dataResult = DataCommandResult.createPutResult(key, null, null, "Key is either empty or Null", false);
            return this.makePresentationResult(dataResult);
        }
        if (value == null || value.isEmpty()) {
            dataResult = DataCommandResult.createPutResult(value, null, null, "Value is either empty or Null", false);
            return this.makePresentationResult(dataResult);
        }
        Region region = cache.getRegion(regionPath);
        DataCommandFunction putfn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = DataCommands.getRegionAssociatedMembers(regionPath, CacheFactory.getAnyInstance(), false);
            if (memberList != null && memberList.size() > 0) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("put");
                request.setValue(value);
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRegionName(regionPath);
                request.setValueClass(valueClass);
                request.setPutIfAbsent(putIfAbsent);
                dataResult = DataCommands.callFunctionForRegion(request, putfn, memberList);
            } else {
                dataResult = DataCommandResult.createPutInfoResult(key, value, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = putfn.put(key, value, putIfAbsent, keyClass, valueClass, regionPath);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return this.makePresentationResult(dataResult);
    }

    private Result makePresentationResult(DataCommandResult dataResult) {
        if (dataResult != null) {
            return dataResult.toCommandResult();
        }
        return ResultBuilder.createGemFireErrorResult("Error executing data command");
    }

    @CliMetaData(shellOnly=false, relatedTopic={"Data", "Region"})
    @CliCommand(value={"get"}, help="Display an entry in a region. If using a region whose key and value classes have been set, then specifying --key-class and --value-class is unnecessary.")
    public Result get(@CliOption(key={"key"}, mandatory=true, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"region"}, mandatory=true, help="Region from which to get the entry.", optionContext="converter.hint.region.path") String regionPath, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is the key constraint for the current region or String.") String keyClass, @CliOption(key={"value-class"}, help="Fully qualified class name of the value's type. The default is the value constraint for the current region or String.") String valueClass, @CliOption(key={"load-on-cache-miss"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="Explicitly enables or disables the use of any registered CacheLoaders on the specified Region when retrieving a value for the specified Key on Cache misses. (Default is true, or enabled)") Boolean loadOnCacheMiss) {
        Cache cache = CacheFactory.getAnyInstance();
        DataCommandResult dataResult = null;
        if (regionPath == null || regionPath.isEmpty()) {
            dataResult = DataCommandResult.createGetResult(key, null, null, "Region name is either empty or Null", false);
            return this.makePresentationResult(dataResult);
        }
        if (key == null || key.isEmpty()) {
            dataResult = DataCommandResult.createGetResult(key, null, null, "Key is either empty or Null", false);
            return this.makePresentationResult(dataResult);
        }
        Region region = cache.getRegion(regionPath);
        DataCommandFunction getfn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = DataCommands.getRegionAssociatedMembers(regionPath, CacheFactory.getAnyInstance(), false);
            if (memberList != null && memberList.size() > 0) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("get");
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRegionName(regionPath);
                request.setValueClass(valueClass);
                request.setLoadOnCacheMiss(loadOnCacheMiss);
                dataResult = DataCommands.callFunctionForRegion(request, getfn, memberList);
            } else {
                dataResult = DataCommandResult.createGetInfoResult(key, null, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = getfn.get(key, keyClass, valueClass, regionPath, loadOnCacheMiss);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return this.makePresentationResult(dataResult);
    }

    @CliMetaData(shellOnly=false, relatedTopic={"Data", "Region"})
    @CliCommand(value={"locate entry"}, help="Identifies the location, including host, member and region, of entries that have the specified key.")
    @ResourceOperation(resource=Resource.REGION, operation="LOCATE_ENTRY")
    public Result locateEntry(@CliOption(key={"key"}, mandatory=true, help="String or JSON text from which to create a key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"region"}, mandatory=true, help="Region in which to locate values.", optionContext="converter.hint.region.path") String regionPath, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is java.lang.String.") String keyClass, @CliOption(key={"value-class"}, help="Fully qualified class name of the value's type. The default is java.lang.String.") String valueClass, @CliOption(key={"recursive"}, help="Whether to traverse regions and subregions recursively.", unspecifiedDefaultValue="false") boolean recursive) {
        DataCommandResult dataResult = null;
        if (regionPath == null || regionPath.isEmpty()) {
            dataResult = DataCommandResult.createLocateEntryResult(key, null, null, "Region name is either empty or Null", false);
            return this.makePresentationResult(dataResult);
        }
        if (key == null || key.isEmpty()) {
            dataResult = DataCommandResult.createLocateEntryResult(key, null, null, "Key is either empty or Null", false);
            return this.makePresentationResult(dataResult);
        }
        DataCommandFunction locateEntry = new DataCommandFunction();
        Set<DistributedMember> memberList = DataCommands.getRegionAssociatedMembers(regionPath, CacheFactory.getAnyInstance(), true);
        if (memberList != null && memberList.size() > 0) {
            DataCommandRequest request = new DataCommandRequest();
            request.setCommand("locate entry");
            request.setKey(key);
            request.setKeyClass(keyClass);
            request.setRegionName(regionPath);
            request.setValueClass(valueClass);
            request.setRecursive(recursive);
            dataResult = DataCommands.callFunctionForRegion(request, locateEntry, memberList);
        } else {
            dataResult = DataCommandResult.createLocateEntryInfoResult(key, null, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return this.makePresentationResult(dataResult);
    }

    @CliMetaData(shellOnly=false, relatedTopic={"Data", "Region"})
    @CliCommand(value={"remove"}, help="Remove an entry from a region. If using a region whose key class has been set, then specifying --key-class is unnecessary.")
    public Result remove(@CliOption(key={"key"}, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"region"}, mandatory=true, help="Region from which to remove the entry.", optionContext="converter.hint.region.path") String regionPath, @CliOption(key={"all"}, help="Clears the region by removing all entries. Partitioned region does not support remove-all", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean removeAllKeys, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is the key constraint for the current region or String.") String keyClass) {
        Cache cache = CacheFactory.getAnyInstance();
        DataCommandResult dataResult = null;
        if (regionPath == null || regionPath.isEmpty()) {
            dataResult = DataCommandResult.createRemoveResult(key, null, null, "Region name is either empty or Null", false);
            return this.makePresentationResult(dataResult);
        }
        if (!removeAllKeys && (key == null || key.isEmpty())) {
            dataResult = DataCommandResult.createRemoveResult(key, null, null, "Key is either empty or Null", false);
            return this.makePresentationResult(dataResult);
        }
        Region region = cache.getRegion(regionPath);
        DataCommandFunction removefn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = DataCommands.getRegionAssociatedMembers(regionPath, CacheFactory.getAnyInstance(), false);
            if (memberList != null && memberList.size() > 0) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("remove");
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRemoveAllKeys(removeAllKeys ? "ALL" : null);
                request.setRegionName(regionPath);
                dataResult = DataCommands.callFunctionForRegion(request, removefn, memberList);
            } else {
                dataResult = DataCommandResult.createRemoveInfoResult(key, null, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = removefn.remove(key, keyClass, regionPath, removeAllKeys ? "ALL" : null);
        }
        dataResult.setKeyClass(keyClass);
        return this.makePresentationResult(dataResult);
    }

    @CliMetaData(shellOnly=false, relatedTopic={"Data", "Region"})
    @MultiStepCommand
    @CliCommand(value={"query"}, help="Run the specified OQL query as a single quoted string and display the results in one or more pages. Limit will default to the value stored in the \"APP_FETCH_SIZE\" variable. Page size will default to the value stored in the \"APP_COLLECTION_LIMIT\" variable.")
    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="QUERYDATA_DS")
    public Object query(@CliOption(key={"query"}, help="The OQL string.", mandatory=true) String query, @CliOption(key={"step-name"}, mandatory=false, help="Stpe name", unspecifiedDefaultValue="ALL") String stepName, @CliOption(key={"interactive"}, mandatory=false, help="Whether or not this query is interactive. If false then all results will be displayed at once.", unspecifiedDefaultValue="true") boolean interactive) {
        if (!CliUtil.isGfshVM() && stepName.equals("ALL")) {
            return ResultBuilder.createInfoResult("query command should be used only from shell. Use QueryService API for running query inside Gemfire VMs");
        }
        Object[] arguments = new Object[]{query, stepName, interactive};
        DataCommandFunction.SelectExecStep exec = new DataCommandFunction.SelectExecStep(arguments);
        DataCommandFunction.SelectDisplayStep display = new DataCommandFunction.SelectDisplayStep(arguments);
        DataCommandFunction.SelectMoveStep move = new DataCommandFunction.SelectMoveStep(arguments);
        DataCommandFunction.SelectQuitStep quit = new DataCommandFunction.SelectQuitStep(arguments);
        CLIStep[] steps = new CLIStep[]{exec, display, move, quit};
        return CLIMultiStepHelper.chooseStep(steps, stepName);
    }

    @CliAvailabilityIndicator(value={"rebalance", "get", "put", "remove", "locate entry", "query", "import data", "export data"})
    public boolean dataCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    public static DataCommandResult callFunctionForRegion(DataCommandRequest request, DataCommandFunction putfn, Set<DistributedMember> members) {
        if (members.size() == 1) {
            DistributedMember member = members.iterator().next();
            ResultCollector<?, ?> collector = FunctionService.onMember(member).withArgs(request).execute(putfn);
            List list = (List)collector.getResult();
            Object object = list.get(0);
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                DataCommandResult result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            DataCommandResult result = (DataCommandResult)list.get(0);
            result.aggregate(null);
            return result;
        }
        ResultCollector<?, ?> collector = FunctionService.onMembers(members).withArgs(request).execute(putfn);
        List list = (List)collector.getResult();
        DataCommandResult result = null;
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            if (result == null) {
                result = (DataCommandResult)object;
                result.aggregate(null);
                continue;
            }
            result.aggregate((DataCommandResult)object);
        }
        return result;
    }

    public static Set<DistributedMember> getQueryRegionsAssociatedMembers(Set<String> regions, Cache cache, boolean returnAll) {
        LogWriter logger = cache.getLogger();
        Set<DistributedMember> members = null;
        Set<DistributedMember> newMembers = null;
        Iterator<String> iterator = regions.iterator();
        String region = iterator.next();
        members = DataCommands.getRegionAssociatedMembers(region, cache, true);
        if (logger.fineEnabled()) {
            logger.fine("Members for region " + region + " Members " + members);
        }
        ArrayList<String> regionAndingList = new ArrayList<String>();
        regionAndingList.add(region);
        if (regions.size() == 1) {
            newMembers = members;
        } else if (members != null && !members.isEmpty()) {
            while (iterator.hasNext()) {
                region = iterator.next();
                newMembers = DataCommands.getRegionAssociatedMembers(region, cache, true);
                if (newMembers == null) {
                    newMembers = new HashSet<DistributedMember>();
                }
                if (logger.fineEnabled()) {
                    logger.fine("Members for region " + region + " Members " + newMembers);
                }
                regionAndingList.add(region);
                newMembers.retainAll(members);
                members = newMembers;
                if (!logger.fineEnabled()) continue;
                logger.fine("Members after anding for regions " + regionAndingList + " List : " + newMembers);
            }
        }
        members = new HashSet<DistributedMember>();
        if (newMembers == null) {
            return members;
        }
        Iterator<DistributedMember> memberIterator = newMembers.iterator();
        while (memberIterator.hasNext()) {
            members.add(memberIterator.next());
            if (returnAll) continue;
            return members;
        }
        return members;
    }

    public static Set<DistributedMember> getRegionAssociatedMembers(String region, Cache cache, boolean returnAll) {
        DistributedMember member = null;
        if (region == null || region.isEmpty()) {
            return null;
        }
        DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(region);
        if (bean == null) {
            bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean("/" + region);
        }
        if (bean == null) {
            return null;
        }
        String[] membersName = bean.getMembers();
        Set<DistributedMember> dsMembers = cache.getMembers();
        HashSet<DistributedMember> dsMembersWithThisMember = new HashSet<DistributedMember>();
        dsMembersWithThisMember.addAll(dsMembers);
        dsMembersWithThisMember.add(cache.getDistributedSystem().getDistributedMember());
        Iterator it = dsMembersWithThisMember.iterator();
        Set<DistributedMember> matchedMembers = new HashSet<DistributedMember>();
        if (membersName.length > 0) {
            while (it.hasNext()) {
                DistributedMember dsmember = (DistributedMember)it.next();
                for (String memberName : membersName) {
                    String name = MBeanJMXAdapter.getMemberNameOrId(dsmember);
                    if (!name.equals(memberName)) continue;
                    member = dsmember;
                    matchedMembers.add(member);
                    if (returnAll) continue;
                    return matchedMembers;
                }
            }
        }
        if (matchedMembers.size() == 0) {
            matchedMembers = CliUtil.getMembersForeRegionViaFunction(cache, region);
        }
        return matchedMembers;
    }

    public static Object[] replaceGfshEnvVar(String query, Map<String, String> gfshEnvVarMap) {
        int index2;
        int index1;
        boolean done = false;
        int startIndex = 0;
        int replacedVars = 0;
        while (!done && (index1 = query.indexOf("${", startIndex)) != -1 && (index2 = query.indexOf("}", index1)) != -1) {
            String var = query.substring(index1 + 2, index2);
            String value = gfshEnvVarMap.get(var);
            if (value != null) {
                query = query.replaceAll("\\$\\{" + var + "\\}", value);
                ++replacedVars;
            }
            if ((startIndex = index2 + 1) < query.length()) continue;
            done = true;
        }
        return new Object[]{replacedVars, query};
    }

    private static class MemberPRInfo {
        public ArrayList<DistributedMember> dsMemberList;
        public String region = new String();

        public MemberPRInfo() {
            this.dsMemberList = new ArrayList();
        }

        public boolean equals(Object o2) {
            if (o2 == null) {
                return false;
            }
            return this.region.equals(((MemberPRInfo)o2).region);
        }
    }

    private class ExecuteRebalanceWithTimeout
    implements Callable<Result> {
        String[] includeRegions = null;
        String[] excludeRegions = null;
        boolean simulate;
        Cache cache = CacheFactory.getAnyInstance();

        @Override
        public Result call() throws Exception {
            return this.executeRebalanceWithTimeout(this.includeRegions, this.excludeRegions, this.simulate);
        }

        public ExecuteRebalanceWithTimeout(String[] includedRegions, String[] excludedRegions, boolean toSimulate) {
            this.includeRegions = includedRegions;
            this.excludeRegions = excludedRegions;
            this.simulate = toSimulate;
        }

        public Result executeRebalanceWithTimeout(String[] includeRegions, String[] excludeRegions, boolean simulate) {
            Result result = null;
            try {
                RebalanceOperation op = null;
                new HashSet();
                new HashSet();
                if (includeRegions != null && includeRegions.length > 0) {
                    CompositeResultData rebalanceResulteData = ResultBuilder.createCompositeResultData();
                    int index = 0;
                    for (String regionName : includeRegions) {
                        regionName = regionName.startsWith("/") ? regionName : "/" + regionName;
                        Region region = this.cache.getRegion(regionName);
                        if (region == null) {
                            List<String> rstList;
                            ArrayList resultList;
                            DistributedMember member = DataCommands.this.getAssociatedMembers(regionName, this.cache);
                            if (member == null) {
                                LogWrapper.getInstance().info(CliStrings.format("For the region {0}, no member was found", (Object)regionName));
                                continue;
                            }
                            RebalanceFunction rebalanceFunction = new RebalanceFunction();
                            Object[] functionArgs = new Object[3];
                            functionArgs[0] = simulate ? "true" : "false";
                            HashSet setRegionName = new HashSet();
                            setRegionName.add(regionName);
                            functionArgs[1] = setRegionName;
                            HashSet<String> excludeRegionSet = new HashSet<String>();
                            if (excludeRegions != null && excludeRegions.length > 0) {
                                for (String str : excludeRegions) {
                                    excludeRegionSet.add(str);
                                }
                            }
                            functionArgs[2] = excludeRegionSet;
                            if (simulate) {
                                resultList = null;
                                try {
                                    resultList = (ArrayList)CliUtil.executeFunction((Function)rebalanceFunction, (Object)functionArgs, member).getResult();
                                }
                                catch (Exception ex) {
                                    LogWrapper.getInstance().info(CliStrings.format("Excpetion occured while rebalancing on member : {0} . Exception is : {1}", member.getId(), ex.getMessage()), ex);
                                    rebalanceResulteData.addSection().addData(CliStrings.format("Excpetion occured while rebalancing on member : {0} . Exception is ", (Object)member.getId()), ex.getMessage());
                                    result = ResultBuilder.buildResult(rebalanceResulteData);
                                    continue;
                                }
                                if (DataCommands.this.checkResultList(rebalanceResulteData, resultList, member)) {
                                    result = ResultBuilder.buildResult(rebalanceResulteData);
                                    continue;
                                }
                                rstList = DataCommands.this.tokenize((String)resultList.get(0), ",");
                                result = ResultBuilder.buildResult(DataCommands.this.toCompositeResultData(rebalanceResulteData, (ArrayList)rstList, index, simulate, this.cache));
                            } else {
                                resultList = null;
                                try {
                                    resultList = (ArrayList)CliUtil.executeFunction((Function)rebalanceFunction, (Object)functionArgs, member).getResult();
                                }
                                catch (Exception ex) {
                                    LogWrapper.getInstance().info(CliStrings.format("Excpetion occured while rebalancing on member : {0} . Exception is : {1}", member.getId(), ex.getMessage()), ex);
                                    rebalanceResulteData.addSection().addData(CliStrings.format("Excpetion occured while rebalancing on member : {0} . Exception is ", (Object)member.getId()), ex.getMessage());
                                    result = ResultBuilder.buildResult(rebalanceResulteData);
                                    continue;
                                }
                                if (DataCommands.this.checkResultList(rebalanceResulteData, resultList, member)) {
                                    result = ResultBuilder.buildResult(rebalanceResulteData);
                                    continue;
                                }
                                rstList = DataCommands.this.tokenize((String)resultList.get(0), ",");
                                result = ResultBuilder.buildResult(DataCommands.this.toCompositeResultData(rebalanceResulteData, (ArrayList)rstList, index, simulate, this.cache));
                            }
                        } else {
                            ResourceManager manager = this.cache.getResourceManager();
                            RebalanceFactory rbFactory = manager.createRebalanceFactory();
                            HashSet<String> excludeRegionSet = new HashSet<String>();
                            if (excludeRegions != null) {
                                for (String excludeRegion : excludeRegions) {
                                    excludeRegionSet.add(excludeRegion);
                                }
                            }
                            rbFactory.excludeRegions(excludeRegionSet);
                            HashSet<String> includeRegionSet = new HashSet<String>();
                            includeRegionSet.add(regionName);
                            rbFactory.includeRegions(includeRegionSet);
                            if (simulate) {
                                op = manager.createRebalanceFactory().simulate();
                                result = ResultBuilder.buildResult(DataCommands.this.buildResultForRebalance(rebalanceResulteData, op.getResults(), index, simulate, this.cache));
                            } else {
                                op = manager.createRebalanceFactory().start();
                                result = ResultBuilder.buildResult(DataCommands.this.buildResultForRebalance(rebalanceResulteData, op.getResults(), index, simulate, this.cache));
                            }
                        }
                        ++index;
                    }
                    LogWrapper.getInstance().info("Rebalance returning result" + result);
                    return result;
                }
                result = DataCommands.this.executeRebalanceOnDS(this.cache, String.valueOf(simulate), excludeRegions);
                LogWrapper.getInstance().info("Starting Rebalance simulate false result >> " + result);
            }
            catch (Exception e) {
                result = ResultBuilder.createGemFireErrorResult(e.getMessage());
            }
            LogWrapper.getInstance().info("Rebalance returning result >>>" + result);
            return result;
        }
    }
}

