/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans.stats;

import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.beans.stats.StatsAggregator;
import java.util.HashMap;
import java.util.Map;

public class ServerClusterStatsMonitor {
    private static final String NUM_CLIENTS = "CurrentClients";
    private static final String ACTIVE_QUERY_COUNT = "ActiveCQCount";
    private static final String REGISTERED_QUERY_COUNT = "RegisteredCQCount";
    private static final String QUERY_REQUEST_RATE = "QueryRequestRate";
    private static final String NUM_SUBSCRIPTIONS = "NumSubscriptions";
    private StatsAggregator aggregator;
    private Map<String, Class<?>> typeMap = new HashMap();

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.aggregator.aggregate(newState, oldState);
    }

    public ServerClusterStatsMonitor() {
        this.intTypeMap();
        this.aggregator = new StatsAggregator(this.typeMap);
    }

    private void intTypeMap() {
        this.typeMap.put(NUM_CLIENTS, Integer.TYPE);
        this.typeMap.put(ACTIVE_QUERY_COUNT, Long.TYPE);
        this.typeMap.put(QUERY_REQUEST_RATE, Float.TYPE);
        this.typeMap.put(REGISTERED_QUERY_COUNT, Long.TYPE);
        this.typeMap.put(NUM_SUBSCRIPTIONS, Integer.TYPE);
    }

    public int getNumClients() {
        return this.aggregator.getIntValue(NUM_CLIENTS);
    }

    public long getActiveCQCount() {
        return this.aggregator.getLongValue(ACTIVE_QUERY_COUNT);
    }

    public long getRegisteredCQCount() {
        return this.aggregator.getLongValue(REGISTERED_QUERY_COUNT);
    }

    public float getQueryRequestRate() {
        return this.aggregator.getFloatValue(QUERY_REQUEST_RATE).floatValue();
    }

    public int getNumSubscriptions() {
        return this.aggregator.getIntValue(NUM_SUBSCRIPTIONS);
    }
}

