/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.DLockToken;
import com.gemstone.gemfire.management.internal.ManagementConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LockServiceMBeanBridge {
    private DLockService lockService;

    public LockServiceMBeanBridge(DLockService lockService) {
        this.lockService = lockService;
    }

    public void becomeLockGrantor() {
        this.lockService.becomeLockGrantor();
    }

    public String[] listHeldLocks() {
        Map<Object, DLockToken> tokenMap = this.lockService.snapshotService();
        Iterator<Object> it = tokenMap.keySet().iterator();
        ArrayList<String> listOfLocks = new ArrayList<String>();
        boolean j = false;
        while (it.hasNext()) {
            Object lockObject = it.next();
            DLockToken token = tokenMap.get(lockObject);
            if (token.getUsageCount() <= 0) continue;
            listOfLocks.add(lockObject.toString());
        }
        if (listOfLocks.size() > 0) {
            String[] retStr = new String[listOfLocks.size()];
            listOfLocks.toArray(retStr);
            return retStr;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public boolean isDistributed() {
        return this.lockService.isDistributed();
    }

    public boolean isLockGrantor() {
        return this.lockService.isLockGrantor();
    }

    public String fetchGrantorMember() {
        return this.lockService.peekLockGrantorId() != null ? this.lockService.peekLockGrantorId().getLockGrantorMember().getId() : null;
    }

    public int getMemberCount() {
        return 0;
    }

    public String[] getMemberNames() {
        return ManagementConstants.NO_DATA_STRING;
    }

    public String getName() {
        return this.lockService.getName();
    }

    public Map<String, String> listThreadsHoldingLock() {
        Map<Object, DLockToken> tokenMap = this.lockService.snapshotService();
        Iterator<Object> it = tokenMap.keySet().iterator();
        HashMap<String, String> listOfLocks = new HashMap<String, String>();
        boolean j = false;
        while (it.hasNext()) {
            Object lockObject = it.next();
            DLockToken token = tokenMap.get(lockObject);
            if (token.getUsageCount() <= 0) continue;
            listOfLocks.put(lockObject.toString(), token.getThreadName());
        }
        return listOfLocks;
    }
}

