/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.management.internal.beans.PartitionedRegionBridge;
import com.gemstone.gemfire.management.internal.beans.stats.MBeanStatsMonitor;
import com.gemstone.gemfire.management.internal.beans.stats.StatType;
import com.gemstone.gemfire.management.internal.beans.stats.StatsRate;
import java.util.Map;
import java.util.Set;

public class HDFSRegionBridge<K, V>
extends PartitionedRegionBridge<K, V> {
    private SortedOplogStatistics soplogStats;
    private MBeanStatsMonitor hdfsRegionMonitor;
    private static final String WRITTEN_BYTES = "writeBytes";
    private static final String READ_BYTES = "readBytes";
    private static final String SCANNED_BYTES = "scanBytes";
    public static final String HDFS_REGION_MONITOR = "HDFSRegionMonitor";
    private StatsRate diskWritesRate;
    private StatsRate diskReadsRate;
    private PartitionedRegion parRegion;
    private long estimatedEntryCount = 0L;
    private int skipCount = 10;

    public HDFSRegionBridge(Region<K, V> region) {
        super(region);
        HDFSRegionDirector director = HDFSRegionDirector.getInstance();
        String regionFullPath = region.getFullPath();
        this.soplogStats = director.getHdfsRegionStats(regionFullPath);
        this.hdfsRegionMonitor = new MBeanStatsMonitor("HDFSRegionMonitor_" + regionFullPath);
        this.hdfsRegionMonitor.addStatisticsToMonitor(this.soplogStats.getStats());
        this.parRegion = (PartitionedRegion)region;
        this.configureHDFSRegionMetrics();
    }

    private void configureHDFSRegionMetrics() {
        this.diskWritesRate = new StatsRate(WRITTEN_BYTES, StatType.INT_TYPE, this.hdfsRegionMonitor);
        String[] readsRates = new String[]{READ_BYTES, SCANNED_BYTES};
        this.diskReadsRate = new StatsRate(readsRates, StatType.INT_TYPE, this.hdfsRegionMonitor);
    }

    @Override
    public long getEstimatedSizeForHDFSRegion() {
        if (this.parRegion.isHDFSReadWriteRegion()) {
            if (this.skipCount % 10 == 0) {
                this.computeEntryCount();
                this.skipCount = 1;
            } else {
                ++this.skipCount;
            }
            return this.estimatedEntryCount;
        }
        return -1L;
    }

    private void computeEntryCount() {
        if (this.parRegion.isDataStore()) {
            int numLocalEntries = 0;
            Map<Integer, PartitionedRegion.SizeEntry> localPrimaryBucketRegions = this.parRegion.getDataStore().getSizeEstimateForLocalPrimaryBuckets();
            if (localPrimaryBucketRegions != null && localPrimaryBucketRegions.size() > 0) {
                for (Map.Entry<Integer, PartitionedRegion.SizeEntry> me : localPrimaryBucketRegions.entrySet()) {
                    numLocalEntries += me.getValue().getSize();
                }
            }
            this.estimatedEntryCount = numLocalEntries;
        }
    }

    @Override
    public long getEntryCount() {
        if (this.parRegion.isDataStore()) {
            int numLocalEntries = 0;
            Set<BucketRegion> localPrimaryBucketRegions = this.parRegion.getDataStore().getAllLocalPrimaryBucketRegions();
            if (localPrimaryBucketRegions != null && localPrimaryBucketRegions.size() > 0) {
                for (BucketRegion br : localPrimaryBucketRegions) {
                    numLocalEntries += br.getRegionMap().sizeInVM() - br.getTombstoneCount();
                }
            }
            return numLocalEntries;
        }
        return 0L;
    }

    @Override
    public long getEntrySize() {
        return -1L;
    }

    @Override
    public long getDiskUsage() {
        if (this.soplogStats != null) {
            return this.soplogStats.getStoreUsageBytes();
        }
        return -1L;
    }

    @Override
    public float getDiskReadsRate() {
        return this.diskReadsRate.getRate();
    }

    @Override
    public float getDiskWritesRate() {
        return this.diskWritesRate.getRate();
    }
}

