/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.internal.cache.CacheServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverStats;
import com.gemstone.gemfire.management.internal.ManagementConstants;
import com.gemstone.gemfire.management.internal.beans.ServerBridge;
import com.gemstone.gemfire.management.internal.beans.stats.StatType;
import com.gemstone.gemfire.management.internal.beans.stats.StatsRate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GatewayReceiverMBeanBridge
extends ServerBridge {
    private GatewayReceiver rcv;
    private StatsRate createRequestRate;
    private StatsRate updateRequestRate;
    private StatsRate destroyRequestRate;
    private StatsRate eventsReceivedRate;

    public GatewayReceiverMBeanBridge(GatewayReceiver rcv) {
        this.rcv = rcv;
        this.initializeReceiverStats();
    }

    protected void startServer() {
        CacheServer server = this.rcv.getServer();
        this.addServer(server);
    }

    protected void stopServer() {
        this.removeServer();
    }

    public GatewayReceiverMBeanBridge() {
        this.initializeReceiverStats();
    }

    public void addGatewayReceiverStats(GatewayReceiverStats stats) {
        this.monitor.addStatisticsToMonitor(stats.getStats());
    }

    @Override
    public void stopMonitor() {
        this.monitor.stopListener();
    }

    public String getBindAddress() {
        return this.rcv.getBindAddress();
    }

    public int getPort() {
        return this.rcv.getPort();
    }

    public String getReceiverId() {
        return null;
    }

    public int getSocketBufferSize() {
        return this.rcv.getSocketBufferSize();
    }

    public boolean isRunning() {
        return this.rcv.isRunning();
    }

    public void start() throws Exception {
        try {
            this.rcv.start();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public void stop() throws Exception {
        try {
            this.rcv.stop();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public int getEndPort() {
        return this.rcv.getEndPort();
    }

    public String[] getGatewayTransportFilters() {
        List<GatewayTransportFilter> transPortfilters = this.rcv.getGatewayTransportFilters();
        String[] filtersStr = null;
        if (transPortfilters == null || transPortfilters.size() <= 0) {
            return filtersStr;
        }
        filtersStr = new String[transPortfilters.size()];
        int j = 0;
        for (GatewayTransportFilter filter : transPortfilters) {
            filtersStr[j] = filter.toString();
            ++j;
        }
        return filtersStr;
    }

    public int getStartPort() {
        return this.rcv.getEndPort();
    }

    public int getMaximumTimeBetweenPings() {
        return this.rcv.getMaximumTimeBetweenPings();
    }

    private void initializeReceiverStats() {
        this.createRequestRate = new StatsRate("createRequests", StatType.INT_TYPE, this.monitor);
        this.updateRequestRate = new StatsRate("updateRequest", StatType.INT_TYPE, this.monitor);
        this.destroyRequestRate = new StatsRate("destroyRequest", StatType.INT_TYPE, this.monitor);
        this.eventsReceivedRate = new StatsRate("eventsReceived", StatType.INT_TYPE, this.monitor);
    }

    public float getCreateRequestsRate() {
        return this.createRequestRate.getRate();
    }

    public float getDestroyRequestsRate() {
        return this.destroyRequestRate.getRate();
    }

    public int getDuplicateBatchesReceived() {
        return this.getStatistic("duplicateBatchesReceived").intValue();
    }

    public int getOutoforderBatchesReceived() {
        return this.getStatistic("outoforderBatchesReceived").intValue();
    }

    public float getUpdateRequestsRate() {
        return this.updateRequestRate.getRate();
    }

    public float getEventsReceivedRate() {
        return this.eventsReceivedRate.getRate();
    }

    public String[] getConnectedGatewaySenders() {
        HashSet<String> uniqueIds = null;
        AcceptorImpl acceptor = ((CacheServerImpl)this.rcv.getServer()).getAcceptor();
        Set<ServerConnection> serverConnections = acceptor.getAllServerConnections();
        if (serverConnections != null && serverConnections.size() > 0) {
            uniqueIds = new HashSet<String>();
            for (ServerConnection conn : serverConnections) {
                uniqueIds.add(conn.getMembershipID());
            }
            String[] allConnectedClientStr = new String[uniqueIds.size()];
            return uniqueIds.toArray(allConnectedClientStr);
        }
        return new String[0];
    }

    public long getAverageBatchProcessingTime() {
        if (this.getStatistic("processBatchRequests").longValue() != 0L) {
            long processTimeInNano = this.getStatistic("processBatchTime").longValue() / this.getStatistic("processBatchRequests").longValue();
            return ManagementConstants.nanoSeconds.toMillis(processTimeInNano);
        }
        return 0L;
    }
}

