/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.management.internal.OpenTypeConverter;
import com.gemstone.gemfire.management.internal.OpenTypeUtil;
import java.io.InvalidObjectException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class TableConverter
extends OpenTypeConverter {
    private final boolean sortedMap;
    private final OpenTypeConverter keyConverter;
    private final OpenTypeConverter valueConverter;

    TableConverter(Type targetType, boolean sortedMap, TabularType tabularType, OpenTypeConverter keyConverter, OpenTypeConverter valueConverter) {
        super(targetType, tabularType, TabularData.class);
        this.sortedMap = sortedMap;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    @Override
    final Object toNonNullOpenValue(Object value) throws OpenDataException {
        Comparator comparator;
        Map valueMap = (Map)value;
        if (valueMap instanceof SortedMap && (comparator = ((SortedMap)valueMap).comparator()) != null) {
            String msg = "Cannot convert SortedMap with non-null comparator: " + comparator;
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            OpenDataException ode = new OpenDataException(msg);
            ode.initCause(iae);
            throw ode;
        }
        TabularType tabularType = (TabularType)this.getOpenType();
        TabularDataSupport table = new TabularDataSupport(tabularType);
        CompositeType rowType = tabularType.getRowType();
        for (Map.Entry entry : valueMap.entrySet()) {
            Object openKey = this.keyConverter.toOpenValue(entry.getKey());
            Object openValue = this.valueConverter.toOpenValue(entry.getValue());
            CompositeDataSupport row = new CompositeDataSupport(rowType, keyValueArray, new Object[]{openKey, openValue});
            table.put(row);
        }
        return table;
    }

    @Override
    public final Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
        TabularData table = (TabularData)openValue;
        Collection<?> rows = table.values();
        Map<Object, Object> valueMap = this.sortedMap ? OpenTypeUtil.newSortedMap() : OpenTypeUtil.newMap();
        for (CompositeData row : rows) {
            Object value;
            Object key = this.keyConverter.fromOpenValue(row.get("key"));
            if (valueMap.put(key, value = this.valueConverter.fromOpenValue(row.get("value"))) == null) continue;
            String msg = "Duplicate entry in TabularData: key=" + key;
            throw new InvalidObjectException(msg);
        }
        return valueMap;
    }

    @Override
    void checkReconstructible() throws InvalidObjectException {
        this.keyConverter.checkReconstructible();
        this.valueConverter.checkReconstructible();
    }
}

