/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.AgentUtil;
import com.gemstone.gemfire.management.internal.JettyHelper;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class RestAgent {
    private static final Logger logger = LogService.getLogger();
    private boolean running = false;
    private final DistributionConfig config;
    private Server httpServer;
    private final String GEMFIRE_VERSION = GemFireVersion.getGemFireVersion();
    private AgentUtil agentUtil = new AgentUtil(this.GEMFIRE_VERSION);

    public RestAgent(DistributionConfig config) {
        this.config = config;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private boolean isManagementRestServiceRunning(GemFireCacheImpl cache) {
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(cache);
        return managementService.getManagementAgent() != null && managementService.getManagementAgent().isHttpServiceRunning();
    }

    public synchronized void start(GemFireCacheImpl cache) {
        if (!this.running && this.config.getHttpServicePort() != 0 && !this.isManagementRestServiceRunning(cache)) {
            try {
                this.startHttpService();
                this.running = true;
                cache.setRESTServiceRunning(true);
                RestAgent.createParameterizedQueryRegion();
            }
            catch (RuntimeException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.stopHttpService();
            if (logger.isDebugEnabled()) {
                logger.debug("Gemfire Rest Http service stopped");
            }
            this.running = false;
        } else if (logger.isDebugEnabled()) {
            logger.debug("Attempt to stop Gemfire Rest Http service which is not running");
        }
    }

    private boolean isRunningInTomcat() {
        return System.getProperty("catalina.base") != null || System.getProperty("catalina.home") != null;
    }

    public void startHttpService() {
        logger.info("Attempting to start HTTP service on port ({}) at bind-address ({})...", new Object[]{this.config.getHttpServicePort(), this.config.getHttpServiceBindAddress()});
        String gemfireAPIWar = this.agentUtil.findWarLocation("geode-web-api");
        if (gemfireAPIWar == null) {
            logger.info("Unable to find GemFire Developer REST API WAR file; the Developer REST Interface for GemFire will not be accessible.");
        }
        try {
            if (this.isRunningInTomcat()) {
                logger.warn("Detected presence of catalina system properties. HTTP service will not be started. To enable the GemFire Developer REST API, please deploy the /geode-web-api WAR file in your application server.");
            } else if (this.agentUtil.isWebApplicationAvailable(gemfireAPIWar)) {
                String bindAddress = this.config.getHttpServiceBindAddress();
                int port = this.config.getHttpServicePort();
                this.httpServer = JettyHelper.initJetty(bindAddress, port, this.config.getHttpServiceSSLEnabled(), this.config.getHttpServiceSSLRequireAuthentication(), this.config.getHttpServiceSSLProtocols(), this.config.getHttpServiceSSLCiphers(), this.config.getHttpServiceSSLProperties());
                this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/gemfire-api", gemfireAPIWar);
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting HTTP embedded server on port ({}) at bind-address ({})...", new Object[]{((ServerConnector)this.httpServer.getConnectors()[0]).getPort(), bindAddress});
                }
                this.httpServer = JettyHelper.startJetty(this.httpServer);
                logger.info("HTTP service started successfully...!!");
            }
        }
        catch (Exception e) {
            this.stopHttpService();
            throw new RuntimeException("HTTP service failed to start due to " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void stopHttpService() {
        if (this.httpServer != null) {
            logger.info("Stopping the HTTP service...");
            this.httpServer.stop();
            try {
                this.httpServer.destroy();
            }
            catch (Exception ignore) {
                logger.error("Failed to properly release resources held by the HTTP service: {}", new Object[]{ignore.getMessage(), ignore});
            }
            finally {
                this.httpServer = null;
                System.clearProperty("catalina.base");
                System.clearProperty("catalina.home");
            }
            catch (Exception e) {
                try {
                    logger.warn("Failed to stop the HTTP service because: {}", new Object[]{e.getMessage(), e});
                }
                catch (Throwable throwable) {
                    try {
                        this.httpServer.destroy();
                    }
                    catch (Exception ignore) {
                        logger.error("Failed to properly release resources held by the HTTP service: {}", new Object[]{ignore.getMessage(), ignore});
                    }
                    finally {
                        this.httpServer = null;
                        System.clearProperty("catalina.base");
                        System.clearProperty("catalina.home");
                    }
                    throw throwable;
                }
                try {
                    this.httpServer.destroy();
                }
                catch (Exception ignore) {
                    logger.error("Failed to properly release resources held by the HTTP service: {}", new Object[]{ignore.getMessage(), ignore});
                }
                finally {
                    this.httpServer = null;
                    System.clearProperty("catalina.base");
                    System.clearProperty("catalina.home");
                }
            }
        }
    }

    public static void createParameterizedQueryRegion() {
        block6: {
            try {
                GemFireCacheImpl cache;
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting creation of  __ParameterizedQueries__ region");
                }
                if ((cache = (GemFireCacheImpl)CacheFactory.getAnyInstance()) != null) {
                    InternalRegionArguments regionArguments = new InternalRegionArguments();
                    regionArguments.setIsUsedForMetaRegion(true);
                    AttributesFactory<String, String> attributesFactory = new AttributesFactory<String, String>();
                    attributesFactory.setConcurrencyChecksEnabled(false);
                    attributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                    attributesFactory.setKeyConstraint(String.class);
                    attributesFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    attributesFactory.setStatisticsEnabled(false);
                    attributesFactory.setValueConstraint(String.class);
                    RegionAttributes regionAttributes = attributesFactory.create();
                    cache.createVMRegion("__ParameterizedQueries__", regionAttributes, regionArguments);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Successfully created __ParameterizedQueries__ region");
                    }
                } else {
                    logger.error("Cannot create ParameterizedQueries Region as no cache found!");
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Error creating __ParameterizedQueries__ Region with cause {}", new Object[]{e.getMessage(), e});
            }
        }
    }
}

