/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.NotificationKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Notification;
import javax.management.ObjectName;

public class ManagementResourceRepo {
    private Map<DistributedMember, Region<String, Object>> monitoringRegionMap = new ConcurrentHashMap<DistributedMember, Region<String, Object>>();
    private Map<DistributedMember, Region<NotificationKey, Notification>> notifRegionMap = new ConcurrentHashMap<DistributedMember, Region<NotificationKey, Notification>>();
    private Region<String, Object> localMonitoringRegion;
    private Region<NotificationKey, Notification> localNotificationRegion;

    public Region<String, Object> getLocalMonitoringRegion() {
        return this.localMonitoringRegion;
    }

    public void destroyLocalMonitoringRegion() {
        this.localMonitoringRegion.localDestroyRegion();
        this.localMonitoringRegion = null;
    }

    public void destroyLocalNotifRegion() {
        this.localNotificationRegion.localDestroyRegion();
        this.localNotificationRegion = null;
    }

    public void setLocalMonitoringRegion(Region<String, Object> localMonitoringRegion) {
        this.localMonitoringRegion = localMonitoringRegion;
    }

    public void putEntryInLocalMonitoringRegion(String name, Object data) {
        if (this.localMonitoringRegion != null && !this.localMonitoringRegion.isDestroyed()) {
            this.localMonitoringRegion.put(name, data);
        }
    }

    public void putAllInLocalMonitoringRegion(Map<String, FederationComponent> objectMap) {
        if (this.localMonitoringRegion != null && !this.localMonitoringRegion.isDestroyed()) {
            this.localMonitoringRegion.putAll(objectMap);
        }
    }

    public boolean keyExistsInLocalMonitoringRegion(String key) {
        if (this.localMonitoringRegion != null && !this.localMonitoringRegion.isDestroyed()) {
            return this.localMonitoringRegion.containsKey(key);
        }
        return true;
    }

    public Object getEntryFromLocalMonitoringRegion(ObjectName name) {
        return this.localMonitoringRegion.get(name);
    }

    public Region<NotificationKey, Notification> getLocalNotificationRegion() {
        return this.localNotificationRegion;
    }

    public void setLocalNotificationRegion(Region<NotificationKey, Notification> localNotificationRegion) {
        this.localNotificationRegion = localNotificationRegion;
    }

    public void putEntryInLocalNotificationRegion(NotificationKey key, Notification notif) {
        this.localNotificationRegion.put(key, notif);
    }

    public void putEntryInMonitoringRegionMap(DistributedMember member, Region<String, Object> region) {
        this.monitoringRegionMap.put(member, region);
    }

    public Region<String, Object> getEntryFromMonitoringRegionMap(DistributedMember member) {
        return this.monitoringRegionMap.get(member);
    }

    public void romoveEntryFromMonitoringRegionMap(DistributedMember member) {
        this.monitoringRegionMap.remove(member);
    }

    public Map<DistributedMember, Region<String, Object>> getMonitoringRegionMap() {
        return this.monitoringRegionMap;
    }

    public void putEntryInNotifRegionMap(DistributedMember member, Region<NotificationKey, Notification> region) {
        this.notifRegionMap.put(member, region);
    }

    public Region<NotificationKey, Notification> getEntryFromNotifRegionMap(DistributedMember member) {
        return this.notifRegionMap.get(member);
    }

    public void removeEntryFromNotifRegionMap(DistributedMember member) {
        this.notifRegionMap.remove(member);
    }
}

