/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.ClassLoadUtil;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.MBeanProxyInfoRepository;
import com.gemstone.gemfire.management.internal.MBeanProxyInvocationHandler;
import com.gemstone.gemfire.management.internal.ProxyInfo;
import com.gemstone.gemfire.management.internal.ProxyInterface;
import com.gemstone.gemfire.management.internal.RemoteFilterChain;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import java.beans.IntrospectionException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.apache.logging.log4j.Logger;

public class MBeanProxyFactory {
    private static final Logger logger = LogService.getLogger();
    private MBeanProxyInfoRepository proxyRepo;
    private RemoteFilterChain remoteFilterChain;
    private MBeanJMXAdapter jmxAdapter;
    private SystemManagementService service;

    public MBeanProxyFactory(RemoteFilterChain remoteFilterChain, MBeanJMXAdapter jmxAdapter, SystemManagementService service) {
        this.remoteFilterChain = remoteFilterChain;
        this.jmxAdapter = jmxAdapter;
        this.proxyRepo = new MBeanProxyInfoRepository();
        this.service = service;
    }

    public void createProxy(DistributedMember member, ObjectName objectName, Region<String, Object> monitoringRegion, Object newVal) {
        try {
            if (this.remoteFilterChain.isFiltered(objectName, member, "")) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Returning from filter");
                }
                return;
            }
            Class interfaceClass = ClassLoadUtil.classFromName(((FederationComponent)monitoringRegion.get(objectName.toString())).getMBeanInterfaceClass());
            Object object = MBeanProxyInvocationHandler.newProxyInstance(member, monitoringRegion, objectName, interfaceClass);
            this.jmxAdapter.registerMBeanProxy(object, objectName);
            if (logger.isDebugEnabled()) {
                logger.debug("Registered ObjectName : {}", new Object[]{objectName});
            }
            ProxyInfo proxyInfo = new ProxyInfo(interfaceClass, object, objectName);
            this.proxyRepo.addProxyToRepository(member, proxyInfo);
            this.service.afterCreateProxy(objectName, interfaceClass, object, (FederationComponent)newVal);
            if (logger.isDebugEnabled()) {
                logger.debug("Proxy Created for : {}", new Object[]{objectName});
            }
        }
        catch (ClassNotFoundException e) {
            throw new ManagementException(e);
        }
        catch (IntrospectionException e) {
            throw new ManagementException(e);
        }
        catch (ManagementException e) {
            throw e;
        }
    }

    public void createAllProxies(DistributedMember member, Region<String, Object> monitoringRegion) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating proxy for: {}", new Object[]{member.getId()});
        }
        if (this.remoteFilterChain.isServerGroupFiltered("")) {
            if (logger.isTraceEnabled()) {
                logger.trace("Returning from server group filter");
            }
            return;
        }
        if (this.remoteFilterChain.isManagedNodeFiltered(member)) {
            if (logger.isTraceEnabled()) {
                logger.trace("returning from managed node filter");
            }
            return;
        }
        Set<String> mbeanNames = monitoringRegion.keySet();
        Iterator<String> it = mbeanNames.iterator();
        while (it.hasNext()) {
            ObjectName objectName = null;
            if (this.remoteFilterChain.isRemoteMBeanFiltered(objectName)) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("continue  from remote MBEan node filter");
                continue;
            }
            try {
                objectName = ObjectName.getInstance(it.next());
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating proxy for ObjectName: " + objectName.toString());
                }
                this.createProxy(member, objectName, monitoringRegion, monitoringRegion.get(objectName.toString()));
            }
            catch (ManagementException e) {
                logger.warn("Create Proxy failed for {} with exception {}", new Object[]{objectName, e.getMessage(), e});
            }
            catch (Exception e) {
                logger.warn("Create Proxy failed for {} with exception {}", new Object[]{objectName, e.getMessage(), e});
            }
        }
    }

    public void removeAllProxies(DistributedMember member, Region<String, Object> monitoringRegion) {
        Set<Map.Entry<String, Object>> entries = monitoringRegion.entrySet();
        Iterator<Map.Entry<String, Object>> entriesIt = entries.iterator();
        if (logger.isDebugEnabled()) {
            logger.debug("Removing {} proxies for member {}", new Object[]{entries.size(), member.getId()});
        }
        while (entriesIt.hasNext()) {
            String key = null;
            Object val = null;
            try {
                Map.Entry<String, Object> entry = entriesIt.next();
                key = entry.getKey();
                val = entry.getValue();
                ObjectName mbeanName = ObjectName.getInstance(key);
                this.removeProxy(member, mbeanName, val);
            }
            catch (Exception e) {
                if (e.getCause() instanceof InstanceNotFoundException) continue;
                logger.warn("Remove Proxy failed for {} due to {}", new Object[]{key, e.getMessage(), e});
            }
        }
    }

    public void removeProxy(DistributedMember member, ObjectName objectName, Object oldVal) {
        block6: {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing proxy for ObjectName: {}", new Object[]{objectName});
                }
                if (!this.remoteFilterChain.isRemoteMBeanFiltered(objectName)) {
                    ProxyInfo proxyInfo = this.proxyRepo.findProxyInfo(objectName);
                    this.proxyRepo.removeProxy(member, objectName);
                    if (proxyInfo != null) {
                        this.service.afterRemoveProxy(objectName, proxyInfo.getProxyInterface(), proxyInfo.getProxyInstance(), (FederationComponent)oldVal);
                    }
                    this.jmxAdapter.unregisterMBean(objectName);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Removed proxy for ObjectName: {}", new Object[]{objectName});
                    }
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof InstanceNotFoundException) break block6;
                logger.warn("Could not remove proxy for Member {} due to {}", new Object[]{member, e.getMessage(), e});
            }
        }
    }

    public void updateProxy(ObjectName objectName, ProxyInfo proxyInfo, Object newObject, Object oldObject) {
        try {
            if (proxyInfo != null) {
                Class interfaceClass = proxyInfo.getProxyInterface();
                this.service.afterUpdateProxy(objectName, interfaceClass, proxyInfo.getProxyInstance(), (FederationComponent)newObject, (FederationComponent)oldObject);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    public <T> T findProxy(ObjectName objectName, Class<T> interfaceClass) {
        return this.proxyRepo.findProxyByName(objectName, interfaceClass);
    }

    public ProxyInfo findProxyInfo(ObjectName objectName) {
        return this.proxyRepo.findProxyInfo(objectName);
    }

    public Set<ObjectName> findAllProxies(DistributedMember member) {
        return this.proxyRepo.findProxySet(member);
    }

    public long getLastUpdateTime(ObjectName objectName) {
        ProxyInterface proxyObj = this.findProxy(objectName, ProxyInterface.class);
        return proxyObj.getLastRefreshedTime();
    }
}

