/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.distributed.internal.tcpserver.TcpClient;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;

public class JmxManagerLocatorRequest
implements DataSerializableFixedID {
    private static final JmxManagerLocatorRequest SINGLETON = new JmxManagerLocatorRequest();

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void toData(DataOutput out) throws IOException {
    }

    @Override
    public int getDSFID() {
        return 2150;
    }

    public String toString() {
        return "JmxManagerLocatorRequest";
    }

    public static JmxManagerLocatorResponse send(String locatorHost, int locatorPort, int msTimeout, Map<String, String> sslConfigProps) throws IOException {
        Properties distributionConfigProps = new Properties();
        InetAddress networkAddress = InetAddress.getByName(locatorHost);
        try {
            if (sslConfigProps != null) {
                distributionConfigProps.putAll(sslConfigProps);
            }
            Object responseFromServer = TcpClient.requestToServer(networkAddress, locatorPort, SINGLETON, msTimeout);
            JmxManagerLocatorResponse jmxManagerLocatorResponse = (JmxManagerLocatorResponse)responseFromServer;
            return jmxManagerLocatorResponse;
        }
        catch (ClassNotFoundException unexpected) {
            throw new IllegalStateException(unexpected);
        }
        catch (ClassCastException unexpected) {
            throw new IllegalStateException(unexpected);
        }
        finally {
            distributionConfigProps.clear();
        }
    }

    public static JmxManagerLocatorResponse send(String locatorHost, int locatorPort, int msTimeout) throws IOException {
        return JmxManagerLocatorRequest.send(locatorHost, locatorPort, msTimeout, null);
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

