/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.File;
import java.net.URL;
import org.apache.logging.log4j.Logger;

public class AgentUtil {
    private static final Logger logger = LogService.getLogger();
    public static final String ERROR_VARIABLE_NOT_SET = "The GEMFIRE environment variable must be set!";
    private String gemfireVersion = null;

    public AgentUtil(String gemfireVersion) {
        this.gemfireVersion = gemfireVersion;
    }

    public String findWarLocation(String warFilePrefix) {
        String[] possibleFiles;
        String gemfireHome = this.getGemFireHome();
        if (!StringUtils.isBlank(gemfireHome)) {
            for (String possibleFile : possibleFiles = new String[]{gemfireHome + "/tools/Extensions/" + warFilePrefix + "-" + this.gemfireVersion + ".war", gemfireHome + "/tools/Pulse/" + warFilePrefix + "-" + this.gemfireVersion + ".war", gemfireHome + "/lib/" + warFilePrefix + "-" + this.gemfireVersion + ".war", gemfireHome + "/tools/Extensions/" + warFilePrefix + ".war", gemfireHome + "/tools/Pulse/" + warFilePrefix + ".war", gemfireHome + "/lib/" + warFilePrefix + ".war"}) {
                if (!new File(possibleFile).isFile()) continue;
                logger.info(warFilePrefix + " war found: {}", new Object[]{possibleFile});
                return possibleFile;
            }
        }
        for (String possibleFile : possibleFiles = new String[]{warFilePrefix + "-" + this.gemfireVersion + ".war", "tools/Pulse/" + warFilePrefix + "-" + this.gemfireVersion + ".war", "tools/Extensions/" + warFilePrefix + "-" + this.gemfireVersion + ".war", "lib/" + warFilePrefix + "-" + this.gemfireVersion + ".war", warFilePrefix + ".war"}) {
            URL url = this.getClass().getClassLoader().getResource(possibleFile);
            if (url == null) continue;
            logger.info(warFilePrefix + " war found: {}", new Object[]{possibleFile});
            return url.getPath();
        }
        logger.warn(warFilePrefix + " war file was not found");
        return null;
    }

    public boolean isWebApplicationAvailable(String warFileLocation) {
        return !StringUtils.isBlank(warFileLocation);
    }

    public boolean isWebApplicationAvailable(String ... warFileLocations) {
        for (String warFileLocation : warFileLocations) {
            if (!this.isWebApplicationAvailable(warFileLocation)) continue;
            return true;
        }
        return false;
    }

    public String getGemFireHome() {
        String gemFireHome = System.getenv("GEMFIRE");
        logger.info("GEMFIRE HOME:" + gemFireHome);
        if (StringUtils.isBlank(gemFireHome)) {
            gemFireHome = System.getProperty("gemfire.home");
            logger.info("Reading gemfire.home System Property -> {}", new Object[]{gemFireHome});
            if (StringUtils.isBlank(gemFireHome)) {
                logger.info("GEMFIRE environment variable not set; HTTP service will not start.");
                gemFireHome = null;
            }
        }
        return gemFireHome;
    }

    public boolean isGemfireHomeDefined() {
        String gemfireHome = this.getGemFireHome();
        return !StringUtils.isBlank(gemfireHome);
    }
}

