/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.management.DiskBackupStatus;
import com.gemstone.gemfire.management.DiskMetrics;
import com.gemstone.gemfire.management.GemFireProperties;
import com.gemstone.gemfire.management.JVMMetrics;
import com.gemstone.gemfire.management.NetworkMetrics;
import com.gemstone.gemfire.management.OSMetrics;
import com.gemstone.gemfire.management.PersistentMemberDetails;
import com.gemstone.gemfire.management.internal.security.Resource;
import com.gemstone.gemfire.management.internal.security.ResourceOperation;
import java.util.Map;
import javax.management.ObjectName;

public interface DistributedSystemMXBean {
    public int getDistributedSystemId();

    public int getMemberCount();

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM)
    public String[] listMembers();

    public String[] listLocatorMembers(boolean var1);

    public String[] listGroups();

    public int getLocatorCount();

    public String[] listLocators();

    public int getSystemDiskStoreCount();

    public Map<String, String[]> listMemberDiskstore();

    public Map<String, String[]> listMemberHDFSStore();

    public String[] listGatewaySenders();

    public String[] listGatewayReceivers();

    public String getAlertLevel();

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="CHANGE_ALERT_LEVEL_DS")
    public void changeAlertLevel(String var1) throws Exception;

    public long getTotalHeapSize();

    public long getTotalRegionEntryCount();

    public int getTotalRegionCount();

    public int getTotalMissCount();

    public int getTotalHitCount();

    public int getNumClients();

    public float getDiskReadsRate();

    public float getDiskWritesRate();

    public long getDiskFlushAvgLatency();

    public int getTotalBackupInProgress();

    public int getNumInitialImagesInProgress();

    public long getActiveCQCount();

    public float getQueryRequestRate();

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="BACKUP_DS")
    public DiskBackupStatus backupAllMembers(String var1, String var2) throws Exception;

    public GemFireProperties fetchMemberConfiguration(String var1) throws Exception;

    public long fetchMemberUpTime(String var1) throws Exception;

    public String[] listCacheServers();

    public String[] listServers();

    public JVMMetrics showJVMMetrics(String var1) throws Exception;

    public OSMetrics showOSMetrics(String var1) throws Exception;

    public NetworkMetrics showNetworkMetric(String var1) throws Exception;

    public DiskMetrics showDiskMetrics(String var1) throws Exception;

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="SHUTDOWN_DS")
    public String[] shutDownAllMembers() throws Exception;

    public String[] listRegions();

    public String[] listAllRegionPaths();

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="REMOVE_DISKSTORE_DS")
    public boolean revokeMissingDiskStores(String var1) throws Exception;

    public PersistentMemberDetails[] listMissingDiskStores();

    public ObjectName getMemberObjectName();

    public ObjectName getManagerObjectName();

    public ObjectName[] listMemberObjectNames();

    public ObjectName fetchMemberObjectName(String var1) throws Exception;

    public ObjectName[] fetchRegionObjectNames(ObjectName var1) throws Exception;

    public ObjectName[] listDistributedRegionObjectNames();

    public ObjectName fetchDistributedRegionObjectName(String var1) throws Exception;

    public ObjectName fetchRegionObjectName(String var1, String var2) throws Exception;

    public ObjectName fetchGatewaySenderObjectName(String var1, String var2) throws Exception;

    public ObjectName fetchGatewayReceiverObjectName(String var1) throws Exception;

    public ObjectName[] listGatewaySenderObjectNames();

    public ObjectName[] listGatewaySenderObjectNames(String var1) throws Exception;

    public ObjectName[] listGatewayReceiverObjectNames();

    public ObjectName fetchDistributedLockServiceObjectName(String var1) throws Exception;

    public ObjectName fetchLockServiceObjectName(String var1, String var2) throws Exception;

    public ObjectName fetchDiskStoreObjectName(String var1, String var2) throws Exception;

    public ObjectName fetchCacheServerObjectName(String var1, int var2) throws Exception;

    public ObjectName[] listCacheServerObjectNames();

    public int getNumRunningFunctions();

    public long getRegisteredCQCount();

    public long getTotalDiskUsage();

    public long getUsedHeapSize();

    public float getAverageReads();

    public float getAverageWrites();

    public int getNumSubscriptions();

    public long getGarbageCollectionCount();

    public Map<String, Boolean> viewRemoteClusterStatus();

    public long getJVMPauses();

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="QUERYDATA_DS")
    public String queryData(String var1, String var2, int var3) throws Exception;

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="QUERYDATA_DS")
    public byte[] queryDataForCompressedResult(String var1, String var2, int var3) throws Exception;

    public int getTransactionCommitted();

    public int getTransactionRolledBack();

    public int getQueryResultSetLimit();

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="QUERYDATA_DS")
    public void setQueryResultSetLimit(int var1);

    public int getQueryCollectionsDepth();

    @ResourceOperation(resource=Resource.DISTRIBUTED_SYSTEM, operation="QUERYDATA_DS")
    public void setQueryCollectionsDepth(int var1);
}

