/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util.concurrent;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCountDownLatch;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureResult
implements Future {
    private final StoppableCountDownLatch latch;
    private Object value;
    private volatile boolean isCancelled = false;

    public FutureResult(CancelCriterion crit) {
        this.latch = new StoppableCountDownLatch(crit, 1);
    }

    public FutureResult(Object value) {
        this.value = value;
        this.latch = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled) {
            return false;
        }
        this.isCancelled = true;
        if (this.latch != null) {
            this.latch.countDown();
        }
        return true;
    }

    public Object get() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.latch != null) {
            this.latch.await();
        }
        if (this.isCancelled) {
            throw new CancellationException(LocalizedStrings.FutureResult_FUTURE_WAS_CANCELLED.toLocalizedString());
        }
        return this.value;
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.latch != null && !this.latch.await(unit.toMillis(timeout))) {
            throw new TimeoutException();
        }
        return this.value;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch == null || this.latch.getCount() == 0L || this.isCancelled;
    }

    public void set(Object value) {
        this.value = value;
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

