/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util.concurrent;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CustomEntryConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = -7056732555635108300L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    private static final Object NO_OBJECT_TOKEN = new Object();
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    final HashEntryCreator<K, V> entryCreator;
    final boolean compareValues;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Set<Map.Entry<K, V>> reusableEntrySet;
    transient Collection<V> values;

    public static final int keyHash(Object o, boolean compareValues) {
        int h = compareValues ? o.hashCode() : System.identityHashCode(o);
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment<K, V> segmentFor(int hash) {
        if (this.segmentMask == 0) {
            return this.segments[0];
        }
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public CustomEntryConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this(initialCapacity, loadFactor, concurrencyLevel, false, null);
    }

    public CustomEntryConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, boolean isIdentityMap) {
        this(initialCapacity, loadFactor, concurrencyLevel, isIdentityMap, null);
    }

    public CustomEntryConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, boolean isIdentityMap, HashEntryCreator<K, V> entryCreator) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        if (concurrencyLevel > 1) {
            for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
                ++sshift;
            }
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        if (entryCreator == null) {
            entryCreator = new DefaultHashEntryCreator();
        }
        if (!isIdentityMap) {
            this.compareValues = true;
            this.segments = Segment.newArray(ssize);
            this.entryCreator = entryCreator;
            for (int i = 0; i < ssize; ++i) {
                this.segments[i] = new Segment<K, V>(cap, loadFactor, entryCreator);
            }
        } else {
            this.compareValues = false;
            this.segments = IdentitySegment.newArray(ssize);
            this.entryCreator = entryCreator;
            for (int i = 0; i < ssize; ++i) {
                this.segments[i] = new IdentitySegment<K, V>(cap, loadFactor, entryCreator);
            }
        }
    }

    public CustomEntryConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16, false);
    }

    public CustomEntryConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16, false);
    }

    public CustomEntryConcurrentHashMap() {
        this(16, 0.75f, 16, false);
    }

    public CustomEntryConcurrentHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, 16, false);
        this.putAll(m);
    }

    @Override
    public final boolean isEmpty() {
        int i;
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="The lock() calls are followed by unlock() calls without finally-block. Leaving this as is because it's lifted from JDK code and we want to minimize changes.")
    public final int size() {
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            int i;
            sum = 0L;
            for (i = 0; i < segments.length; ++i) {
                segments[i].readLock().lock();
            }
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].readLock().unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    @Override
    public final V get(Object key) {
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public final boolean containsKey(Object key) {
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="Leaving this as is because it's lifted from JDK code and we want to minimize changes.")
    public final boolean containsValue(Object value) {
        int i;
        if (value == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int mcsum = 0;
            for (int i2 = 0; i2 < segments.length; ++i2) {
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
                if (!segments[i2].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i3 = 0; i3 < segments.length; ++i3) {
                    if (mc[i3] == segments[i3].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (int i4 = 0; i4 < segments.length; ++i4) {
            segments[i4].readLock().lock();
        }
        boolean found = false;
        try {
            for (i = 0; i < segments.length; ++i) {
                if (!segments[i].containsValue(value)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (i = 0; i < segments.length; ++i) {
                segments[i].readLock().unlock();
            }
        }
        return found;
    }

    public final boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public final V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    public final boolean create(K key, V value) {
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        Segment<K, V> seg = this.segmentFor(hash);
        if (seg.containsKey(key, hash)) {
            return false;
        }
        return seg.put(key, hash, value, true) == null;
    }

    public final <C, P> V create(K key, MapCallback<K, V, C, P> valueCreator, C context, P createParams, boolean lockForRead) {
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).create(key, hash, valueCreator, context, createParams, lockForRead);
    }

    public final V get(Object key, MapCallback<K, V, ?, ?> readCallback) {
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).get(key, hash, readCallback);
    }

    public final <C, P> V removeConditionally(Object key, MapCallback<K, V, C, P> condition, C context, P removeParams) {
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).remove(key, hash, NO_OBJECT_TOKEN, condition, context, removeParams);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public final V remove(Object key) {
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).remove(key, hash, NO_OBJECT_TOKEN, null, null, null);
    }

    @Override
    public final boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).remove(key, hash, value, null, null, null) != null;
    }

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public final V replace(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = this.entryCreator.keyHashCode(key, this.compareValues);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        block16: {
            ArrayList<HashEntry<?, ?>> clearedEntries;
            ArrayList<HashEntry<?, ?>> entries = null;
            try {
                for (int i = 0; i < this.segments.length; ++i) {
                    entries = this.segments[i].clear(entries);
                }
                if (entries == null) break block16;
                clearedEntries = entries;
            }
            catch (Throwable throwable) {
                if (entries != null) {
                    ArrayList<HashEntry<?, ?>> clearedEntries2 = entries;
                    Runnable runnable = new Runnable(clearedEntries2){
                        final /* synthetic */ ArrayList val$clearedEntries;
                        {
                            this.val$clearedEntries = arrayList;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Iterator iterator = this.val$clearedEntries.iterator();
                            while (iterator.hasNext()) {
                                HashEntry he;
                                for (HashEntry p = he = (HashEntry)iterator.next(); p != null; p = p.getNextEntry()) {
                                    HashEntry hashEntry = p;
                                    synchronized (hashEntry) {
                                        ((OffHeapRegionEntry)((Object)p)).release();
                                        continue;
                                    }
                                }
                            }
                        }
                    };
                    boolean submitted = false;
                    InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
                    if (ids != null) {
                        try {
                            ids.getDistributionManager().getWaitingThreadPool().submit(runnable);
                            submitted = true;
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                        }
                        catch (CancelException cancelException) {
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    if (!submitted) {
                        String name = this.getClass().getSimpleName() + "@" + this.hashCode() + " Clear Thread";
                        Thread thread = new Thread(runnable, name);
                        thread.setDaemon(true);
                        thread.start();
                    }
                }
                throw throwable;
            }
            Runnable runnable = new /* invalid duplicate definition of identical inner class */;
            boolean submitted = false;
            InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
            if (ids != null) {
                try {
                    ids.getDistributionManager().getWaitingThreadPool().submit(runnable);
                    submitted = true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                }
                catch (CancelException cancelException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (!submitted) {
                String name = this.getClass().getSimpleName() + "@" + this.hashCode() + " Clear Thread";
                Thread thread = new Thread(runnable, name);
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    @Override
    public final Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public final Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(false));
    }

    public final Set<Map.Entry<K, V>> entrySetWithReusableEntries() {
        EntrySet es = this.reusableEntrySet;
        return es != null ? es : (this.reusableEntrySet = new EntrySet(true));
    }

    public final Enumeration<K> keys() {
        return new KeyIterator();
    }

    public final Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int k = 0; k < this.segments.length; ++k) {
            Segment<K, V> seg = this.segments[k];
            ReentrantReadWriteLock.ReadLock readLock = seg.readLock();
            readLock.lock();
            try {
                HashEntry<K, V>[] tab = seg.table;
                for (int i = 0; i < tab.length; ++i) {
                    for (HashEntry e = tab[i]; e != null; e = e.getNextEntry()) {
                        s.writeObject(e.getKey());
                        s.writeObject(e.getMapValue());
                    }
                }
                continue;
            }
            finally {
                readLock.unlock();
            }
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setTable(new HashEntry[1]);
        }
        while (true) {
            Object key = s.readObject();
            Object value = s.readObject();
            if (key == null) break;
            this.put(key, value);
        }
    }

    public long estimateMemoryOverhead(SingleObjectSizer sizer) {
        long totalOverhead = sizer.sizeof(this);
        for (int i = 0; i < this.segments.length; ++i) {
            Segment<K, V> seg = this.segments[i];
            totalOverhead += sizer.sizeof(seg);
        }
        return totalOverhead;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final WriteThroughEntry reusableEntry;

        EntrySet(boolean useReusableEntry) {
            this.reusableEntry = useReusableEntry ? new WriteThroughEntry(null, null) : null;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.reusableEntry);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = CustomEntryConcurrentHashMap.this.get(e.getKey());
            if (CustomEntryConcurrentHashMap.this.compareValues) {
                return v != null && v.equals(e.getValue());
            }
            return v == e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return CustomEntryConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return CustomEntryConcurrentHashMap.this.size();
        }

        @Override
        public void clear() {
            CustomEntryConcurrentHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CustomEntryConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return CustomEntryConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            CustomEntryConcurrentHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CustomEntryConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return CustomEntryConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CustomEntryConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            CustomEntryConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        final WriteThroughEntry reusableEntry;

        EntryIterator(WriteThroughEntry reusableEntry) {
            this.reusableEntry = reusableEntry;
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry e = super.nextEntry();
            if (this.reusableEntry != null) {
                this.reusableEntry.key = e.getKey();
                this.reusableEntry.setValue(e.getMapValue());
                return this.reusableEntry;
            }
            return new WriteThroughEntry(e.getKey(), e.getMapValue());
        }
    }

    final class WriteThroughEntry
    extends SimpleReusableEntry {
        private static final long serialVersionUID = -6364816773849437756L;

        WriteThroughEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value);
            CustomEntryConcurrentHashMap.this.put(this.getKey(), value);
            return v;
        }
    }

    public class SimpleReusableEntry
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1591026397367910439L;
        protected K key;
        private V value;

        public SimpleReusableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleReusableEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (CustomEntryConcurrentHashMap.this.compareValues) {
                return ArrayUtils.objectEquals(this.key, e.getKey()) && ArrayUtils.objectEquals(this.value, e.getValue());
            }
            return this.key == e.getKey() && this.value == e.getValue();
        }

        @Override
        public int hashCode() {
            if (CustomEntryConcurrentHashMap.this.compareValues) {
                return (this.key != null ? this.key.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
            }
            return System.identityHashCode(this.key) ^ System.identityHashCode(this.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().getMapValue();
        }

        @Override
        public V nextElement() {
            return super.nextEntry().getMapValue();
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }

        @Override
        public K nextElement() {
            return super.nextEntry().getKey();
        }
    }

    abstract class HashIterator {
        int currentSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;
        final ArrayList<HashEntry<K, V>> currentList;
        int currentListIndex;

        HashIterator() {
            this.currentSegmentIndex = CustomEntryConcurrentHashMap.this.segments.length;
            this.nextTableIndex = -1;
            this.currentList = new ArrayList(5);
            this.currentListIndex = 0;
            this.advance();
        }

        public final boolean hasMoreElements() {
            return this.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void advance() {
            ReentrantReadWriteLock.ReadLock listLock;
            Segment seg;
            if (this.currentListIndex < this.currentList.size()) {
                this.nextEntry = this.currentList.get(this.currentListIndex++);
                return;
            }
            this.nextEntry = null;
            if (this.nextTableIndex >= 0) {
                seg = CustomEntryConcurrentHashMap.this.segments[this.currentSegmentIndex];
                listLock = seg.listUpdateLock.readLock();
                listLock.lock();
                try {
                    do {
                        if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                        this.copyEntriesToList();
                        return;
                    } while (this.nextTableIndex >= 0);
                }
                finally {
                    listLock.unlock();
                }
            }
            while (this.currentSegmentIndex > 0) {
                seg = CustomEntryConcurrentHashMap.this.segments[--this.currentSegmentIndex];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                listLock = seg.listUpdateLock.readLock();
                listLock.lock();
                try {
                    for (int j = this.currentTable.length - 1; j >= 0; --j) {
                        this.nextEntry = this.currentTable[j];
                        if (this.nextEntry == null) continue;
                        this.nextTableIndex = j - 1;
                        this.copyEntriesToList();
                        return;
                    }
                }
                finally {
                    listLock.unlock();
                }
            }
        }

        private final void copyEntriesToList() {
            assert (CustomEntryConcurrentHashMap.this.segments[this.currentSegmentIndex] != null) : "unexpected null currentSegment";
            assert (CustomEntryConcurrentHashMap.this.segments[this.currentSegmentIndex].listUpdateLock.getReadLockCount() > 0);
            this.currentList.clear();
            this.currentListIndex = 0;
            for (HashEntry p = this.nextEntry.getNextEntry(); p != null; p = p.getNextEntry()) {
                this.currentList.add(p);
            }
        }

        public final boolean hasNext() {
            return this.nextEntry != null;
        }

        final HashEntry<K, V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            CustomEntryConcurrentHashMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    public static class MapCallbackAdapter<K, V, C, P>
    implements MapCallback<K, V, C, P> {
        @Override
        public V newValue(K key, C context, P createParams) {
            return null;
        }

        @Override
        public void oldValueRead(V value) {
        }

        @Override
        public boolean doRemoveValue(V value, C context, P removeParams) {
            return true;
        }
    }

    public static interface MapCallback<K, V, C, P> {
        public V newValue(K var1, C var2, P var3);

        public void oldValueRead(V var1);

        public boolean doRemoveValue(V var1, C var2, P var3);
    }

    static final class DefaultHashEntryCreator<K, V>
    implements HashEntryCreator<K, V>,
    Serializable {
        private static final long serialVersionUID = 3765680607280951726L;

        DefaultHashEntryCreator() {
        }

        @Override
        public final HashEntry<K, V> newEntry(K key, int hash, HashEntry<K, V> next, V value) {
            return new HashEntryImpl<K, V>(key, hash, next, value, null);
        }

        @Override
        public final int keyHashCode(Object key, boolean compareValues) {
            return CustomEntryConcurrentHashMap.keyHash(key, compareValues);
        }
    }

    static final class IdentitySegment<K, V>
    extends Segment<K, V>
    implements Serializable {
        private static final long serialVersionUID = 3086228147110819882L;

        IdentitySegment(int initialCapacity, float lf, HashEntryCreator<K, V> entryCreator) {
            super(initialCapacity, lf, entryCreator);
        }

        static final <K, V> IdentitySegment<K, V>[] newArray(int i) {
            return new IdentitySegment[i];
        }

        @Override
        protected final boolean equalityKeyCompare(Object key, HashEntry<K, V> mapEntry) {
            return key == mapEntry.getKey();
        }

        @Override
        protected final boolean equalityCompare(Object key, Object mapKey) {
            return key == mapKey;
        }

        @Override
        protected final boolean equalityCompareWithNulls(Object key, Object mapKey) {
            return key == mapKey;
        }
    }

    static class Segment<K, V>
    extends ReentrantReadWriteLock
    implements Serializable {
        private static final long serialVersionUID = -6972364566212065192L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;
        final HashEntryCreator<K, V> entryCreator;
        final ReentrantReadWriteLock listUpdateLock;

        Segment(int initialCapacity, float lf, HashEntryCreator<K, V> entryCreator) {
            this.loadFactor = lf;
            this.entryCreator = entryCreator;
            this.listUpdateLock = new ReentrantReadWriteLock();
            this.setTable(Segment.newEntryArray(initialCapacity));
        }

        static <K, V> Segment<K, V>[] newArray(int i) {
            return new Segment[i];
        }

        static <K, V> HashEntry<K, V>[] newEntryArray(int size) {
            return new HashEntry[size];
        }

        final void setTable(HashEntry<K, V>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        final HashEntry<K, V> getFirst(int hash) {
            HashEntry<K, V>[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        final V readValueUnderLock(HashEntry<K, V> e) {
            ReentrantReadWriteLock.ReadLock readLock = super.readLock();
            readLock.lock();
            V v = e.getMapValue();
            readLock.unlock();
            return v;
        }

        protected boolean equalityKeyCompare(Object key, HashEntry<K, V> mapEntry) {
            return mapEntry.isKeyEqual(key);
        }

        protected boolean equalityCompare(Object v1, Object v2) {
            return v1.equals(v2);
        }

        protected boolean equalityCompareWithNulls(Object key, Object mapKey) {
            if (key != mapKey) {
                if (key != null) {
                    return key.equals(mapKey);
                }
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V get(Object key, int hash) {
            if (this.count != 0) {
                ReentrantReadWriteLock.ReadLock listLock = this.listUpdateLock.readLock();
                listLock.lock();
                boolean lockAcquired = true;
                try {
                    for (HashEntry<K, V> e = this.getFirst(hash); e != null; e = e.getNextEntry()) {
                        if (e.getEntryHash() != hash || !this.equalityKeyCompare(key, e)) continue;
                        V v = e.getMapValue();
                        if (v != null) {
                            V v2 = v;
                            return v2;
                        }
                        listLock.unlock();
                        lockAcquired = false;
                        V v3 = this.readValueUnderLock(e);
                        return v3;
                    }
                }
                finally {
                    if (lockAcquired) {
                        listLock.unlock();
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V getNoLock(Object key, int hash, boolean lockListForRead) {
            if (this.count != 0) {
                ReentrantReadWriteLock.ReadLock listLock = null;
                if (lockListForRead) {
                    listLock = this.listUpdateLock.readLock();
                    listLock.lock();
                }
                try {
                    for (HashEntry<K, V> e = this.getFirst(hash); e != null; e = e.getNextEntry()) {
                        if (e.getEntryHash() != hash || !this.equalityKeyCompare(key, e)) continue;
                        V v = e.getMapValue();
                        return v;
                    }
                }
                finally {
                    if (lockListForRead) {
                        listLock.unlock();
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                ReentrantReadWriteLock.ReadLock listLock = this.listUpdateLock.readLock();
                listLock.lock();
                try {
                    for (HashEntry<K, V> e = this.getFirst(hash); e != null; e = e.getNextEntry()) {
                        if (e.getEntryHash() != hash || !this.equalityKeyCompare(key, e)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    listLock.unlock();
                }
            }
            return false;
        }

        final boolean containsValue(Object value) {
            if (this.count != 0) {
                ReentrantReadWriteLock.ReadLock readLock = this.listUpdateLock.readLock();
                block0: while (true) {
                    readLock.lock();
                    HashEntry<K, V>[] tab = this.table;
                    int len = tab.length;
                    for (int i = 0; i < len; ++i) {
                        for (HashEntry<K, V> e = tab[i]; e != null; e = e.getNextEntry()) {
                            V v = e.getMapValue();
                            if (v == null) {
                                readLock.unlock();
                                readLock = super.readLock();
                                continue block0;
                            }
                            if (!this.equalityCompare(value, v)) continue;
                            readLock.unlock();
                            return true;
                        }
                    }
                    break;
                }
                readLock.unlock();
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean replace(K key, int hash, V oldValue, V newValue) {
            ReentrantReadWriteLock.WriteLock writeLock = super.writeLock();
            writeLock.lock();
            try {
                HashEntry<K, V> e;
                for (e = this.getFirst(hash); !(e == null || e.getEntryHash() == hash && this.equalityKeyCompare(key, e)); e = e.getNextEntry()) {
                }
                boolean replaced = false;
                if (e != null && this.equalityCompare(oldValue, e.getMapValue())) {
                    replaced = true;
                    e.setMapValue(newValue);
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V replace(K key, int hash, V newValue) {
            ReentrantReadWriteLock.WriteLock writeLock = super.writeLock();
            writeLock.lock();
            try {
                HashEntry<K, V> e;
                for (e = this.getFirst(hash); !(e == null || e.getEntryHash() == hash && this.equalityKeyCompare(key, e)); e = e.getNextEntry()) {
                }
                V oldValue = null;
                if (e != null) {
                    oldValue = e.getMapValue();
                    e.setMapValue(newValue);
                }
                V v = oldValue;
                return v;
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V put(K key, int hash, V value, boolean onlyIfAbsent) {
            ReentrantReadWriteLock.WriteLock writeLock = super.writeLock();
            writeLock.lock();
            try {
                V oldValue;
                HashEntry<K, V> first;
                HashEntry<K, V> e;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                for (e = first = tab[index]; !(e == null || e.getEntryHash() == hash && this.equalityKeyCompare(key, e)); e = e.getNextEntry()) {
                }
                if (e != null) {
                    oldValue = e.getMapValue();
                    if (!onlyIfAbsent) {
                        e.setMapValue(value);
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = this.entryCreator.newEntry(key, hash, first, value);
                    this.count = c;
                }
                V v = oldValue;
                return v;
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final <C, P> V create(K key, int hash, MapCallback<K, V, C, P> valueCreator, C context, P createParams, boolean lockForRead) {
            if (!lockForRead) {
                V v = this.getNoLock(key, hash, true);
                if (v != null) {
                    return v;
                }
            } else {
                ReentrantReadWriteLock.ReadLock readLock = super.readLock();
                readLock.lock();
                try {
                    V v = this.getNoLock(key, hash, false);
                    if (v != null) {
                        valueCreator.oldValueRead(v);
                        V v2 = v;
                        return v2;
                    }
                }
                finally {
                    readLock.unlock();
                }
            }
            ReentrantReadWriteLock.WriteLock writeLock = super.writeLock();
            writeLock.lock();
            try {
                HashEntry<K, V> first;
                HashEntry<K, V> e;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                for (e = first = tab[index]; !(e == null || e.getEntryHash() == hash && this.equalityKeyCompare(key, e)); e = e.getNextEntry()) {
                }
                if (e == null) {
                    ++this.modCount;
                    V currentValue = valueCreator.newValue(key, context, createParams);
                    tab[index] = this.entryCreator.newEntry(key, hash, first, currentValue);
                    this.count = c;
                    V v = currentValue;
                    return v;
                }
                V currentValue = e.getMapValue();
                if (lockForRead) {
                    valueCreator.oldValueRead(currentValue);
                }
                V v = currentValue;
                return v;
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V get(Object key, int hash, MapCallback<K, V, ?, ?> readCallback) {
            ReentrantReadWriteLock.ReadLock readLock = super.readLock();
            readLock.lock();
            try {
                if (this.count != 0) {
                    for (HashEntry<K, V> e = this.getFirst(hash); e != null; e = e.getNextEntry()) {
                        V v;
                        if (e.getEntryHash() != hash || !this.equalityKeyCompare(key, e) || (v = e.getMapValue()) == null) continue;
                        if (readCallback != null) {
                            readCallback.oldValueRead(v);
                        }
                        V v2 = v;
                        return v2;
                    }
                }
            }
            finally {
                readLock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void rehash() {
            HashEntry<K, V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry<K, V>[] newTable = Segment.newEntryArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                HashEntry<K, V> nextp;
                HashEntry<K, V> e = oldTable[i];
                if (e == null) continue;
                HashEntry<K, V> next = e.getNextEntry();
                int idx = e.getEntryHash() & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry<K, V> lastRun = e;
                int lastIdx = idx;
                for (HashEntry<K, V> last = next; last != null; last = last.getNextEntry()) {
                    int k = last.getEntryHash() & sizeMask;
                    if (k == lastIdx) continue;
                    lastIdx = k;
                    lastRun = last;
                }
                newTable[lastIdx] = lastRun;
                HashEntryImpl<K, V> newp = null;
                HashEntryImpl<K, V> newFirst = null;
                HashEntry<K, V> p = e;
                while (p != null) {
                    nextp = p.getNextEntry();
                    HashEntryImpl<K, V> newe = new HashEntryImpl<K, V>(p.getKey(), p.getEntryHash(), nextp, p.getMapValue(), p);
                    if (newp != null) {
                        newp.setNextEntry(newe);
                    } else {
                        newFirst = newe;
                    }
                    newp = newe;
                    p = nextp;
                }
                ReentrantReadWriteLock.WriteLock listWriteLock = this.listUpdateLock.writeLock();
                listWriteLock.lock();
                try {
                    if (newFirst != null) {
                        this.table[i] = newFirst;
                    }
                    HashEntry<K, V> p2 = e;
                    while (p2 != lastRun) {
                        int k = p2.getEntryHash() & sizeMask;
                        HashEntry<K, V> n = newTable[k];
                        nextp = p2.getNextEntry();
                        p2.setNextEntry(n);
                        newTable[k] = p2;
                        p2 = nextp;
                    }
                    continue;
                }
                finally {
                    listWriteLock.unlock();
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final <C, P> V remove(Object key, int hash, Object value, MapCallback<K, V, C, P> condition, C context, P removeParams) {
            ReentrantReadWriteLock.WriteLock writeLock = super.writeLock();
            writeLock.lock();
            try {
                HashEntry<K, V> first;
                HashEntry<K, V> e;
                int c = this.count - 1;
                HashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<K, V> p = null;
                for (e = first = tab[index]; !(e == null || e.getEntryHash() == hash && this.equalityKeyCompare(key, e)); e = e.getNextEntry()) {
                    if (p == null) {
                        p = first;
                        continue;
                    }
                    p = p.getNextEntry();
                }
                V oldValue = null;
                if (e != null) {
                    V v = e.getMapValue();
                    if ((value == NO_OBJECT_TOKEN || this.equalityCompareWithNulls(v, value)) && (condition == null || condition.doRemoveValue(v, context, removeParams))) {
                        oldValue = v;
                        ++this.modCount;
                        ReentrantReadWriteLock.WriteLock listWriteLock = this.listUpdateLock.writeLock();
                        listWriteLock.lock();
                        try {
                            if (p == null) {
                                tab[index] = e.getNextEntry();
                            } else {
                                p.setNextEntry(e.getNextEntry());
                            }
                        }
                        finally {
                            listWriteLock.unlock();
                        }
                        this.count = c;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final ArrayList<HashEntry<?, ?>> clear(ArrayList<HashEntry<?, ?>> clearedEntries) {
            if (this.count != 0) {
                ReentrantReadWriteLock.WriteLock writeLock = super.writeLock();
                writeLock.lock();
                try {
                    boolean skipProcessOffHeap;
                    boolean collectEntries;
                    Object[] tab = this.table;
                    boolean bl = collectEntries = clearedEntries != null;
                    if (!collectEntries) {
                        for (Object he : tab) {
                            if (he == null) continue;
                            collectEntries = he instanceof OffHeapRegionEntry;
                            if (!collectEntries) break;
                            clearedEntries = new ArrayList();
                            break;
                        }
                    }
                    boolean checkForGatewaySenderEvent = OffHeapRegionEntryHelper.doesClearNeedToCheckForOffHeap();
                    boolean bl2 = skipProcessOffHeap = !collectEntries && !checkForGatewaySenderEvent;
                    if (skipProcessOffHeap) {
                        Arrays.fill(tab, null);
                    } else {
                        for (int i = 0; i < tab.length; ++i) {
                            Object he;
                            he = tab[i];
                            if (he == null) continue;
                            tab[i] = null;
                            if (collectEntries) {
                                clearedEntries.add((HashEntry<Object, Object>)he);
                                continue;
                            }
                            for (HashEntry p = he; p != null; p = p.getNextEntry()) {
                                if (!(p instanceof RegionEntry)) continue;
                                GatewaySenderEventImpl.release(((RegionEntry)((Object)p))._getValue());
                            }
                        }
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    writeLock.unlock();
                }
            }
            return clearedEntries;
        }
    }

    public static interface HashEntryCreator<K, V> {
        public HashEntry<K, V> newEntry(K var1, int var2, HashEntry<K, V> var3, V var4);

        public int keyHashCode(Object var1, boolean var2);
    }

    static final class HashEntryImpl<K, V>
    implements HashEntry<K, V> {
        protected final K key;
        protected final int hash;
        protected volatile V value;
        protected HashEntry<K, V> next;
        private final HashEntry<K, V> wrappedEntry;

        HashEntryImpl(K key, int hash, HashEntry<K, V> next, V value, HashEntry<K, V> wrappedEntry) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
            this.wrappedEntry = wrappedEntry;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getMapValue() {
            return this.value;
        }

        @Override
        public final void setMapValue(V newValue) {
            this.value = newValue;
        }

        @Override
        public final int getEntryHash() {
            return this.hash;
        }

        @Override
        public final HashEntry<K, V> getNextEntry() {
            return this.next;
        }

        @Override
        public final void setNextEntry(HashEntry<K, V> n) {
            this.next = n;
        }

        @Override
        public boolean isKeyEqual(Object k) {
            return k.equals(this.getKey());
        }
    }

    public static interface HashEntry<K, V> {
        public K getKey();

        public boolean isKeyEqual(Object var1);

        public V getMapValue();

        public void setMapValue(V var1);

        public int getEntryHash();

        public HashEntry<K, V> getNextEntry();

        public void setNextEntry(HashEntry<K, V> var1);
    }
}

