/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tcp;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.ObjToByteArraySerializer;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.tcp.Connection;
import com.gemstone.gemfire.internal.tcp.TCPConduit;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

public class MsgOutputStream
extends OutputStream
implements ObjToByteArraySerializer {
    private final ByteBuffer buffer;

    public MsgOutputStream(int allocSize) {
        this.buffer = TCPConduit.useDirectBuffers ? ByteBuffer.allocateDirect(allocSize) : ByteBuffer.allocate(allocSize);
        this.buffer.position(7);
    }

    @Override
    public final void write(int b) {
        this.buffer.put((byte)b);
    }

    @Override
    public final void write(byte[] source, int offset, int len) {
        this.buffer.put(source, offset, len);
    }

    private int size() {
        return this.buffer.position() - 7;
    }

    public final void setMessageHeader(int msgType, int processorType, short msgId) {
        this.buffer.putInt(0, Connection.calcHdrSize(this.size()));
        this.buffer.put(4, (byte)(msgType & 0xFF));
        this.buffer.putShort(5, msgId);
    }

    public final void reset() {
        this.buffer.clear();
        this.buffer.position(7);
    }

    public final ByteBuffer getContentBuffer() {
        this.buffer.flip();
        return this.buffer;
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.buffer.putShort((short)v);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.buffer.putChar((char)v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.buffer.putInt(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.buffer.putLong(v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.buffer.putFloat(v);
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.buffer.putDouble(v);
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        int strlen = str.length();
        if (strlen > 0) {
            if (this.buffer.hasArray()) {
                int pos = this.buffer.position();
                str.getBytes(0, strlen, this.buffer.array(), this.buffer.arrayOffset() + pos);
                this.buffer.position(pos + strlen);
            } else {
                byte[] bytes = new byte[strlen];
                str.getBytes(0, strlen, bytes, 0);
                this.buffer.put(bytes);
            }
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                this.buffer.putChar(s.charAt(i));
            }
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.writeFullUTF(str);
    }

    private final void writeFullUTF(String str) throws IOException {
        int strlen = str.length();
        if (strlen > 65535) {
            throw new UTFDataFormatException(LocalizedStrings.MsgOutputStream_STRING_TOO_LONG_FOR_JAVA_SERIALIZATION.toLocalizedString());
        }
        int utfSizeIdx = this.buffer.position();
        this.buffer.position(utfSizeIdx + 2);
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.buffer.put((byte)(0xE0 | c >> 12 & 0xF));
                this.buffer.put((byte)(0x80 | c >> 6 & 0x3F));
                this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.buffer.put((byte)(0xC0 | c >> 6 & 0x1F));
            this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
        }
        int utflen = this.buffer.position() - (utfSizeIdx + 2);
        if (utflen > 65535) {
            this.buffer.position(utfSizeIdx);
            throw new UTFDataFormatException(LocalizedStrings.MsgOutputStream_STRING_TOO_LONG_FOR_JAVA_SERIALIZATION.toLocalizedString());
        }
        this.buffer.putShort(utfSizeIdx, (short)utflen);
    }

    @Override
    public void writeAsSerializedByteArray(Object v) throws IOException {
        ByteBuffer sizeBuf = this.buffer;
        int sizePos = sizeBuf.position();
        sizeBuf.position(sizePos + 5);
        int preArraySize = this.size();
        DataSerializer.writeObject(v, this);
        int arraySize = this.size() - preArraySize;
        sizeBuf.put(sizePos, (byte)-3);
        sizeBuf.putInt(sizePos + 1, arraySize);
    }
}

