/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tcp;

import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.tcp.TCPConduit;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Buffers {
    private static final ConcurrentLinkedQueue bufferQueue = new ConcurrentLinkedQueue();

    static ByteBuffer acquireSenderBuffer(int size, DMStats stats) {
        return Buffers.acquireBuffer(size, stats, true);
    }

    static ByteBuffer acquireReceiveBuffer(int size, DMStats stats) {
        return Buffers.acquireBuffer(size, stats, false);
    }

    static ByteBuffer acquireBuffer(int size, DMStats stats, boolean send) {
        ByteBuffer result;
        if (TCPConduit.useDirectBuffers) {
            IdentityHashMap<BBSoftReference, BBSoftReference> alreadySeen = null;
            BBSoftReference ref = (BBSoftReference)bufferQueue.poll();
            while (ref != null) {
                ByteBuffer bb = ref.getBB();
                if (bb == null) {
                    int refSize = ref.consumeSize();
                    if (refSize > 0) {
                        if (ref.getSend()) {
                            stats.incSenderBufferSize(-refSize, true);
                        } else {
                            stats.incReceiverBufferSize(-refSize, true);
                        }
                    }
                } else {
                    if (bb.capacity() >= size) {
                        bb.rewind();
                        bb.limit(size);
                        return bb;
                    }
                    Assert.assertTrue(bufferQueue.offer(ref));
                    if (alreadySeen == null) {
                        alreadySeen = new IdentityHashMap<BBSoftReference, BBSoftReference>();
                    }
                    if (alreadySeen.put(ref, ref) != null) break;
                }
                ref = (BBSoftReference)bufferQueue.poll();
            }
            result = ByteBuffer.allocateDirect(size);
        } else {
            result = ByteBuffer.allocate(size);
        }
        if (send) {
            stats.incSenderBufferSize(size, TCPConduit.useDirectBuffers);
        } else {
            stats.incReceiverBufferSize(size, TCPConduit.useDirectBuffers);
        }
        return result;
    }

    static void releaseSenderBuffer(ByteBuffer bb, DMStats stats) {
        Buffers.releaseBuffer(bb, stats, true);
    }

    static void releaseReceiveBuffer(ByteBuffer bb, DMStats stats) {
        Buffers.releaseBuffer(bb, stats, false);
    }

    static void releaseBuffer(ByteBuffer bb, DMStats stats, boolean send) {
        if (TCPConduit.useDirectBuffers) {
            BBSoftReference bbRef = new BBSoftReference(bb, send);
            bufferQueue.offer(bbRef);
        } else if (send) {
            stats.incSenderBufferSize(-bb.capacity(), false);
        } else {
            stats.incReceiverBufferSize(-bb.capacity(), false);
        }
    }

    public static void initBufferStats(DMStats stats) {
        if (TCPConduit.useDirectBuffers) {
            for (BBSoftReference ref : bufferQueue) {
                if (ref.getBB() == null) continue;
                if (ref.getSend()) {
                    stats.incSenderBufferSize(ref.getSize(), true);
                    continue;
                }
                stats.incReceiverBufferSize(ref.getSize(), true);
            }
        }
    }

    private static class BBSoftReference
    extends SoftReference<ByteBuffer> {
        private int size;
        private final boolean send;

        public BBSoftReference(ByteBuffer bb, boolean send) {
            super(bb);
            this.size = bb.capacity();
            this.send = send;
        }

        public int getSize() {
            return this.size;
        }

        public synchronized int consumeSize() {
            int result = this.size;
            this.size = 0;
            return result;
        }

        public boolean getSend() {
            return this.send;
        }

        public ByteBuffer getBB() {
            return (ByteBuffer)super.get();
        }
    }
}

