/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.stats50;

import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.StatisticsImpl;
import com.gemstone.gemfire.internal.StatisticsManager;
import com.gemstone.gemfire.internal.StatisticsTypeImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;

public class Atomic50StatisticsImpl
extends StatisticsImpl {
    private final AtomicIntegerArray intStorage;
    private final AtomicIntegerArray intDirty;
    private final Object[] intReadPrepLock;
    private final AtomicLongArray longStorage;
    private final AtomicIntegerArray longDirty;
    private final Object[] longReadPrepLock;
    private final StatisticsManager dSystem;
    private final ConcurrentLinkedQueue<ThreadStorage> threadStoreQ = new ConcurrentLinkedQueue();
    private final CopyOnWriteArrayList<ThreadStorage> threadStoreList = new CopyOnWriteArrayList();
    private final ThreadLocal<ThreadStorage> threadStore = new ThreadLocal();
    private static final ThreadLocal samplerThread = new ThreadLocal();

    public Atomic50StatisticsImpl(StatisticsType type, String textId, long numericId, long uniqueId, StatisticsManager system) {
        super(type, Atomic50StatisticsImpl.calcTextId(system, textId), Atomic50StatisticsImpl.calcNumericId(system, numericId), uniqueId, 0);
        int i;
        this.dSystem = system;
        StatisticsTypeImpl realType = (StatisticsTypeImpl)type;
        if (realType.getDoubleStatCount() > 0) {
            throw new IllegalArgumentException(LocalizedStrings.Atomic50StatisticsImpl_ATOMICS_DO_NOT_SUPPORT_DOUBLE_STATS.toLocalizedString());
        }
        int intCount = realType.getIntStatCount();
        int longCount = realType.getLongStatCount();
        if (intCount > 0) {
            this.intStorage = new AtomicIntegerArray(intCount);
            this.intDirty = new AtomicIntegerArray(intCount);
            this.intReadPrepLock = new Object[intCount];
            for (i = 0; i < intCount; ++i) {
                this.intReadPrepLock[i] = new Object();
            }
        } else {
            this.intStorage = null;
            this.intDirty = null;
            this.intReadPrepLock = null;
        }
        if (longCount > 0) {
            this.longStorage = new AtomicLongArray(longCount);
            this.longDirty = new AtomicIntegerArray(longCount);
            this.longReadPrepLock = new Object[longCount];
            for (i = 0; i < longCount; ++i) {
                this.longReadPrepLock[i] = new Object();
            }
        } else {
            this.longStorage = null;
            this.longDirty = null;
            this.longReadPrepLock = null;
        }
    }

    private static long calcNumericId(StatisticsManager system, long userValue) {
        if (userValue != 0L) {
            return userValue;
        }
        long result = OSProcess.getId();
        if (result == 0L && system != null) {
            result = system.getId();
        }
        return result;
    }

    private static String calcTextId(StatisticsManager system, String userValue) {
        if (userValue != null && !userValue.equals("")) {
            return userValue;
        }
        if (system != null) {
            return system.getName();
        }
        return "";
    }

    @Override
    public final boolean isAtomic() {
        return true;
    }

    @Override
    public void close() {
        super.close();
        if (this.dSystem != null) {
            this.dSystem.destroyStatistics(this);
        }
    }

    private ThreadStorage getThreadStorage() {
        ThreadStorage result = this.threadStore.get();
        if (result == null) {
            int intSize = 0;
            int longSize = 0;
            if (this.intStorage != null) {
                intSize = this.intStorage.length();
            }
            if (this.longStorage != null) {
                longSize = this.longStorage.length();
            }
            result = new ThreadStorage(intSize, longSize);
            this.threadStore.set(result);
            this.threadStoreQ.add(result);
        }
        return result;
    }

    private ThreadStorage getThreadStorageForWrite() {
        ThreadStorage result = this.getThreadStorage();
        if (!result.dirty) {
            result.dirty = true;
        }
        return result;
    }

    private AtomicIntegerArray getThreadIntStorage() {
        return this.getThreadStorageForWrite().intStore;
    }

    private AtomicLongArray getThreadLongStorage() {
        return this.getThreadStorageForWrite().longStore;
    }

    @Override
    protected final void _setInt(int offset, int value) {
        this.doIntWrite(offset, value);
    }

    @Override
    protected final void _setLong(int offset, long value) {
        this.doLongWrite(offset, value);
    }

    @Override
    protected final void _setDouble(int offset, double value) {
        throw new IllegalStateException(LocalizedStrings.Atomic50StatisticsImpl_DOUBLE_STATS_NOT_ON_ATOMIC50.toLocalizedString());
    }

    @Override
    protected final int _getInt(int offset) {
        return this.doIntRead(offset);
    }

    @Override
    protected final long _getLong(int offset) {
        return this.doLongRead(offset);
    }

    @Override
    protected final double _getDouble(int offset) {
        throw new IllegalStateException(LocalizedStrings.Atomic50StatisticsImpl_DOUBLE_STATS_NOT_ON_ATOMIC50.toLocalizedString());
    }

    @Override
    protected final void _incInt(int offset, int delta) {
        this.getThreadIntStorage().getAndAdd(offset, delta);
        this.setIntDirty(offset);
    }

    @Override
    protected final void _incLong(int offset, long delta) {
        this.getThreadLongStorage().getAndAdd(offset, delta);
        this.setLongDirty(offset);
    }

    @Override
    protected final void _incDouble(int offset, double delta) {
        throw new IllegalStateException(LocalizedStrings.Atomic50StatisticsImpl_DOUBLE_STATS_NOT_ON_ATOMIC50.toLocalizedString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="findbugs complains about this synchronize. It could be changed to a sync on a dedicated Object instance to make findbugs happy. see comments below")
    private void prepareThreadStoreList() {
        CopyOnWriteArrayList<ThreadStorage> copyOnWriteArrayList = this.threadStoreList;
        synchronized (copyOnWriteArrayList) {
            ThreadStorage ts = this.threadStoreQ.poll();
            if (ts == null) {
                return;
            }
            ArrayList<ThreadStorage> tmp = new ArrayList<ThreadStorage>(64);
            do {
                tmp.add(ts);
            } while ((ts = this.threadStoreQ.poll()) != null);
            if (tmp.size() > 0) {
                this.threadStoreList.addAll(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareForSample() {
        if (samplerThread.get() == null) {
            samplerThread.set(Boolean.TRUE);
        }
        this.prepareThreadStoreList();
        ArrayList<ThreadStorage> removed = null;
        for (ThreadStorage ts : this.threadStoreList) {
            Object object;
            int i;
            if (!ts.isAlive()) {
                if (removed == null) {
                    removed = new ArrayList<ThreadStorage>(64);
                }
                removed.add(ts);
            }
            if (!ts.dirty) continue;
            ts.dirty = false;
            if (ts.intStore != null) {
                for (i = 0; i < ts.intStore.length(); ++i) {
                    object = this.intReadPrepLock[i];
                    synchronized (object) {
                        int delta = ts.intStore.getAndSet(i, 0);
                        if (delta != 0) {
                            this.intStorage.getAndAdd(i, delta);
                        }
                        continue;
                    }
                }
            }
            if (ts.longStore == null) continue;
            for (i = 0; i < ts.longStore.length(); ++i) {
                object = this.longReadPrepLock[i];
                synchronized (object) {
                    long delta = ts.longStore.getAndSet(i, 0L);
                    if (delta != 0L) {
                        this.longStorage.getAndAdd(i, delta);
                    }
                    continue;
                }
            }
        }
        if (removed != null) {
            this.threadStoreList.removeAll(removed);
        }
    }

    private final boolean isIntDirty(int idx) {
        return this.intDirty.get(idx) != 0;
    }

    private final boolean isLongDirty(int idx) {
        return this.longDirty.get(idx) != 0;
    }

    private final boolean clearIntDirty(int idx) {
        if (!this.intDirty.weakCompareAndSet(idx, 1, 0)) {
            return this.intDirty.compareAndSet(idx, 1, 0);
        }
        return true;
    }

    private final boolean clearLongDirty(int idx) {
        if (!this.longDirty.weakCompareAndSet(idx, 1, 0)) {
            return this.longDirty.compareAndSet(idx, 1, 0);
        }
        return true;
    }

    private final void setIntDirty(int idx) {
        if (!this.intDirty.weakCompareAndSet(idx, 0, 1) && !this.isIntDirty(idx)) {
            this.intDirty.set(idx, 1);
        }
    }

    private final void setLongDirty(int idx) {
        if (!this.longDirty.weakCompareAndSet(idx, 0, 1) && !this.isLongDirty(idx)) {
            this.longDirty.set(idx, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int doIntRead(int idx) {
        if (samplerThread.get() != null) {
            return this.intStorage.get(idx);
        }
        Object object = this.intReadPrepLock[idx];
        synchronized (object) {
            if (!this.isIntDirty(idx)) {
                return this.intStorage.get(idx);
            }
        }
        this.prepareThreadStoreList();
        object = this.intReadPrepLock[idx];
        synchronized (object) {
            if (!this.clearIntDirty(idx)) {
                return this.intStorage.get(idx);
            }
            int delta = 0;
            for (ThreadStorage ts : this.threadStoreList) {
                delta += ts.intStore.getAndSet(idx, 0);
            }
            if (delta != 0) {
                return this.intStorage.addAndGet(idx, delta);
            }
            return this.intStorage.get(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doIntWrite(int idx, int value) {
        Object object = this.intReadPrepLock[idx];
        synchronized (object) {
            if (!this.isIntDirty(idx)) {
                this.intStorage.set(idx, value);
                return;
            }
        }
        this.prepareThreadStoreList();
        object = this.intReadPrepLock[idx];
        synchronized (object) {
            if (this.clearIntDirty(idx)) {
                for (ThreadStorage ts : this.threadStoreList) {
                    if (ts.intStore.get(idx) == 0) continue;
                    ts.intStore.set(idx, 0);
                }
            }
            this.intStorage.set(idx, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long doLongRead(int idx) {
        if (samplerThread.get() != null) {
            return this.longStorage.get(idx);
        }
        Object object = this.longReadPrepLock[idx];
        synchronized (object) {
            if (!this.isLongDirty(idx)) {
                return this.longStorage.get(idx);
            }
        }
        this.prepareThreadStoreList();
        object = this.longReadPrepLock[idx];
        synchronized (object) {
            if (!this.clearLongDirty(idx)) {
                return this.longStorage.get(idx);
            }
            long delta = 0L;
            for (ThreadStorage ts : this.threadStoreList) {
                delta += ts.longStore.getAndSet(idx, 0L);
            }
            if (delta != 0L) {
                return this.longStorage.addAndGet(idx, delta);
            }
            return this.longStorage.get(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doLongWrite(int idx, long value) {
        Object object = this.longReadPrepLock[idx];
        synchronized (object) {
            if (!this.isLongDirty(idx)) {
                this.longStorage.set(idx, value);
                return;
            }
        }
        this.prepareThreadStoreList();
        object = this.longReadPrepLock[idx];
        synchronized (object) {
            if (this.clearLongDirty(idx)) {
                for (ThreadStorage ts : this.threadStoreList) {
                    if (ts.longStore.get(idx) == 0L) continue;
                    ts.longStore.set(idx, 0L);
                }
            }
            this.longStorage.set(idx, value);
        }
    }

    final int[] _getIntStorage() {
        throw new IllegalStateException(LocalizedStrings.Atomic50StatisticsImpl_DIRECT_ACCESS_NOT_ON_ATOMIC50.toLocalizedString());
    }

    final long[] _getLongStorage() {
        throw new IllegalStateException(LocalizedStrings.Atomic50StatisticsImpl_DIRECT_ACCESS_NOT_ON_ATOMIC50.toLocalizedString());
    }

    final double[] _getDoubleStorage() {
        throw new IllegalStateException(LocalizedStrings.Atomic50StatisticsImpl_DIRECT_ACCESS_NOT_ON_ATOMIC50.toLocalizedString());
    }

    private static class ThreadStorage {
        private final Thread owner = Thread.currentThread();
        public volatile boolean dirty = false;
        public final AtomicIntegerArray intStore;
        public final AtomicLongArray longStore;

        public boolean isAlive() {
            return this.owner.isAlive();
        }

        public ThreadStorage(int intSize, int longSize) {
            this.intStore = intSize > 0 ? new AtomicIntegerArray(intSize) : null;
            this.longStore = longSize > 0 ? new AtomicLongArray(longSize) : null;
        }
    }
}

