/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.statistics;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.statistics.ResourceInstance;
import com.gemstone.gemfire.internal.statistics.ResourceType;
import com.gemstone.gemfire.internal.statistics.SampleHandler;
import com.gemstone.gemfire.internal.statistics.StatisticsMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import org.apache.logging.log4j.Logger;

public class StatMonitorHandler
implements SampleHandler {
    private static final Logger logger = LogService.getLogger();
    static final String ENABLE_MONITOR_THREAD = "gemfire.stats.enableMonitorThread";
    static final boolean enableMonitorThread = Boolean.getBoolean("gemfire.stats.enableMonitorThread");
    private volatile List<StatisticsMonitor> monitors = Collections.emptyList();
    private volatile StatMonitorNotifier notifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMonitor(StatisticsMonitor monitor) {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            boolean added = false;
            List<StatisticsMonitor> oldMonitors = this.monitors;
            if (!oldMonitors.contains(monitor)) {
                ArrayList<StatisticsMonitor> newMonitors = new ArrayList<StatisticsMonitor>(oldMonitors);
                added = newMonitors.add(monitor);
                this.monitors = Collections.unmodifiableList(newMonitors);
            }
            if (enableMonitorThread && !this.monitors.isEmpty() && this.notifier == null) {
                this.notifier = new StatMonitorNotifier();
                this.notifier.start();
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMonitor(StatisticsMonitor monitor) {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            boolean removed = false;
            List<StatisticsMonitor> oldMonitors = this.monitors;
            if (oldMonitors.contains(monitor)) {
                ArrayList<StatisticsMonitor> newMonitors = new ArrayList<StatisticsMonitor>(oldMonitors);
                removed = newMonitors.remove(monitor);
                this.monitors = Collections.unmodifiableList(newMonitors);
            }
            if (enableMonitorThread && this.monitors.isEmpty() && this.notifier != null) {
                this.notifier.stop();
                this.notifier = null;
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            if (enableMonitorThread && this.notifier != null) {
                this.notifier.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampled(long nanosTimeStamp, List<ResourceInstance> resourceInstances) {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            if (enableMonitorThread) {
                StatMonitorNotifier thread = this.notifier;
                if (thread != null) {
                    try {
                        thread.monitor(new MonitorTask(System.currentTimeMillis(), resourceInstances));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            } else {
                this.monitor(System.currentTimeMillis(), resourceInstances);
            }
        }
    }

    private void monitor(long sampleTimeMillis, List<ResourceInstance> resourceInstance) {
        List<StatisticsMonitor> currentMonitors = this.monitors;
        for (StatisticsMonitor monitor : currentMonitors) {
            try {
                monitor.monitor(sampleTimeMillis, resourceInstance);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.warn(LogMarker.STATISTICS, "StatisticsMonitor {} threw {}", new Object[]{monitor, e.getClass().getSimpleName(), e});
            }
            catch (RuntimeException e) {
                logger.warn(LogMarker.STATISTICS, "StatisticsMonitor {} threw {}", new Object[]{monitor, e.getClass().getSimpleName(), e});
            }
        }
    }

    @Override
    public void allocatedResourceType(ResourceType resourceType) {
    }

    @Override
    public void allocatedResourceInstance(ResourceInstance resourceInstance) {
    }

    @Override
    public void destroyedResourceInstance(ResourceInstance resourceInstance) {
    }

    List<StatisticsMonitor> getMonitorsSnapshot() {
        return Collections.unmodifiableList(this.monitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatMonitorNotifier getStatMonitorNotifier() {
        StatMonitorHandler statMonitorHandler = this;
        synchronized (statMonitorHandler) {
            return this.notifier;
        }
    }

    static class MonitorTask {
        private final long sampleTimeMillis;
        private final List<ResourceInstance> resourceInstances;

        MonitorTask(long sampleTimeMillis, List<ResourceInstance> resourceInstances) {
            this.sampleTimeMillis = sampleTimeMillis;
            this.resourceInstances = resourceInstances;
        }

        long getSampleTimeMillis() {
            return this.sampleTimeMillis;
        }

        List<ResourceInstance> getResourceInstances() {
            return this.resourceInstances;
        }
    }

    class StatMonitorNotifier
    implements Runnable {
        private volatile boolean alive;
        private Thread consumer;
        private boolean waiting;
        private Thread producer;
        private final SynchronousQueue<MonitorTask> task = new SynchronousQueue();

        StatMonitorNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS);
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS, "StatMonitorNotifier is starting {}", new Object[]{this});
            }
            try {
                this.work();
            }
            finally {
                StatMonitorNotifier statMonitorNotifier = this;
                synchronized (statMonitorNotifier) {
                    this.alive = false;
                    if (this.producer != null) {
                        this.producer.interrupt();
                    }
                }
            }
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS, "StatMonitorNotifier is stopping {}", new Object[]{this});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void work() {
            boolean working = true;
            while (working) {
                StatMonitorNotifier statMonitorNotifier;
                try {
                    MonitorTask latestTask = null;
                    statMonitorNotifier = this;
                    synchronized (statMonitorNotifier) {
                        working = this.alive;
                        if (working) {
                            this.waiting = true;
                        }
                    }
                    if (working) {
                        try {
                            latestTask = this.task.take();
                        }
                        finally {
                            statMonitorNotifier = this;
                            synchronized (statMonitorNotifier) {
                                this.waiting = false;
                                working = this.alive;
                            }
                        }
                    }
                    if (!working || latestTask == null) continue;
                    List currentMonitors = StatMonitorHandler.this.monitors;
                    for (StatisticsMonitor monitor : currentMonitors) {
                        try {
                            monitor.monitor(latestTask.getSampleTimeMillis(), latestTask.getResourceInstances());
                        }
                        catch (VirtualMachineError e) {
                            SystemFailure.initiateFailure(e);
                            throw e;
                        }
                        catch (Error e) {
                            SystemFailure.checkFailure();
                            logger.warn(LogMarker.STATISTICS, "StatisticsMonitor {} threw {}", new Object[]{monitor, e.getClass().getSimpleName(), e});
                        }
                        catch (RuntimeException e) {
                            logger.warn(LogMarker.STATISTICS, "StatisticsMonitor {} threw {}", new Object[]{monitor, e.getClass().getSimpleName(), e});
                        }
                    }
                }
                catch (InterruptedException e) {
                    statMonitorNotifier = this;
                    synchronized (statMonitorNotifier) {
                        working = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                if (this.consumer == null) {
                    this.consumer = new Thread((Runnable)this, this.toString());
                    this.consumer.setDaemon(true);
                    this.alive = true;
                    this.consumer.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                if (this.consumer != null) {
                    this.alive = false;
                    this.consumer.interrupt();
                    this.consumer = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void monitor(MonitorTask task) throws InterruptedException {
            boolean isAlive = false;
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                if (this.alive) {
                    isAlive = true;
                    this.producer = Thread.currentThread();
                }
            }
            if (isAlive) {
                try {
                    this.task.put(task);
                }
                catch (InterruptedException interruptedException) {
                    StatMonitorNotifier statMonitorNotifier2 = this;
                    synchronized (statMonitorNotifier2) {
                        this.producer = null;
                    }
                }
                finally {
                    statMonitorNotifier = this;
                    synchronized (statMonitorNotifier) {
                        this.producer = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isWaiting() {
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                return this.waiting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAlive() {
            StatMonitorNotifier statMonitorNotifier = this;
            synchronized (statMonitorNotifier) {
                return this.alive;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append(" Thread").append(" #").append(System.identityHashCode(this));
            return sb.toString();
        }
    }
}

